/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.base.Objects;
import com.vmware.vim.binding.rbd.HostOps;
import com.vmware.vim.binding.rbd.PxeProfile;
import com.vmware.vim.binding.rbd.RuleSet;
import com.vmware.vim.binding.rbd.ScriptBundle;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.host.DeployedHost;
import com.vmware.vsphere.client.h5.autodeploy.rule.HostComplianceData;
import com.vmware.vsphere.client.h5.autodeploy.util.HostComplianceHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class HostOpsPropertyProvider
implements PropertyProviderBean {
    private final AutoDeployServiceFactory _adServiceFactory;
    private final QueryExecutor _queryExecutor;

    public HostOpsPropertyProvider(AutoDeployServiceFactory adServiceFactory, QueryExecutor queryExecutor) {
        this._adServiceFactory = adServiceFactory;
        this._queryExecutor = queryExecutor;
    }

    @type(value="Folder")
    public HostOps.DiscoveredHost[] getNonDeployedHosts(ManagedObjectReference rootFolder) {
        AutoDeployService adService = this._adServiceFactory.getService(rootFolder.getServerGuid());
        HostOps hostOps = adService.getHostOps();
        HostOps.DiscoveredHost[] hosts = hostOps.retrieveDiscoveredHosts();
        return (HostOps.DiscoveredHost[])Objects.firstNonNull((Object)hosts, (Object)new HostOps.DiscoveredHost[0]);
    }

    @type(value="Folder")
    public ManagedObjectReference[] getDeployedHostReferences(ManagedObjectReference rootFolder) {
        AutoDeployService adService = this._adServiceFactory.getService(rootFolder.getServerGuid());
        HostOps hostOps = adService.getHostOps();
        HostOps.HostAssociation[] associations = hostOps.retrieveHostAssociations(null);
        if (associations == null) {
            return new ManagedObjectReference[0];
        }
        ManagedObjectReference[] result = new ManagedObjectReference[associations.length];
        for (int i = 0; i < associations.length; ++i) {
            result[i] = associations[i].hostMoref;
        }
        return result;
    }

    @type(value="Folder")
    public HostComplianceData[] getComplianceCheckResults(ManagedObjectReference rootFolder, String token) {
        Validate.notNull((Object)rootFolder);
        Validate.notNull((Object)token);
        AutoDeployService autoDeploy = this._adServiceFactory.getService(rootFolder.getServerGuid());
        ManagedObjectReference liveRulesetMo = autoDeploy.getRuleManager().getLiveRuleSetList()[0];
        RuleSet liveRuleset = (RuleSet)autoDeploy.getManagedObject(liveRulesetMo);
        RuleSet.BulkCheckResult[] results = liveRuleset.getComplianceCheckResult(token);
        HostComplianceHelper helper = new HostComplianceHelper(this, this._queryExecutor);
        return helper.retrieveHostItemsData(results);
    }

    @type(value="Folder")
    public DeployedHost[] getDeployedHosts(ManagedObjectReference rootFolder, ManagedObjectReference hostParam) {
        Map<ManagedObjectReference, ManagedObjectReference> hostLocations;
        AutoDeployService adService = this._adServiceFactory.getService(rootFolder.getServerGuid());
        HostOps hostOps = adService.getHostOps();
        HostOps.HostAssociation[] associations = hostOps.retrieveHostAssociations(hostParam);
        if (associations == null) {
            return new DeployedHost[0];
        }
        ManagedObjectReference[] hosts = new ManagedObjectReference[associations.length];
        HashSet<ManagedObjectReference> namedObjects = new HashSet<ManagedObjectReference>();
        for (int i = 0; i < associations.length; ++i) {
            hosts[i] = associations[i].hostMoref;
            namedObjects.add(associations[i].hostMoref);
            Collections.addAll(namedObjects, associations[i].associations);
        }
        try {
            hostLocations = this.retrieveHostLocations(hosts);
        }
        catch (Exception e) {
            RuntimeFault rf = new RuntimeFault("Unable to retrieve host locations");
            rf.setFaultCause(e);
            throw rf;
        }
        namedObjects.addAll(hostLocations.values());
        HashMap<ManagedObjectReference, String> entityNames = new HashMap<ManagedObjectReference, String>();
        try {
            PropertyValue[] nameQueryResult;
            for (PropertyValue pv : nameQueryResult = this._queryExecutor.getProperty((Object[])namedObjects.toArray(new ManagedObjectReference[namedObjects.size()]), "name")) {
                entityNames.put((ManagedObjectReference)pv.resourceObject, (String)pv.value);
            }
        }
        catch (Exception e) {
            RuntimeFault rf = new RuntimeFault("Unable to retrieve association names");
            rf.setFaultCause(e);
            throw rf;
        }
        DeployedHost[] result = new DeployedHost[hosts.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = HostOpsPropertyProvider.createDeployedHostRow(associations[i], hostLocations.get(associations[i].hostMoref), entityNames);
        }
        return result;
    }

    private Map<ManagedObjectReference, ManagedObjectReference> retrieveHostLocations(ManagedObjectReference[] hosts) throws Exception {
        Map<ManagedObjectReference, ManagedObjectReference> result = this.getPropertyMap(hosts, "parent");
        HashSet<ManagedObjectReference> computeResources = new HashSet<ManagedObjectReference>();
        for (ManagedObjectReference hp : result.values()) {
            if (!ComputeResource.class.getSimpleName().equals(hp.getType())) continue;
            computeResources.add(hp);
        }
        if (computeResources.size() == 0) {
            return result;
        }
        Map crParents = this.getPropertyMap(computeResources.toArray(new ManagedObjectReference[computeResources.size()]), "parent");
        Map folderParents = this.getPropertyMap(crParents.values().toArray(new ManagedObjectReference[crParents.values().size()]), "parent");
        for (Map.Entry<ManagedObjectReference, ManagedObjectReference> e : result.entrySet()) {
            ManagedObjectReference hostParent = e.getValue();
            if (!ComputeResource.class.getSimpleName().equals(hostParent.getType())) continue;
            ManagedObjectReference crParent = (ManagedObjectReference)crParents.get(hostParent);
            ManagedObjectReference folderParent = (ManagedObjectReference)folderParents.get(crParent);
            if (Datacenter.class.getSimpleName().equals(folderParent.getType())) {
                e.setValue(folderParent);
                continue;
            }
            e.setValue(crParent);
        }
        return result;
    }

    private <T> Map<ManagedObjectReference, T> getPropertyMap(ManagedObjectReference[] objects, String property) throws Exception {
        PropertyValue[] propertyValues;
        HashMap<ManagedObjectReference, Object> result = new HashMap<ManagedObjectReference, Object>();
        for (PropertyValue pv : propertyValues = this._queryExecutor.getProperty((Object[])objects, property)) {
            result.put((ManagedObjectReference)pv.resourceObject, pv.value);
        }
        return result;
    }

    private static DeployedHost createDeployedHostRow(HostOps.HostAssociation assoc, ManagedObjectReference location, Map<ManagedObjectReference, String> entityNames) {
        DeployedHost result = new DeployedHost();
        result.host = assoc.hostMoref;
        result.hostName = entityNames.get(assoc.hostMoref);
        result.location = location;
        result.locationName = entityNames.get(location);
        for (ManagedObjectReference item : assoc.associations) {
            assert (entityNames.containsKey(item));
            if (PxeProfile.class.getSimpleName().equals(item.getType())) {
                result.pxeProfile = item;
                result.pxeProfileName = entityNames.get(item);
                continue;
            }
            if (HostProfile.class.getSimpleName().equals(item.getType())) {
                result.hostProfile = item;
                result.hostProfileName = entityNames.get(item);
                continue;
            }
            if (!ScriptBundle.class.getSimpleName().equals(item.getType())) continue;
            result.scriptBundle = item;
            result.scriptBundleName = entityNames.get(item);
        }
        return result;
    }
}

