/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.rbd.ScriptBundle;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptBundlePropertyProviderAdapter
implements PropertyProviderAdapter {
    private final AutoDeployServiceFactory _autoDeployServiceFactory;
    private final QueryExecutor _queryExecutor;
    private static final String NAME = "name";
    private static final String SCRIPT_BUNDLE_TYPE = "rbd1:ScriptBundle";
    private static final Log _logger = LogFactory.getLog(ScriptBundlePropertyProviderAdapter.class);

    public ScriptBundlePropertyProviderAdapter(DataServiceExtensionRegistry registry, AutoDeployServiceFactory autoDeployServiceFactory, QueryExecutor queryExecutor) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._autoDeployServiceFactory = autoDeployServiceFactory;
        this._queryExecutor = queryExecutor;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = SCRIPT_BUNDLE_TYPE;
        typeInfo.properties = new String[]{NAME, "grantedPrivileges"};
        return new TypeInfo[]{typeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Object[] objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            String[] stringArray = propSpec.propertyNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String propName = stringArray[i];
                reqPropSet.add(propName);
            }
        }
        ResultSet result = new ResultSet();
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        for (Object object : objects = propertyRequest.objects) {
            if (!(object instanceof ManagedObjectReference)) continue;
            ManagedObjectReference scriptBundleRef = (ManagedObjectReference)object;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = object;
            resultItem.properties = this.computePropertyValues(reqPropSet, scriptBundleRef);
            items.add(resultItem);
        }
        result.items = items.toArray(new ResultItem[items.size()]);
        return result;
    }

    private PropertyValue[] computePropertyValues(Set<String> reqProps, ManagedObjectReference scriptBundleRef) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        String serverGuid = scriptBundleRef.getServerGuid();
        if (reqProps.contains(NAME)) {
            HashMap<String, AutoDeployService> autoDeployServices = new HashMap<String, AutoDeployService>();
            if (!autoDeployServices.containsKey(serverGuid)) {
                autoDeployServices.put(serverGuid, this._autoDeployServiceFactory.getService(serverGuid));
            }
            AutoDeployService autoDeploy = (AutoDeployService)autoDeployServices.get(scriptBundleRef.getServerGuid());
            ScriptBundle scriptBundle = (ScriptBundle)autoDeploy.getManagedObject(scriptBundleRef);
            String name = scriptBundle.getMetadata().getName();
            result.add(this.createPropValue(NAME, name, scriptBundleRef));
        }
        if (reqProps.contains("grantedPrivileges")) {
            try {
                Object grantedPrivileges = this._queryExecutor.getProperty((Object)ManagedObjectUtil.getRootFolder((String)serverGuid), "grantedPrivileges");
                result.add(this.createPropValue("grantedPrivileges", grantedPrivileges, scriptBundleRef));
            }
            catch (Exception e) {
                _logger.error((Object)"Could not retrieve privileges for VC root folder", (Throwable)e);
            }
        }
        return result.toArray(new PropertyValue[result.size()]);
    }

    private PropertyValue createPropValue(String name, Object value, Object resourceObject) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = resourceObject;
        return propValue;
    }
}

