/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.util;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;

public class CommonReferenceUtil {
    public static boolean isReferenceOfType(Object ref, String type2, ObjectReferenceService objectReferenceService) {
        assert (type2 != null);
        if (ref == null || !(ref instanceof URI)) {
            return false;
        }
        String uriType = objectReferenceService.getResourceObjectType(ref);
        return type2.equals(uriType);
    }

    public static String getIdSegmentDecoded(URI uri, int idSegmentIndex) {
        assert (uri != null);
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)uri);
        if (segments.length <= idSegmentIndex) {
            return null;
        }
        return CommonReferenceUtil.decodeString(segments[idSegmentIndex]);
    }

    public static String getIdSegmentDecodedAsUrl(URI uri, int idSegmentIndex) {
        assert (uri != null);
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)uri);
        if (segments.length <= idSegmentIndex) {
            return null;
        }
        return CommonReferenceUtil.decodeUrlString(segments[idSegmentIndex]);
    }

    public static String decodeString(String str) {
        if (str == null || str.equals("null")) {
            return null;
        }
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String decodeUrlString(String str) {
        if (str == null || str.equals("null")) {
            return null;
        }
        return new String(Base64.decodeBase64((String)str), StandardCharsets.UTF_8);
    }

    public static String encodeUrlString(String str) {
        if (str == null) {
            return "null";
        }
        return Base64.encodeBase64URLSafeString((byte[])str.getBytes(StandardCharsets.UTF_8));
    }

    public static String encodeString(String str) {
        if (str == null) {
            return "null";
        }
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

