/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample;

import com.vmware.samples.htmlsample.model.Chassis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FakeChassisStore {
    private static final int CHASSIS_INITIAL_COUNT = 4;
    private static final String CHASSIS_ID = "chassis:%s";
    private static final String CHASSIS_NAME = "Chassis %s";
    private static final String CHASSIS_SERVER_TYPE = "Server_Type %s";
    private static final String CHASSIS_DIMENSIONS = "20in x 30in x 17in";
    private static int _index = 0;
    private Map<String, Chassis> _fakeStore;

    public void init() {
        HashMap store = new HashMap(4);
        this._fakeStore = Collections.synchronizedMap(store);
        for (int i = 0; i < 4; ++i) {
            Chassis newChassis = new Chassis();
            newChassis.name = String.format(CHASSIS_NAME, i);
            newChassis.serverType = String.format(CHASSIS_SERVER_TYPE, i);
            newChassis.dimensions = CHASSIS_DIMENSIONS;
            newChassis.isActive = false;
            this.create(newChassis);
        }
    }

    public void destroy() {
        this._fakeStore.clear();
    }

    public List<Chassis> getObjects() {
        return new ArrayList<Chassis>(this._fakeStore.values());
    }

    public Chassis getObjectById(String id) {
        if (id == null) {
            return null;
        }
        return this._fakeStore.get(id);
    }

    public Chassis create(Chassis chassis) {
        if (chassis == null || !this.isNameUnique(chassis.name)) {
            return null;
        }
        chassis.id = FakeChassisStore.generateId();
        this._fakeStore.put(chassis.id, chassis);
        return chassis;
    }

    public boolean update(Chassis chassis) {
        if (chassis == null) {
            return false;
        }
        boolean updatingTheSameChassis = chassis.name.equals(this._fakeStore.get((Object)chassis.id).name);
        if (!updatingTheSameChassis && !this.isNameUnique(chassis.name)) {
            return false;
        }
        Chassis updatedChassis = this._fakeStore.put(chassis.id, chassis);
        return updatedChassis != null;
    }

    public Chassis delete(String id) {
        if (id == null) {
            return null;
        }
        return this._fakeStore.remove(id);
    }

    private static String generateId() {
        return String.format(CHASSIS_ID, _index++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNameUnique(String name) {
        Map<String, Chassis> map = this._fakeStore;
        synchronized (map) {
            for (Chassis chassis : this._fakeStore.values()) {
                if (!name.equals(chassis.name)) continue;
                return false;
            }
            return true;
        }
    }
}

