/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample.services;

import com.vmware.samples.htmlsample.model.Host;
import com.vmware.samples.htmlsample.services.VcInfoService;
import com.vmware.samples.htmlsample.vim25.services.VimObjectService;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcInfoServiceImpl
implements VcInfoService {
    private final UserSessionService _userSessionService;
    private final VimObjectService _vimObjectService;
    private static final Log _logger = LogFactory.getLog(VcInfoServiceImpl.class);

    public VcInfoServiceImpl(UserSessionService userSessionService, VimObjectService vimObjectService) {
        this._userSessionService = userSessionService;
        this._vimObjectService = vimObjectService;
    }

    @Override
    public List<Host> getRelatedHosts() {
        ArrayList<Host> connectedHosts = new ArrayList<Host>();
        String expectedState = "connected";
        if (this._userSessionService.getUserSession() == null) {
            _logger.warn((Object)"The UserSession is null.");
            return connectedHosts;
        }
        for (ServerInfo serverInfoObject : this._userSessionService.getUserSession().serversInfo) {
            List<Host> retrievedHosts = this._vimObjectService.retrieveHosts(serverInfoObject);
            for (Host host : retrievedHosts) {
                if (!"connected".equals(host.state)) continue;
                host.state = Character.toUpperCase(host.state.charAt(0)) + host.state.substring(1);
                connectedHosts.add(host);
            }
        }
        return connectedHosts;
    }

    @Override
    public Map<String, String> getServerInfos() {
        HashMap<String, String> serverInfos = new HashMap<String, String>();
        if (this._userSessionService.getUserSession() == null) {
            _logger.warn((Object)"The user session is null.");
            return serverInfos;
        }
        for (ServerInfo serverInfo : this._userSessionService.getUserSession().serversInfo) {
            serverInfos.put(serverInfo.name, serverInfo.serviceGuid);
        }
        return serverInfos;
    }
}

