/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.automatic.plugin.registration.commands.PluginRegistryCmd;
import com.vmware.automatic.plugin.registration.services.ConnectionService;
import com.vmware.automatic.plugin.registration.services.PluginExtensionRegistryService;
import com.vmware.vim25.Extension;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class RegisterPluginCmd
extends PluginRegistryCmd {
    public RegisterPluginCmd(ConnectionService connectionService, PluginExtensionRegistryService registryService, CommandLineParser parser) {
        super(connectionService, registryService, parser);
    }

    @Override
    public Options getPluginOpts() {
        Options options = super.getPluginOpts();
        options.addOption(Option.builder("pu").longOpt("pluginUrl").hasArg().argName("plugin url").required().desc("Url where the plugin will be downloaded from.").build());
        options.addOption(Option.builder("v").longOpt("version").hasArg().argName("version").required().desc("Plugin version.").build());
        return options;
    }

    @Override
    protected void doExecute() throws Exception {
        String url = this._commandLine.getOptionValue("url");
        String key = this._commandLine.getOptionValue("k");
        Extension extension = new Extension();
        this.registryService.updateTopLevelProperties(extension, this._commandLine);
        this.registryService.updateDescription(extension, this._commandLine);
        this.registryService.updateClientInfo(extension, this._commandLine);
        this.registryService.updateResourceInfo(extension, this._commandLine);
        this.registryService.updateServerInfo(extension, this._commandLine);
        this.registryService.updatelastHeartbeatTime(extension);
        this.connectionService.getVimPort().registerExtension(this.connectionService.getExtensionManager(), extension);
        System.out.println(String.format("Plugin '%s' has been successfully registered to vCenter <%s>.", key, url));
    }
}

