/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning;

import com.vmware.vcenter.ovf.VServiceDependency;
import com.vmware.vcenter.ovf.VServiceParams;
import com.vmware.vcenter.ovf.VServiceProvider;
import com.vmware.vsphere.client.provisioning.spec.VServiceInfo;
import com.vmware.vsphere.client.provisioning.spec.VirtualServiceBindingStatus;
import com.vmware.vsphere.client.provisioning.spec.VirtualServiceDependency;
import com.vmware.vsphere.client.provisioning.spec.VirtualServiceProvider;
import java.util.List;

public class VServiceInfoFactory {
    public VServiceInfo createVServiceInfo(VServiceParams params) {
        VServiceInfo serviceInfo = new VServiceInfo();
        serviceInfo.dependencies = new VirtualServiceDependency[0];
        if (params == null) {
            return serviceInfo;
        }
        List dependencyParams = params.getDependencies();
        serviceInfo.dependencies = new VirtualServiceDependency[dependencyParams.size()];
        int index = 0;
        for (VServiceDependency dependencyParam : dependencyParams) {
            serviceInfo.dependencies[index] = VServiceInfoFactory.createFromVServiceDependency(dependencyParam);
            ++index;
        }
        return serviceInfo;
    }

    private static VirtualServiceDependency createFromVServiceDependency(VServiceDependency serviceDependency) {
        VirtualServiceDependency dependency = new VirtualServiceDependency();
        dependency.id = serviceDependency.getId();
        dependency.name = serviceDependency.getName();
        dependency.description = serviceDependency.getDescription();
        dependency.optional = serviceDependency.getRequired();
        dependency.providerKey = serviceDependency.getSelectedProviderKey();
        List serviceProviders = serviceDependency.getAvailableProviders();
        int providersCount = serviceProviders == null ? 0 : serviceProviders.size();
        dependency.availableProviders = new VirtualServiceProvider[providersCount];
        int index = 0;
        for (VServiceProvider provider : serviceProviders) {
            dependency.availableProviders[index] = VServiceInfoFactory.createFromVServiceProvider(provider);
            if (dependency.status == null && dependency.providerKey == null) {
                dependency.providerKey = provider.getKey();
                dependency.status = VirtualServiceBindingStatus.GREEN;
                dependency.message = "Success";
                continue;
            }
            if (!provider.getKey().equals(dependency.providerKey)) continue;
            VServiceProvider.BindingStatus status = provider.getStatus();
            dependency.status = status != null ? VirtualServiceBindingStatus.valueOf(status.toString()) : null;
            dependency.message = provider.getValidationMessage();
        }
        return dependency;
    }

    private static VirtualServiceProvider createFromVServiceProvider(VServiceProvider VServiceProvider2) {
        VirtualServiceProvider provider = new VirtualServiceProvider();
        provider.key = VServiceProvider2.getKey();
        provider.name = VServiceProvider2.getName();
        return provider;
    }
}

