/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.util;

import com.vmware.vsphere.client.provisioning.spec.AuthenticationRequirement;
import com.vmware.vsphere.client.provisioning.spec.HttpResourceProbeResult;
import com.vmware.vsphere.client.provisioning.spec.ProbeStatus;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class HttpResourceProber {
    private static final Log _logger = LogFactory.getLog(HttpResourceProber.class);
    private static final String HEADER_NAME_AUTHENTICATE = "www-authenticate";
    private static final String HEADER_ELEM_BASIC_REALM = "basic realm";
    private static final Set<String> SUPPORTED_SOURCE_SCHEMES = new HashSet<String>();
    private static final int INACTIVITY_VALIDATION_PERIOD = 30000;
    private final CloseableHttpClient _client;
    private int _timeout = 0;

    static HttpResourceProber newInstance() {
        return new HttpResourceProber(null);
    }

    public static HttpResourceProber newInstance(KeyStore trustStore) {
        Validate.notNull((Object)trustStore, (String)"Trust store is null");
        return new HttpResourceProber(trustStore);
    }

    private HttpResourceProber(KeyStore trustStore) {
        PoolingHttpClientConnectionManager connectionManager = this.createConnectionManager(trustStore);
        if (connectionManager == null) {
            _logger.warn((Object)"Failed to create connection manager.");
            this._client = null;
        } else {
            this._client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, false)).build();
        }
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this._timeout = timeout;
    }

    public HttpResourceProbeResult probe(URI target) throws Exception {
        String[] credentials;
        Validate.notNull((Object)target, (String)"target is null");
        if (target.getUserInfo() != null && (credentials = StringUtils.split((String)target.getUserInfo(), (String)":")) != null && credentials.length == 2) {
            return this.probe(target, credentials[0], credentials[1]);
        }
        return this.executeProbe(target, null);
    }

    public HttpResourceProbeResult probe(URI target, String username, String password) throws Exception {
        Validate.notNull((Object)target, (String)"target is null");
        Validate.notNull((Object)username, (String)"username is null");
        Validate.notNull((Object)password, (String)"password is null");
        String credentials = username + ':' + password;
        byte[] credentialBytes = credentials.getBytes(Charset.forName("UTF-8"));
        String encodedCredentials = Base64.encodeBase64String((byte[])credentialBytes);
        BasicHeader authHeader = new BasicHeader("Authorization", "Basic " + encodedCredentials);
        return this.executeProbe(target, (Header)authHeader);
    }

    private PoolingHttpClientConnectionManager createConnectionManager(KeyStore keyStore) {
        PlainConnectionSocketFactory defaultSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
        LayeredConnectionSocketFactory secureSocketFactory = this.createSecureSocketFactory(keyStore);
        if (secureSocketFactory == null) {
            _logger.debug((Object)"Failed to create socket factory.");
            return null;
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)defaultSocketFactory).register("https", (Object)secureSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setDefaultMaxPerRoute(1);
        connectionManager.setValidateAfterInactivity(30000);
        return connectionManager;
    }

    private LayeredConnectionSocketFactory createSecureSocketFactory(KeyStore keyStore) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new ProbingTrustManager(keyStore)}, null);
            return new SSLConnectionSocketFactory(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException exception) {
            _logger.error((Object)"Exception creating socket factory - probing not possible.", (Throwable)exception);
            return null;
        }
    }

    private HttpResourceProbeResult executeProbe(URI source, Header requestHeader) throws Exception {
        assert (source != null) : "null source";
        if (!SUPPORTED_SOURCE_SCHEMES.contains(source.getScheme())) {
            throw new IllegalArgumentException("Unsupported source scheme " + source.getScheme());
        }
        HttpResourceProbeResult result = new HttpResourceProbeResult();
        if (this._client == null) {
            _logger.warn((Object)"HTTP client is not properly initialized.");
            result.status = ProbeStatus.FAILURE;
            result.authenticationRequirement = AuthenticationRequirement.UNKNOWN;
            return result;
        }
        URIBuilder uriBuilder = new URIBuilder(source.getRawPath());
        ArrayList<BasicNameValuePair> requestParams = new ArrayList<BasicNameValuePair>();
        if (source.getQuery() != null) {
            uriBuilder.setCustomQuery(source.getQuery());
        }
        requestParams.add(new BasicNameValuePair("http.protocol.reject-head-body", "true"));
        uriBuilder.addParameters(requestParams);
        HttpHead request = new HttpHead(uriBuilder.build());
        if (requestHeader != null) {
            request.setHeader(requestHeader);
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this._timeout).build();
        request.setConfig(requestConfig);
        HttpHost hostConfig = this.getHostConfig(source);
        try (CloseableHttpResponse response = this._client.execute(hostConfig, (HttpRequest)request);){
            result.responseCode = response.getStatusLine().getStatusCode();
            result.authenticationRequirement = this.getAuthRequirement((HttpRequest)request);
            result.status = ProbeStatus.SUCCESS;
        }
        catch (Throwable exception) {
            result.status = this.processException(exception);
            result.authenticationRequirement = AuthenticationRequirement.UNKNOWN;
            _logger.debug((Object)("Exception probing " + source + ". The resulting status is " + (Object)((Object)result.status) + " and the exception is " + exception.getClass().getName()));
        }
        return result;
    }

    private ProbeStatus processException(Throwable ex) {
        assert (ex != null) : "null exception";
        Class<?> exClass = ex.getClass();
        if (HttpException.class.isAssignableFrom(exClass)) {
            _logger.error((Object)"Unexpected probe error", ex);
            return ProbeStatus.FAILURE;
        }
        if (UnknownHostException.class.equals(exClass)) {
            return ProbeStatus.UNKNOWN_HOST;
        }
        if (IllegalArgumentException.class.equals(exClass)) {
            return ProbeStatus.INVALID_SOURCE;
        }
        if (SocketTimeoutException.class.equals(exClass) || ConnectTimeoutException.class.equals(exClass)) {
            return ProbeStatus.TIMEOUT;
        }
        if (SSLException.class.isAssignableFrom(exClass)) {
            return ProbeStatus.SSL_ERROR;
        }
        if (IOException.class.isAssignableFrom(exClass)) {
            return ProbeStatus.IO_ERROR;
        }
        _logger.warn((Object)("Unhandled probe exception: " + exClass));
        return ProbeStatus.FAILURE;
    }

    private HttpHost getHostConfig(URI source) {
        return new HttpHost(source.getHost(), this.getDefaultPort(source), source.getScheme());
    }

    private int getDefaultPort(URI source) {
        if ("http".equals(source.getScheme())) {
            return 80;
        }
        if ("https".equals(source.getScheme())) {
            return 443;
        }
        throw new AssertionError((Object)("Unsupported source scheme " + source.getScheme()));
    }

    private AuthenticationRequirement getAuthRequirement(HttpRequest executedMethod) {
        HeaderElement[] authValue = this.getAuthenticateHeader(executedMethod);
        if (authValue.length == 0) {
            return AuthenticationRequirement.NONE;
        }
        for (HeaderElement headerElement : authValue) {
            if (!HEADER_ELEM_BASIC_REALM.equalsIgnoreCase(headerElement.getName())) continue;
            return AuthenticationRequirement.BASIC;
        }
        return AuthenticationRequirement.OTHER;
    }

    private HeaderElement[] getAuthenticateHeader(HttpRequest executedMethod) {
        Header[] responseHeaders;
        for (Header header : responseHeaders = executedMethod.getAllHeaders()) {
            if (!HEADER_NAME_AUTHENTICATE.equalsIgnoreCase(header.getName())) continue;
            return header.getElements();
        }
        return new HeaderElement[0];
    }

    static {
        SUPPORTED_SOURCE_SCHEMES.add("http");
        SUPPORTED_SOURCE_SCHEMES.add("https");
    }

    private static class ProbingTrustManager
    implements X509TrustManager {
        private static final Log _logger = LogFactory.getLog(ProbingTrustManager.class);

        public ProbingTrustManager(KeyStore trustStore) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            throw new NotImplementedException("checkClientTrusted");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            _logger.debug((Object)"All certificates trusted");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

