/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.util;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.cluster.ConfigInfoEx;
import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.provisioning.util.ProvisioningServiceUtil;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProvisioningResourcePoolUtil {
    private static final Log _logger = LogFactory.getLog(ProvisioningResourcePoolUtil.class);
    private static final String PARENT_PROPERTY = "parent";
    private static final String OWNER_PROPERTY = "owner";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String HOST_MAINTENANCE_MODE_PROPERTY = "runtime.inMaintenanceMode";

    public static Boolean atLeastOneHostConnected(DataService dataService, ManagedObjectReference[] hosts) throws Exception {
        if (dataService == null || ArrayUtil.isNullOrEmpty((Object[])hosts)) {
            return false;
        }
        PropertyValue[] propValues = QueryUtil.getProperties((DataService)dataService, (Object[])hosts, (String[])new String[]{HOST_CONNECTION_STATE_PROPERTY, HOST_MAINTENANCE_MODE_PROPERTY});
        if (propValues == null) {
            _logger.error((Object)"Unable to retreive host properties.");
            return false;
        }
        HashMap<ManagedObjectReference, HostSystem.ConnectionState> hostToConnectionState = new HashMap<ManagedObjectReference, HostSystem.ConnectionState>();
        HashMap<ManagedObjectReference, Boolean> hostToMaintenanceMode = new HashMap<ManagedObjectReference, Boolean>();
        for (PropertyValue propertyValue : propValues) {
            if (propertyValue == null) continue;
            if (HOST_CONNECTION_STATE_PROPERTY.equals(propertyValue.propertyName)) {
                hostToConnectionState.put((ManagedObjectReference)propertyValue.resourceObject, (HostSystem.ConnectionState)propertyValue.value);
                continue;
            }
            if (!HOST_MAINTENANCE_MODE_PROPERTY.equals(propertyValue.propertyName)) continue;
            hostToMaintenanceMode.put((ManagedObjectReference)propertyValue.resourceObject, (Boolean)propertyValue.value);
        }
        for (PropertyValue propertyValue : hosts) {
            HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)hostToConnectionState.get(propertyValue);
            Boolean inMaintenanceMode = (Boolean)hostToMaintenanceMode.get(propertyValue);
            if (!HostSystem.ConnectionState.connected.equals((Object)connectionState) || inMaintenanceMode.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Boolean isDrsDisabled(ComputeResource.ConfigInfo configuration) {
        Boolean isDrsDisabled = false;
        if (configuration != null && configuration instanceof ConfigInfoEx) {
            DrsConfigInfo drsConfig = ((ConfigInfoEx)configuration).drsConfig;
            isDrsDisabled = drsConfig != null && drsConfig.enabled == false;
        }
        return isDrsDisabled;
    }

    public static PropertyValue[] getComputeResourceProperties(ManagedObjectReference objectRef, DataService dataService, String[] propToRetrieve) throws Exception {
        Constraint constraint = null;
        if (objectRef == null || dataService == null || ArrayUtil.isNullOrEmpty((Object[])propToRetrieve)) {
            return null;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objectRef, ClusterComputeResource.class)) {
            return QueryUtil.getProperties((DataService)dataService, (Object)objectRef, (String[])propToRetrieve);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objectRef, HostSystem.class)) {
            constraint = QueryUtil.createConstraintForRelationship((Object)objectRef, (String)PARENT_PROPERTY, (String)ComputeResource.class.getSimpleName());
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)objectRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objectRef, VirtualApp.class)) {
            constraint = QueryUtil.createConstraintForRelationship((Object)objectRef, (String)OWNER_PROPERTY, (String)ComputeResource.class.getSimpleName());
        } else {
            _logger.warn((Object)("Unexpected object type: " + objectRef.getType()));
            return null;
        }
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])propToRetrieve);
        ResultSet result = QueryUtil.getData((DataService)dataService, (QuerySpec)query);
        if (result == null || ArrayUtil.isNullOrEmpty((Object[])result.items)) {
            _logger.error((Object)("Unable to retrieve properties for: " + objectRef.getValue()));
            return null;
        }
        return result.items[0].properties;
    }

    public static String getHostsNotConnectionError(ManagedObjectReference objectRef, Object configuration) {
        String errorMsg = null;
        if (objectRef == null || configuration == null) {
            return null;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objectRef, HostSystem.class)) {
            errorMsg = ProvisioningServiceUtil.getLocalizedString("error.hostNotConnected");
        } else if (configuration instanceof ConfigInfoEx) {
            errorMsg = ClusterComputeResource.class.getSimpleName().equals(objectRef.getType()) ? ProvisioningServiceUtil.getLocalizedString("error.noConnectedHosts") : ProvisioningServiceUtil.getLocalizedString("error.parentClusterNoConnectedHosts");
        } else if (configuration instanceof ComputeResource.ConfigInfo) {
            errorMsg = ManagedObjectUtil.isOfType((ManagedObjectReference)objectRef, VirtualApp.class) ? ProvisioningServiceUtil.getLocalizedString("error.vappParentHostNotConnected") : ProvisioningServiceUtil.getLocalizedString("error.poolParentHostNotConnected");
        }
        return errorMsg;
    }
}

