/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CmDataProviderAdapterBase<T>
extends DataProviderAdapterBase {
    private static final ResultItem[] EMPTY_RESULT_ITEMS_ARRAY = new ResultItem[0];
    private static final Log _logger = LogFactory.getLog(CmDataProviderAdapterBase.class);
    private final CmAuthorizationService _cmAuthorizationService;

    public CmDataProviderAdapterBase(CmAuthorizationService cmAuthorizationService) {
        this._cmAuthorizationService = cmAuthorizationService;
    }

    protected ResultSet processQuery(Constraint constraint, QuerySpec querySpec) {
        return this.handleQuery(constraint, querySpec);
    }

    protected ResultSet processQuery(CompositeConstraint constraint, QuerySpec querySpec) {
        return this.handleQuery((Constraint)constraint, querySpec);
    }

    protected ResultSet processQuery(RelationalConstraint constraint, QuerySpec querySpec) {
        return this.handleQuery((Constraint)constraint, querySpec);
    }

    protected ResultSet processQuery(ObjectIdentityConstraint constraint, QuerySpec querySpec) {
        return this.handleQuery((Constraint)constraint, querySpec);
    }

    protected ResultSet processQuery(PropertyConstraint constraint, QuerySpec querySpec) {
        return this.handleQuery((Constraint)constraint, querySpec);
    }

    protected abstract ResultSet processQueryInternal(Constraint var1, QuerySpec var2);

    protected ResultSet createResultSet(QuerySpec querySpec, DataRetrieverResult<? extends T> retrievalResult) {
        DataRetrieverResult<? extends T> pagedResult = this.pageProviders(retrievalResult, querySpec.resultSpec);
        ResultSet result = this.createResultSetInternal(querySpec, retrievalResult, pagedResult);
        return result;
    }

    protected ResultSet createEmptyResultSet(QuerySpec query, String errorResourceKey) {
        assert (query != null);
        ResultSet resultSet = new ResultSet();
        resultSet.items = EMPTY_RESULT_ITEMS_ARRAY;
        resultSet.queryName = query.name;
        if (errorResourceKey != null) {
            resultSet.error = new Exception(CmUtil.getLocalizedString(errorResourceKey, new String[0]));
        }
        return resultSet;
    }

    private ResultSet createResultSetInternal(QuerySpec querySpec, DataRetrieverResult<? extends T> retrievalResult, DataRetrieverResult<? extends T> pagedResults) {
        ResultSet result = new ResultSet();
        result.queryName = querySpec.name;
        result.error = retrievalResult.getException();
        result.items = this.createResultItems(querySpec, pagedResults.getResult());
        T[] totalProviders = retrievalResult.getResult();
        result.totalMatchedObjectCount = totalProviders == null ? 0 : totalProviders.length;
        return result;
    }

    private ResultItem[] createResultItems(QuerySpec querySpec, T[] infos) {
        if (infos == null || infos.length == 0) {
            return new ResultItem[0];
        }
        String[] propertyNames = this.getRelevantPropertyNames(querySpec.resourceSpec.constraint.targetType, querySpec.resourceSpec.propertySpecs);
        Object[][] propertyValues = this.getPropertyValues(infos, propertyNames);
        ResultItem[] resultItems = new ResultItem[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            URI uri = this.getUri(infos[i]);
            resultItems[i] = this.createResultItem(querySpec, uri, propertyNames, propertyValues, i);
        }
        return resultItems;
    }

    private ResultItem createResultItem(QuerySpec querySpec, URI uri, String[] propertyNames, Object[][] propertyValues, int objectIndex) {
        ResultItem ri = new ResultItem();
        ri.resourceObject = uri;
        ri.properties = this.createPropertyValues(uri, propertyNames, propertyValues, objectIndex);
        return ri;
    }

    private PropertyValue[] createPropertyValues(URI object, String[] names, Object[][] values, int objectIndex) {
        PropertyValue[] properties = new PropertyValue[names.length];
        for (int i = 0; i < names.length; ++i) {
            properties[i] = this.createPropertyValue(object, names[i], values[i][objectIndex]);
        }
        return properties;
    }

    private PropertyValue createPropertyValue(URI object, String name, Object value) {
        PropertyValue propValue = new PropertyValue();
        propValue.resourceObject = object;
        propValue.propertyName = name;
        propValue.value = value;
        return propValue;
    }

    private String[] getRelevantPropertyNames(String type, PropertySpec[] specs) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (PropertySpec spec : specs) {
            String[] propNamesPerSpec = this.getRelevantPropertyNames(type, spec);
            propertyNames.addAll(Arrays.asList(propNamesPerSpec));
        }
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    private String[] getRelevantPropertyNames(String type, PropertySpec spec) {
        if (type != null && spec.type != null && !spec.type.equals(type)) {
            _logger.warn((Object)("Unexpected PropertySpec type '" + spec.type + "'! Expected '" + type + "'"));
            return new String[0];
        }
        return spec.propertyNames;
    }

    private DataRetrieverResult<? extends T> pageProviders(DataRetrieverResult<? extends T> originalProviders, ResultSpec spec) {
        int offset;
        if (originalProviders == null) {
            return null;
        }
        T[] result = originalProviders.getResult();
        if (result == null || result.length == 0 || spec == null) {
            return originalProviders;
        }
        int maxResultCount = spec.maxResultCount != null ? spec.maxResultCount : -1;
        int n = offset = spec.offset != null ? spec.offset : 0;
        if (offset == 0 && maxResultCount < 0) {
            return originalProviders;
        }
        int beginIndex = offset;
        int endIndex = beginIndex + maxResultCount;
        if (beginIndex < 0 || beginIndex >= result.length) {
            beginIndex = result.length;
        }
        if (endIndex > result.length || maxResultCount < 0) {
            endIndex = result.length;
        }
        return originalProviders.slice(beginIndex, endIndex);
    }

    protected abstract Object[][] getPropertyValues(T[] var1, String[] var2);

    protected abstract URI getUri(T var1);

    private ResultSet handleQuery(Constraint constraint, QuerySpec querySpec) {
        assert (constraint != null && querySpec != null);
        if (!this._cmAuthorizationService.isCurrentUserAuthorized()) {
            return this.createEmptyResultSet(querySpec, null);
        }
        return this.processQueryInternal(constraint, querySpec);
    }
}

