/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.appliance.vmon.Service;
import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.InvalidElementConfiguration;
import com.vmware.vapi.std.errors.NotAllowedInCurrentState;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.ServiceOperationSpec;
import com.vmware.vsphere.client.cm.ServiceStartupTypeSpec;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmonServiceControlProvider {
    private static final Log _logger = LogFactory.getLog(VmonServiceControlProvider.class);
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;

    public VmonServiceControlProvider(VapiConnectionManagerRegistry<String> vmonConnectionDirector) {
        this._vmonConnectionRegistry = vmonConnectionDirector;
    }

    public OperationResult apply(URI target, ServiceOperationSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = target;
        String serviceId = CmReferenceUtil.getId(target);
        try {
            Service vmon = (Service)this._vmonConnectionRegistry.getService(Service.class, (Object)CmReferenceUtil.getServerId(target));
            switch (spec.operation) {
                case START: {
                    vmon.start(serviceId);
                    break;
                }
                case STOP: {
                    vmon.stop(serviceId);
                    break;
                }
                case RESTART: {
                    vmon.restart(serviceId);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown runtime state: " + (Object)((Object)spec.operation));
                }
            }
        }
        catch (NotAllowedInCurrentState | NotFound e) {
            result.error = e;
        }
        return result;
    }

    public OperationResult apply(URI target, ServiceStartupTypeSpec spec) {
        ServiceTypes.StartupType newStartupType;
        OperationResult result = new OperationResult();
        result.entity = target;
        ServiceTypes.UpdateSpec vmonSpec = new ServiceTypes.UpdateSpec();
        switch (spec.type) {
            case AUTOMATIC: {
                newStartupType = ServiceTypes.StartupType.AUTOMATIC;
                break;
            }
            case MANUAL: {
                newStartupType = ServiceTypes.StartupType.MANUAL;
                break;
            }
            case DISABLED: {
                newStartupType = ServiceTypes.StartupType.DISABLED;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized startup type: " + spec.type.toString());
            }
        }
        vmonSpec.setStartupType(newStartupType);
        Service vmon = (Service)this._vmonConnectionRegistry.getService(Service.class, (Object)CmReferenceUtil.getServerId(target));
        String serviceId = CmReferenceUtil.getId(target);
        try {
            vmon.update(serviceId, vmonSpec);
        }
        catch (InvalidArgument | InvalidElementConfiguration | NotAllowedInCurrentState | NotFound e) {
            result.error = e;
        }
        return result;
    }
}

