/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceManager;
import com.vmware.vise.vim.lookup.UserSpecificLsFactory;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.applmgmt.VapiBackedCloudVmService;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplmgmtServiceRegistry
implements UserSessionListener {
    private static final String APPLMGMT_SERVICE_URL_FORMAT = "https://%s/applmgmt/RPC2";
    private static final String APPLMGMT_ENDPOINT_URL_CACHE_KEY = "applmgmtEndpointUrlCache";
    private static final String APPLMGMT_LS_PRODUCT_ID = "com.vmware.applmgmt";
    private static final String APPLMGMT_LS_TYPE_ID = "applmgmt";
    private static final String APPLMGMT_LS_ENDPOINT_TYPE_ID = "com.vmware.applmgmt";
    private static final Log _logger = LogFactory.getLog(ApplmgmtServiceRegistry.class);
    private final UserSpecificLsFactory _lsFactory;
    private final SsoServiceManager _ssoServiceManager;
    private final VapiConnectionManagerRegistry<String> _applmgmtVapiConnectionRegistry;
    private final CloudVmServiceManager _cvsManager;

    public ApplmgmtServiceRegistry(UserSpecificLsFactory lsFactory, SsoServiceManager ssoServiceManager, VapiConnectionManagerRegistry<String> applmgmtVapiConnectionRegistry, CloudVmServiceManager cvsManager) {
        this._lsFactory = lsFactory;
        this._ssoServiceManager = ssoServiceManager;
        this._applmgmtVapiConnectionRegistry = applmgmtVapiConnectionRegistry;
        this._cvsManager = cvsManager;
    }

    public void sessionStarted(HttpSessionEvent event, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent event) throws Exception {
        Map cache = (Map)SessionUtil.removeData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY, (HttpSession)event.getSession());
        if (!MapUtils.isEmpty((Map)cache)) {
            cache.clear();
        }
    }

    public CloudVmService getCloudVmService(String hostname) {
        Validate.notNull((Object)hostname, (String)"Attempting to get applmgmt for a null server");
        VapiConnectionManager vapiConnMgr = this._applmgmtVapiConnectionRegistry.getConnectionManager((Object)hostname);
        if (vapiConnMgr != null) {
            return new VapiBackedCloudVmService(vapiConnMgr);
        }
        URL applmgmtServiceUrl = this.getRelatedApplmgmtServiceUrl(hostname);
        if (applmgmtServiceUrl == null) {
            return null;
        }
        CloudVmService service = this._cvsManager.getService(applmgmtServiceUrl);
        return service;
    }

    private URL getRelatedApplmgmtServiceUrl(String serverHostname) {
        assert (!StringUtil.isNullOrEmpty((String)serverHostname));
        Map cache = (Map)SessionUtil.getData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY);
        String hostnameKey = serverHostname.toLowerCase();
        if (!MapUtils.isEmpty((Map)cache) && cache.containsKey(hostnameKey)) {
            return (URL)cache.get(hostnameKey);
        }
        return this.getRelatedApplmgmtServiceUrlSynchronized(hostnameKey);
    }

    private synchronized URL getRelatedApplmgmtServiceUrlSynchronized(String serverHostname) {
        Map<String, URL> cache = (Map<String, URL>)SessionUtil.getData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY);
        if (MapUtils.isEmpty((Map)cache)) {
            cache = this.retrieveApplmgmtEndpointUrls();
            SessionUtil.setData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY, cache);
        }
        return cache.get(serverHostname);
    }

    private Map<String, URL> retrieveApplmgmtEndpointUrls() {
        HashMap<String, URL> result = new HashMap<String, URL>();
        Collection<InternalServerInfo> servers = CmUtil.getServers(this._ssoServiceManager);
        for (InternalServerInfo server : servers) {
            result.put(server.getHostname().toLowerCase(), null);
        }
        ServiceRegistration.Filter filterCriteria = new ServiceRegistration.Filter();
        ServiceRegistration.ServiceType serviceType = new ServiceRegistration.ServiceType();
        serviceType.setProduct("com.vmware.applmgmt");
        serviceType.setType(APPLMGMT_LS_TYPE_ID);
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType();
        endpointType.setProtocol("http");
        endpointType.setType("com.vmware.applmgmt");
        filterCriteria.setServiceType(serviceType);
        filterCriteria.setEndpointType(endpointType);
        ServiceRegistration.Info[] applmgmtServices = this._lsFactory.getLookupService().getServiceRegistrationInfos(filterCriteria);
        if (applmgmtServices != null) {
            for (ServiceRegistration.Info applmgmtService : applmgmtServices) {
                ServiceRegistration.Endpoint endpoint = applmgmtService.getServiceEndpoints()[0];
                URI endpointUri = endpoint.getUrl();
                String hostName = endpointUri.getHost().toLowerCase().replaceAll("[\\]\\[]", "");
                try {
                    result.put(hostName, endpointUri.toURL());
                }
                catch (MalformedURLException e) {
                    _logger.error((Object)("Invalid applmgmgt endpoint URI retrieved for host" + hostName), (Throwable)e);
                    result.put(hostName, this.buildApplmgmtUrl(hostName));
                }
            }
        }
        return result;
    }

    private URL buildApplmgmtUrl(String serverHostname) {
        try {
            return new URL(String.format(APPLMGMT_SERVICE_URL_FORMAT, serverHostname));
        }
        catch (MalformedURLException e) {
            _logger.error((Object)("Failed to build URL for server " + serverHostname), (Throwable)e);
            return null;
        }
    }
}

