/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import java.net.URI;
import org.apache.commons.lang.Validate;

public class CmUiFeatureSwitch {
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;
    private final ObjectReferenceService _objectReferenceService;

    public CmUiFeatureSwitch(VapiConnectionManagerRegistry<String> vmonConnectionRegistry, ObjectReferenceService objectReferenceService) {
        Validate.notNull((Object)objectReferenceService);
        Validate.notNull(vmonConnectionRegistry);
        this._vmonConnectionRegistry = vmonConnectionRegistry;
        this._objectReferenceService = objectReferenceService;
    }

    public boolean useVmonForService(URI serviceRef) {
        assert (CmReferenceUtil.isReferenceOfType(serviceRef, "cm:Service", this._objectReferenceService));
        return this._vmonConnectionRegistry.getConnectionManager((Object)CmReferenceUtil.getServerId(serviceRef)) != null;
    }

    public boolean useVmonForHost(String serverName) {
        return this._vmonConnectionRegistry.getConnectionManager((Object)serverName) != null;
    }
}

