/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vim.binding.sca.configuration.Configuration;
import com.vmware.vim.binding.sca.configuration.ConfigurationDefinition;
import com.vmware.vim.binding.sca.configuration.Parameter;
import com.vmware.vim.binding.sca.configuration.ServiceConfigurationManager;
import com.vmware.vim.binding.sca.configuration.metadata.PropertyDescriptor;
import com.vmware.vim.binding.sca.configuration.metadata.TypeDescriptor;
import com.vmware.vim.binding.sca.configuration.metadata.XSFacet;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScmUtil {
    private static final Log _logger = LogFactory.getLog(ScmUtil.class);
    public static final String RESOURCE_REGISTERED_PROPERTY = "configurationRegistered";
    public static final String RESOURCES_PROPERTY = "resources";
    public static final String CONFIGURATIONS_PROPERTY = "configurations";
    public static final String DEFINITIONS_PROPERTY = "definitions";
    public static final String MUTATION_MAPPING_PROPERTY = "settings.{resourceKey*}";
    private static final String ALL_SETTINGS_PROPERTY_REGEX = "settings(\\.)(.+)";
    private static final String SETTINGS_PREFIX_REGEX = "settings(\\.)";
    private static final String SETTINGS_INFO_PROP_REGEX = "@info";
    private static final String SETTINGS_INFO_IMMUTABLE_PROP_REGEX = "@info.immutable";

    public static boolean isSettingsProperty(String propertyName) {
        if (propertyName == null) {
            return false;
        }
        return propertyName.matches(ALL_SETTINGS_PROPERTY_REGEX);
    }

    public static boolean isResourceRegistered(ServiceConfigurationManager scm, InternalServiceInfo service) {
        String serviceId = ScmUtil.getServiceId(service);
        try {
            String[] resourceKeys = scm.getResources(serviceId);
            return resourceKeys != null && resourceKeys.length != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String[] getResources(ServiceConfigurationManager scm, InternalServiceInfo service) {
        String serviceId = ScmUtil.getServiceId(service);
        if (scm == null || serviceId == null) {
            return null;
        }
        try {
            return scm.getResources(serviceId);
        }
        catch (ServiceManagerFault e) {
            return null;
        }
    }

    public static Configuration[] getConfigurations(ServiceConfigurationManager scm, InternalServiceInfo service) {
        String serviceId = ScmUtil.getServiceId(service);
        if (scm == null || serviceId == null) {
            return null;
        }
        try {
            return scm.getConfigurations(serviceId);
        }
        catch (ServiceManagerFault e) {
            return null;
        }
    }

    public static ConfigurationDefinition[] getDefinitions(ServiceConfigurationManager scm, InternalServiceInfo service) {
        String serviceId = ScmUtil.getServiceId(service);
        if (scm == null || serviceId == null) {
            return null;
        }
        try {
            ConfigurationDefinition[] definitions = scm.getDefinitions(serviceId);
            ConfigurationDefinition[] updatedDefinitions = ScmUtil.localizeResourceTitles(definitions);
            return updatedDefinitions;
        }
        catch (ServiceManagerFault e) {
            return null;
        }
    }

    public static Object getSettings(ServiceConfigurationManager scm, InternalServiceInfo service, String propertyName) {
        String serviceId = ScmUtil.getServiceId(service);
        if (scm == null || serviceId == null || propertyName == null) {
            return null;
        }
        String parameter = propertyName.replaceFirst(SETTINGS_PREFIX_REGEX, "");
        if (parameter.endsWith(SETTINGS_INFO_IMMUTABLE_PROP_REGEX)) {
            if (ScmUtil.isResourceRegistered(scm, service)) {
                return false;
            }
            return null;
        }
        if (parameter.endsWith(SETTINGS_INFO_PROP_REGEX)) {
            String resourceKey = parameter.substring(0, parameter.length() - SETTINGS_INFO_PROP_REGEX.length() - 1);
            try {
                ConfigurationDefinition cd = scm.getDefinition(serviceId, resourceKey);
                return ScmUtil.convertToTypeNodeDescriptor(cd);
            }
            catch (ServiceManagerFault e) {
                return new TypeNodeDescriptor();
            }
        }
        try {
            Configuration config = scm.getConfiguration(serviceId, parameter);
            return ScmUtil.convertToDynamicObject(config);
        }
        catch (ServiceManagerFault e) {
            return null;
        }
    }

    public static Parameter[] convertToParameterArray(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Map.Entry<String, Object> keyValue : map.entrySet()) {
            Parameter parameter = ScmUtil.convertToParameter(keyValue);
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        if (parameters.isEmpty()) {
            return null;
        }
        return parameters.toArray(new Parameter[parameters.size()]);
    }

    private static Parameter convertToParameter(Map.Entry<String, Object> keyValue) {
        if (keyValue == null) {
            return null;
        }
        String name = keyValue.getKey();
        Object rawValue = keyValue.getValue();
        String value = null;
        if (rawValue != null) {
            value = rawValue.toString();
        }
        Parameter result = new Parameter();
        result.setName(name);
        result.setValue(value);
        return result;
    }

    private static DynamicObject convertToDynamicObject(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        Parameter[] parameters = configuration.getParameters();
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        int size = parameters.length;
        DynamicObject result = new DynamicObject();
        result.properties = new NameValuePair[size];
        int count = 0;
        for (Parameter param : parameters) {
            result.properties[count++] = new NameValuePair(param.getName(), (Object)param.getValue());
        }
        return result;
    }

    private static TypeNodeDescriptor convertToTypeNodeDescriptor(ConfigurationDefinition definition) {
        if (definition == null) {
            return null;
        }
        TypeNodeDescriptor typeNode = new TypeNodeDescriptor();
        TypeDescriptor typeDescriptor = definition.getMetadata();
        typeNode.title = LocalizationUtil.getLocalizedMessage((String)typeDescriptor.getName());
        typeNode.properties = ScmUtil.convertToPropertyNodeDescriptor(typeDescriptor.getProperties());
        typeNode.name = LocalizationUtil.getLocalizedMessage((String)typeDescriptor.getTitle());
        String descriptionKey = typeDescriptor.getDescription();
        typeNode.description = LocalizationUtil.getLocalizedMessage((String)descriptionKey);
        typeNode.tags = ScmUtil.convertToMap(typeDescriptor.getOptions());
        return typeNode;
    }

    private static PropertyNodeDescriptor[] convertToPropertyNodeDescriptor(PropertyDescriptor[] propertyDescriptors) {
        if (propertyDescriptors == null) {
            return null;
        }
        ArrayList<PropertyNodeDescriptor> list = new ArrayList<PropertyNodeDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            PropertyNodeDescriptor pnd = new PropertyNodeDescriptor();
            pnd.staticValueSpace = ScmUtil.convertToRfwXSFacet(propertyDescriptor.getStaticValueSpace());
            String descriptionKey = propertyDescriptor.getDescription();
            pnd.description = LocalizationUtil.getLocalizedMessage((String)descriptionKey);
            pnd.immutable = propertyDescriptor.getImmutable();
            if (propertyDescriptor.getOptional() != null) {
                pnd.isOptional = propertyDescriptor.getOptional();
            }
            pnd.name = propertyDescriptor.getName();
            pnd.tags = ScmUtil.convertToMap(propertyDescriptor.getOptions());
            String titleKey = propertyDescriptor.getTitle();
            pnd.title = LocalizationUtil.getLocalizedMessage((String)titleKey);
            pnd.valueTypeName = ScmUtil.convertToRfwType(propertyDescriptor.getType().getName());
            list.add(pnd);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new PropertyNodeDescriptor[list.size()]);
    }

    private static com.vmware.vise.data.common.XSFacet[] convertToRfwXSFacet(XSFacet[] cisXsFacets) {
        if (cisXsFacets == null || cisXsFacets.length == 0) {
            return null;
        }
        ArrayList<com.vmware.vise.data.common.XSFacet> xsFacetList = new ArrayList<com.vmware.vise.data.common.XSFacet>();
        for (XSFacet cisXsFacet : cisXsFacets) {
            if (cisXsFacet.getType() == null || cisXsFacet.getType().getChoice() == null) {
                _logger.warn((Object)"CIS XSFacet type choice is null.");
                continue;
            }
            com.vmware.vise.data.common.XSFacet rfwXsFacet = new com.vmware.vise.data.common.XSFacet();
            rfwXsFacet.type = XSFacetType.valueOf((String)cisXsFacet.getType().getChoice());
            rfwXsFacet.value = cisXsFacet.getValue();
            xsFacetList.add(rfwXsFacet);
        }
        return xsFacetList.toArray(new com.vmware.vise.data.common.XSFacet[xsFacetList.size()]);
    }

    private static Map<String, String> convertToMap(KeyAnyValue[] options) {
        if (options == null || options.length == 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (KeyAnyValue option : options) {
            if (option.getKey() == null) continue;
            Object value = option.getValue();
            String stringValue = null;
            if (value != null) {
                stringValue = option.getValue().toString();
            }
            result.put(option.getKey(), stringValue);
        }
        return result;
    }

    private static String convertToRfwType(String scmType) {
        if (scmType == null) {
            _logger.error((Object)"SCM type is null.");
            return "string";
        }
        if (ScmDataTypes.DECIMAL.toString().equalsIgnoreCase(scmType)) {
            return "float";
        }
        if (ScmDataTypes.DOUBLE.toString().equalsIgnoreCase(scmType)) {
            return "float";
        }
        if (ScmDataTypes.FLOAT.toString().equalsIgnoreCase(scmType)) {
            return "float";
        }
        if (ScmDataTypes.LONG.toString().equalsIgnoreCase(scmType)) {
            return "long";
        }
        if (ScmDataTypes.INTEGER.toString().equalsIgnoreCase(scmType)) {
            return "int";
        }
        if (ScmDataTypes.SHORT.toString().equalsIgnoreCase(scmType)) {
            return "int";
        }
        if (ScmDataTypes.BYTE.toString().equalsIgnoreCase(scmType)) {
            return "int";
        }
        if (ScmDataTypes.BOOLEAN.toString().equalsIgnoreCase(scmType)) {
            return "boolean";
        }
        if (ScmDataTypes.STRING.toString().equalsIgnoreCase(scmType)) {
            return "string";
        }
        _logger.error((Object)"SCM type is unknown. Attempting to convert to RFW string.");
        return "string";
    }

    private static ConfigurationDefinition[] localizeResourceTitles(ConfigurationDefinition[] definitions) {
        for (ConfigurationDefinition definition : definitions) {
            TypeDescriptor typeDescriptor = definition.getMetadata();
            if (typeDescriptor == null) continue;
            String titleKey = typeDescriptor.getTitle();
            String title = LocalizationUtil.getLocalizedMessage((String)titleKey);
            typeDescriptor.setTitle(title);
        }
        return definitions;
    }

    private static String getServiceId(InternalServiceInfo service) {
        if (service == null) {
            return null;
        }
        return service.getServiceId();
    }

    private static enum ScmDataTypes {
        DECIMAL,
        INTEGER,
        DOUBLE,
        BYTE,
        FLOAT,
        SHORT,
        LONG,
        BOOLEAN,
        STRING;

    }
}

