/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.vim.cloudvm.SystemStats;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.VmInfo;
import com.vmware.vsphere.client.cm.util.HealthStateComparator;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.ServerPropertyValueExtractor;
import java.util.Comparator;

public final class ServerComparator
implements Comparator<InternalServerInfo> {
    private final OrderingCriteria _orderingCriteria;
    private final ServerPropertyValueExtractor _serverValueExtractor;

    public ServerComparator(OrderingCriteria orderingCriteria, ServerPropertyValueExtractor serverValueExtractor) {
        this._orderingCriteria = orderingCriteria;
        this._serverValueExtractor = serverValueExtractor;
    }

    @Override
    public int compare(InternalServerInfo server1, InternalServerInfo server2) {
        for (OrderingPropertySpec orderingProperty : this._orderingCriteria.orderingProperties) {
            for (String propertyName : orderingProperty.propertyNames) {
                int compareToResult;
                Object prop1 = this.extractServerPropertyValue(server1, propertyName);
                Object prop2 = this.extractServerPropertyValue(server2, propertyName);
                int result = 0;
                if (prop1 == null && prop2 == null || (result = prop1 == null ? 1 : (prop2 == null ? -1 : (prop1 instanceof HealthState ? this.compareByHealth((HealthState)((Object)prop1), (HealthState)((Object)prop2)) : (prop1 instanceof Comparable ? (compareToResult = ((Comparable)prop1).compareTo(prop2)) : (prop1 instanceof SystemStats ? this.compareByUptime((SystemStats)prop1, (SystemStats)prop2) : (prop1 instanceof VmInfo ? this.compareByVm((VmInfo)((Object)prop1), (VmInfo)((Object)prop2)) : prop1.toString().compareToIgnoreCase(prop2.toString()))))))) == 0) continue;
                return orderingProperty.orderingType == SortType.ASCENDING ? result : -result;
            }
        }
        return 0;
    }

    private int compareByHealth(HealthState health1, HealthState health2) {
        return HealthStateComparator.getInstance().compare(health1, health2);
    }

    private int compareByUptime(SystemStats sysStats1, SystemStats sysStats2) {
        return Double.compare(sysStats1.uptime, sysStats2.uptime);
    }

    private int compareByVm(VmInfo vm1, VmInfo vm2) {
        return vm1.name.compareTo(vm2.name);
    }

    private Object extractServerPropertyValue(InternalServerInfo server, String propertyName) {
        return this._serverValueExtractor.getValues(new InternalServerInfo[]{server}, new String[]{propertyName})[0][0];
    }
}

