/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.cis.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.sca.control.ServiceControlManager;
import com.vmware.vim.binding.sca.control.ServiceState;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Address;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vise.vim.vmca.VmcaService;
import com.vmware.vsphere.client.cm.ActiveDirectoryInfo;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.LogManifestInfo;
import com.vmware.vsphere.client.cm.ServerDeploymentType;
import com.vmware.vsphere.client.cm.ServiceStatus;
import com.vmware.vsphere.client.cm.VmInfo;
import com.vmware.vsphere.client.cm.util.ApplmgmtServiceRegistry;
import com.vmware.vsphere.client.cm.util.CachingPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUiFeatureSwitch;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

public class ServerPropertyValueExtractor
extends CachingPropertyValueExtractor<InternalServerInfo> {
    private static final String VM_TYPE = VirtualMachine.class.getSimpleName();
    private static final String SCA_SUPPORT_BUNDLE_PATH = "/supportbundle";
    private static final Log _logger = LogFactory.getLog(ServerPropertyValueExtractor.class);
    private static final ApplmgmtControlState UNKOWN_APPLMGMT_CONTROL_STATE = new ApplmgmtControlState(ServiceStatus.UNKNOWN, HealthState.UNKNOWN, new String[0]);
    private final DataService _dataService;
    private final ApplmgmtServiceRegistry _applmgmtServiceRegistry;
    private final SsoService _ssoService;
    private final KeystoreService _ksService;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final VmcaService _vmcaService;
    private final Set<String> _propertiesNotNeedingRemoteCall;
    private SsoServiceManager _ssoServiceManager;
    private ScaServiceManager _scaServiceManager;
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;
    private final PropertyCache<String> _unreachableServerCache;
    private final CmUiFeatureSwitch _featureSwitch;

    public ServerPropertyValueExtractor(DataService dataService, SsoService ssoService, ApplmgmtServiceRegistry applmgmtServiceRegistry, KeystoreService ksService, SSLConfigurationProvider sslConfigProvider, VmcaService vmcaService, VapiConnectionManagerRegistry<String> vmonConnectionRegistry, PropertyCache<InternalServerInfo> propertyCache, Set<String> cacheableProperties, PropertyCache<String> unreachableServerCache, Executor executor, CmUiFeatureSwitch featureSwitch) {
        super(propertyCache, cacheableProperties, executor);
        this._dataService = dataService;
        this._ssoService = ssoService;
        this._applmgmtServiceRegistry = applmgmtServiceRegistry;
        this._ksService = ksService;
        this._sslConfigurationProvider = sslConfigProvider;
        this._vmcaService = vmcaService;
        this._vmonConnectionRegistry = vmonConnectionRegistry;
        this._featureSwitch = featureSwitch;
        this._unreachableServerCache = unreachableServerCache;
        this._propertiesNotNeedingRemoteCall = new HashSet<String>();
        this._propertiesNotNeedingRemoteCall.add("name");
        this._propertiesNotNeedingRemoteCall.add("services");
        this._propertiesNotNeedingRemoteCall.add("isDomainController");
        this._propertiesNotNeedingRemoteCall.add("systemHealth");
        this._propertiesNotNeedingRemoteCall.add("supportBundleUrl");
        this._propertiesNotNeedingRemoteCall.add("healthMessages");
        this._propertiesNotNeedingRemoteCall.add("isUnreachable");
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public void setScaServiceManager(ScaServiceManager scaServiceManager) {
        this._scaServiceManager = scaServiceManager;
    }

    public Object[][] getValues(InternalServerInfo[] servers, String[] propertyNames) {
        Object[][] result = new Object[propertyNames.length][servers.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            result[i] = this.getValuesPerProperty(servers, propertyNames[i]);
        }
        return result;
    }

    @Override
    protected String getServerId(InternalServerInfo info) {
        return info.getHostname();
    }

    @Override
    protected boolean propertyNeedsRemoteCall(String propertyName) {
        return !this._propertiesNotNeedingRemoteCall.contains(propertyName);
    }

    protected Object[] getValuesPerPropertyDirectly(InternalServerInfo[] servers, String propertyName, boolean objectsAreOnSameServer) {
        Object[] propertyValue = new Object[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            try {
                if ("name".equals(propertyName)) {
                    propertyValue[i] = servers[i].getHostname();
                    continue;
                }
                if ("serverIconId".equals(propertyName)) {
                    propertyValue[i] = this.getPrimaryIconId(servers[i]);
                    continue;
                }
                if ("hostname".equals(propertyName)) {
                    propertyValue[i] = this.getHostname(servers[i]);
                    continue;
                }
                if ("serviceInfos".equals(propertyName)) {
                    propertyValue[i] = this.getRelatedServiceInfos(servers[i]);
                    continue;
                }
                if ("services".equals(propertyName)) {
                    propertyValue[i] = this.getRelatedServices(servers[i]);
                    continue;
                }
                if ("isApplianceManaged".equals(propertyName)) {
                    propertyValue[i] = this.isApplmgmtServiceAvailable(servers[i]);
                    continue;
                }
                if ("isDomainController".equals(propertyName)) {
                    propertyValue[i] = this.isDomainController(servers[i]);
                    continue;
                }
                if ("applmgmtExistsAndDown".equals(propertyName)) {
                    propertyValue[i] = this.hasApplmgmtAndInRunningState(servers[i], false);
                    continue;
                }
                if ("applmgmtExistsAndUp".equals(propertyName)) {
                    propertyValue[i] = this.hasApplmgmtAndInRunningState(servers[i], true);
                    continue;
                }
                if ("isUnreachable".equals(propertyName)) {
                    propertyValue[i] = this.isUnreachable(servers[i]);
                    continue;
                }
                if ("systemHealth".equals(propertyName)) {
                    propertyValue[i] = this.getHealth(servers[i]);
                    continue;
                }
                if ("applmgmtControlState".equals(propertyName)) {
                    propertyValue[i] = this.getApplmgmtControlState(servers[i]);
                    continue;
                }
                if ("manifestArray".equals(propertyName)) {
                    propertyValue[i] = this.getManifestArrays(servers[i]);
                    continue;
                }
                if ("supportBundleUrl".equals(propertyName)) {
                    URI supportBundleUri = this.getSupportBundleUrl(servers[i]);
                    propertyValue[i] = supportBundleUri != null ? supportBundleUri.toString() : null;
                    continue;
                }
                if ("deploymentType".equals(propertyName)) {
                    propertyValue[i] = this.getDeploymentType(servers[i]);
                    continue;
                }
                if ("activeDirectoryInfo".equals(propertyName)) {
                    propertyValue[i] = this.getActiveDirectoryInfo(servers[i]);
                    continue;
                }
                if ("activeDirectoryJoined".equals(propertyName)) {
                    propertyValue[i] = this.getActiveDirectoryJoined(servers[i]);
                    continue;
                }
                if ("uptime".equals(propertyName)) {
                    propertyValue[i] = this.getUptime(servers[i]);
                    continue;
                }
                if ("vmca:activeCertificates".equals(propertyName)) {
                    propertyValue[i] = this.getActiveCertificates(servers[i].getHostname());
                    continue;
                }
                if ("vmca:revokedCertificates".equals(propertyName)) {
                    propertyValue[i] = this.getRevokedCertificates(servers[i].getHostname());
                    continue;
                }
                if ("vmca:expiredCertificates".equals(propertyName)) {
                    propertyValue[i] = this.getExpiredCertificates(servers[i].getHostname());
                    continue;
                }
                if ("vmca:rootCertificates".equals(propertyName)) {
                    propertyValue[i] = this.getRootCertificates(servers[i].getHostname());
                    continue;
                }
                if ("isvmcainitialized".equals(propertyName)) {
                    propertyValue[i] = this.isVMCAClientAvailable(servers[i].getHostname());
                    continue;
                }
                CloudVmService cloudVmService = this.getCloudVmService(servers[i]);
                if (cloudVmService == null || this.hasApplmgmtAndInRunningState(servers[i], false)) continue;
                if ("consoleCliEnabled".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.isConsoleCliEnabled();
                    continue;
                }
                if ("dcuiEnabled".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.isDcuiEnabled();
                    continue;
                }
                if ("shellConfig".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getShellConfig();
                    continue;
                }
                if ("sshEnabled".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.isSshEnabled();
                    continue;
                }
                if ("domains".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.listDnsDomains();
                    continue;
                }
                if ("dnsConfig".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getDnsServersConfig();
                    continue;
                }
                if ("nics".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.listNics();
                    continue;
                }
                if ("ipv4Config".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.listIPv4Config();
                    continue;
                }
                if ("ipv6Config".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.listIPv6Config();
                    continue;
                }
                if ("firewallRules".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.listFirewallRules();
                    continue;
                }
                if ("routes".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.listRoutes();
                    continue;
                }
                if ("storageHealth".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getStorageHealth();
                    continue;
                }
                if ("memHealth".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getMemHealth();
                    continue;
                }
                if ("loadHealth".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getLoadHealth();
                    continue;
                }
                if ("swapHealth".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getSwapHealth();
                    continue;
                }
                if ("cpuStats".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getCpuStats();
                    continue;
                }
                if ("memStats".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getMemStats();
                    continue;
                }
                if ("netStats".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.listNetStats();
                    continue;
                }
                if ("storageStats".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.listStorageStats();
                    continue;
                }
                if ("vmInfo".equals(propertyName)) {
                    propertyValue[i] = this.getVmInfo(cloudVmService);
                    continue;
                }
                if ("healthMessages".equals(propertyName)) {
                    propertyValue[i] = this.getHealthMessages(servers[i]);
                    continue;
                }
                if ("version".equals(propertyName)) {
                    propertyValue[i] = cloudVmService.getVersion();
                    continue;
                }
                if (CmUtil.UNHANDLED_PROPERTIES_TO_IGNORE.contains(propertyName)) break;
                _logger.warn((Object)("Unknown server property: " + propertyName));
                break;
            }
            catch (CloudVmServiceException e) {
                _logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                _logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                _logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return propertyValue;
    }

    @Override
    protected void sanitizeValues(String propertyName, Object[] results) {
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                assert (results != null);
                                if (!"uptime".equals(propertyName)) break block7;
                                for (int i = 0; i < results.length; ++i) {
                                    if (results[i] != null) continue;
                                    results[i] = -1.0;
                                }
                                break block8;
                            }
                            if (!"systemHealth".equals(propertyName)) break block9;
                            for (int i = 0; i < results.length; ++i) {
                                if (results[i] != null) continue;
                                results[i] = HealthState.UNKNOWN;
                            }
                            break block8;
                        }
                        if (!"deploymentType".equals(propertyName)) break block10;
                        for (int i = 0; i < results.length; ++i) {
                            if (results[i] != null) continue;
                            results[i] = ServerDeploymentType.UNKNOWN;
                        }
                        break block8;
                    }
                    if (!"isApplianceManaged".equals(propertyName)) break block11;
                    for (int i = 0; i < results.length; ++i) {
                        if (results[i] != null) continue;
                        results[i] = Boolean.FALSE;
                    }
                    break block8;
                }
                if (!"applmgmtExistsAndDown".equals(propertyName)) break block12;
                for (int i = 0; i < results.length; ++i) {
                    if (results[i] != null) continue;
                    results[i] = Boolean.FALSE;
                }
                break block8;
            }
            if (!"applmgmtControlState".equals(propertyName)) break block8;
            for (int i = 0; i < results.length; ++i) {
                if (results[i] != null) continue;
                results[i] = UNKOWN_APPLMGMT_CONTROL_STATE;
            }
        }
    }

    private String getHostname(InternalServerInfo server) throws CloudVmServiceException {
        assert (server != null);
        CloudVmService applmgmt = this.getCloudVmService(server);
        if (applmgmt != null && !this.isUnreachable(server)) {
            return applmgmt.getHostname();
        }
        return server.getHostname();
    }

    private X509Spec[][] getRootCertificates(String hostName) {
        X509Spec[][] certChain = this._vmcaService.getRootCertificate(hostName);
        return certChain;
    }

    private X509Spec[] getActiveCertificates(String hostName) {
        X509Spec[] certs = this._vmcaService.getActiveCertificates(hostName);
        return certs;
    }

    private X509Spec[] getRevokedCertificates(String hostName) {
        X509Spec[] certs = this._vmcaService.getRevokedCertificates(hostName);
        return certs;
    }

    private X509Spec[] getExpiredCertificates(String hostName) {
        X509Spec[] certs = this._vmcaService.getExpiredCertificates(hostName);
        return certs;
    }

    private String getPrimaryIconId(InternalServerInfo server) {
        ServerDeploymentType deploymentType = (ServerDeploymentType)((Object)this.getValuesPerProperty(new InternalServerInfo[]{server}, "deploymentType")[0]);
        return "CmUiImages:" + deploymentType.iconId;
    }

    private Object getVmInfo(CloudVmService cloudVmService) throws CloudVmServiceException {
        ArrayList<PropertyConstraint> propConstraints = new ArrayList<PropertyConstraint>();
        String[] nicNames = this.getNicNames(cloudVmService);
        IPv4Config[] listIPv4 = cloudVmService.getIPv4Config(nicNames);
        for (int i = 0; i < listIPv4.length; ++i) {
            if (StringUtil.isNullOrEmpty((String)listIPv4[i].address)) continue;
            PropertyConstraint pc = this.getPropConstraintForVmPerIp(listIPv4[i].address);
            propConstraints.add(pc);
        }
        IPv6Config[] listIPv6Config = cloudVmService.getIPv6Config(nicNames);
        for (int i = 0; i < listIPv6Config.length; ++i) {
            if (listIPv6Config[i].addresses == null) continue;
            IPv6Address[] listIPv6 = listIPv6Config[i].addresses;
            for (int j = 0; j < listIPv6.length; ++j) {
                if (StringUtil.isNullOrEmpty((String)listIPv6[i].address)) continue;
                PropertyConstraint pc = this.getPropConstraintForVmPerIp(listIPv6[j].address);
                propConstraints.add(pc);
            }
        }
        if (propConstraints.size() < 1) {
            _logger.info((Object)"Server IP addresses were not found.");
            return null;
        }
        CompositeConstraint constraint = QueryUtil.createCompositeConstraint((Constraint[])((Constraint[])propConstraints.toArray(new PropertyConstraint[propConstraints.size()])), (Conjoiner)Conjoiner.OR);
        constraint.targetType = VM_TYPE;
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"name"});
        ResultSet result = null;
        try {
            result = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result != null && result.error != null) {
            _logger.error((Object)result.error.getMessage(), (Throwable)result.error);
        }
        if (result == null || ArrayUtil.isNullOrEmpty((Object[])result.items)) {
            _logger.info((Object)"Server VM was not found.");
            return null;
        }
        VmInfo vmInfo = new VmInfo();
        vmInfo.vm = (ManagedObjectReference)result.items[0].resourceObject;
        if (!ArrayUtil.isNullOrEmpty((Object[])result.items[0].properties)) {
            vmInfo.name = result.items[0].properties[0].value.toString();
        }
        return vmInfo;
    }

    private String[] getNicNames(CloudVmService cloudVmService) throws CloudVmServiceException {
        NetworkInterfaceInfo[] nicsInfo = cloudVmService.listNics();
        ArrayList<String> nicNames = new ArrayList<String>();
        for (int i = 0; i < nicsInfo.length; ++i) {
            NetworkInterfaceInfo nicInfo = nicsInfo[i];
            if (nicInfo.status != NetworkInterfaceInfo.NetworkInterfaceStatus.UP) continue;
            nicNames.add(nicInfo.name);
        }
        return nicNames.toArray(new String[nicNames.size()]);
    }

    private PropertyConstraint getPropConstraintForVmPerIp(String ipAddress) {
        return QueryUtil.createPropertyConstraint((String)VM_TYPE, (String)"guest.ipAddress", (Comparator)Comparator.EQUALS, (Object)ipAddress);
    }

    private Collection<InternalServiceInfo> getRelatedServiceInfos(InternalServerInfo server) throws ServiceManagerFault {
        assert (server != null);
        if (this.isUnreachable(server)) {
            return new ArrayList<InternalServiceInfo>();
        }
        if (this._featureSwitch.useVmonForHost(server.getHostname())) {
            return CmUtil.getVmonServicesForServer(this._vmonConnectionRegistry, server.getHostname());
        }
        return CmUtil.getScaServicesForServer(this._scaServiceManager, server.getHostname());
    }

    private URI[] getRelatedServices(InternalServerInfo server) throws ServiceManagerFault {
        assert (server != null);
        if (this.isUnreachable(server)) {
            return new URI[0];
        }
        Collection services = (Collection)this.getValuesPerProperty(new InternalServerInfo[]{server}, "serviceInfos")[0];
        URI[] result = new URI[services.size()];
        Iterator it = services.iterator();
        int i = 0;
        while (it.hasNext()) {
            InternalServiceInfo service = (InternalServiceInfo)it.next();
            result[i++] = CmReferenceUtil.getServiceReference(service);
        }
        return result;
    }

    private HealthState getHealth(InternalServerInfo server) throws ServiceManagerFault {
        assert (server != null) : "Null server info provided";
        if (!this.isApplmgmtServiceAvailable(server) || this.isUnreachable(server)) {
            return HealthState.UNSUPPORTED;
        }
        ApplmgmtControlState applmgmtState = (ApplmgmtControlState)this.getValuesPerProperty(new InternalServerInfo[]{server}, "applmgmtControlState")[0];
        return applmgmtState.healthState;
    }

    private String[] getHealthMessages(InternalServerInfo server) throws ServiceManagerFault {
        assert (server != null) : "Null server info provided";
        if (!this.isApplmgmtServiceAvailable(server) || this.isUnreachable(server)) {
            return null;
        }
        ApplmgmtControlState applmgmtState = (ApplmgmtControlState)this.getValuesPerProperty(new InternalServerInfo[]{server}, "applmgmtControlState")[0];
        return applmgmtState.localizedHealthMessages;
    }

    private String getVersion(InternalServerInfo server) throws ServiceManagerFault {
        assert (server != null) : "Null server info provided";
        if (!this.isApplmgmtServiceAvailable(server) || this.isUnreachable(server)) {
            return null;
        }
        return this.getValuesPerProperty(new InternalServerInfo[]{server}, "version")[0].toString();
    }

    private ApplmgmtControlState getApplmgmtControlState(InternalServerInfo server) throws ServiceManagerFault {
        ApplmgmtControlState result;
        if (!this.isApplmgmtServiceAvailable(server) || this.isUnreachable(server)) {
            return null;
        }
        if (this._featureSwitch.useVmonForHost(server.getHostname())) {
            ServiceTypes.Info si = CmUtil.getVmonServiceInfo(this._vmonConnectionRegistry, server.getHostname(), "applmgmt");
            result = new ApplmgmtControlState(si);
        } else {
            ScaService sca = this._scaServiceManager.getService((Object)server.getHostname());
            ServiceControlManager controlManager = (ServiceControlManager)sca.getManagedObject(sca.getServiceContent().controlManager);
            ServiceState[] scaResult = controlManager.getServiceStates(new String[]{"applmgmt"}, 10L);
            result = new ApplmgmtControlState(scaResult[0]);
        }
        return result;
    }

    private boolean hasApplmgmtAndInRunningState(InternalServerInfo server, boolean isRunning) {
        if (this.isUnreachable(server)) {
            return !isRunning;
        }
        InternalServerInfo[] serverSingleton = new InternalServerInfo[]{server};
        boolean hasApplmgmt = (Boolean)this.getValuesPerProperty(serverSingleton, "isApplianceManaged")[0];
        if (!hasApplmgmt) {
            return false;
        }
        ApplmgmtControlState applmgmtState = (ApplmgmtControlState)this.getValuesPerProperty(serverSingleton, "applmgmtControlState")[0];
        return applmgmtState.runningState.isRunningState() == isRunning;
    }

    private boolean isUnreachable(InternalServerInfo server) {
        assert (server != null);
        boolean result = false;
        if (this._unreachableServerCache.getProperty(server.getHostname(), "__singleton") != null) {
            result = true;
        }
        return result;
    }

    private ServerDeploymentType getDeploymentType(InternalServerInfo server) throws ServiceManagerFault {
        ServerDeploymentType result = ServerDeploymentType.UNKNOWN;
        if (this.isUnreachable(server)) {
            return result;
        }
        if (!server.isDomainController()) {
            result = ServerDeploymentType.MANAGEMENT;
        } else {
            Object vcService;
            if (this._featureSwitch.useVmonForHost(server.getHostname())) {
                vcService = CmUtil.getVmonServiceInfo(this._vmonConnectionRegistry, server.getHostname(), "vpxd");
            } else {
                vcService = CmUtil.getScaServiceByName(this._scaServiceManager, server.getHostname(), "vmware-vpxd");
                if (vcService == null) {
                    vcService = CmUtil.getScaServiceByName(this._scaServiceManager, server.getHostname(), "vpxd");
                }
            }
            result = vcService != null ? ServerDeploymentType.EMBEDDED : ServerDeploymentType.INFRASTRUCTURE;
        }
        return result;
    }

    private ActiveDirectoryInfo getActiveDirectoryInfo(InternalServerInfo server) {
        if (this.isUnreachable(server)) {
            return null;
        }
        URI serverReference = CmReferenceUtil.getServerReference(server);
        SsoAdminService ssoAdminService = this._ssoServiceManager.getAdminService((Object)serverReference, SsoDomain.getLocal());
        try {
            ActiveDirectoryJoinInfo adJoinInfo = ssoAdminService.getSystemManagementService().getActiveDirectoryJoinStatus();
            ActiveDirectoryInfo result = null;
            if (ActiveDirectoryJoinInfo.JoinStatus.ACTIVE_DIRECTORY_JOIN_STATUS_DOMAIN.name().equals(adJoinInfo.joinStatus)) {
                result = new ActiveDirectoryInfo();
                result.domain = adJoinInfo.name;
            }
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)("Cannot get Active Directory join info for " + serverReference.toString()), (Throwable)e);
            return null;
        }
    }

    private boolean getActiveDirectoryJoined(InternalServerInfo server) {
        return this.getActiveDirectoryInfo(server) != null;
    }

    private LogManifestInfo getManifestArrays(InternalServerInfo server) throws IOException, SsoOverRestHelper.SsoOverRestHelperException {
        LogManifestInfo logManifest = new LogManifestInfo();
        URI manifestsUrl = this.getManifestUrl(server);
        if (manifestsUrl == null) {
            return null;
        }
        SsoOverRestRequest req = new SsoOverRestRequest(Request.Method.GET, manifestsUrl.toURL(), null);
        PrivateKey key = this._ssoService.getHokPrivateKey();
        Map authHeaders = SsoOverRestHelper.calcAuthHeader((com.vmware.cis.common.sso.SsoOverRestRequest)req, (PrivateKey)key, (SamlToken)AuthSessionUtil.getSsoToken(), (int)1024);
        HttpClient httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore(this._ksService.getKeyStore()).buildHttpClientIgnoreErrors();
        String httpResponse = httpClient.executeMethod(manifestsUrl.toString(), null, authHeaders);
        if (httpResponse == null) {
            _logger.error((Object)("Null manifest list retrieved from server" + server.getHostname()));
            return null;
        }
        String[] splitHttpResponse = httpResponse.split("(\n\n|\r\n\r\n)", 2);
        if (splitHttpResponse.length != 2) {
            _logger.error((Object)("Invalid manifest list retrieved from server" + server.getHostname()));
            return null;
        }
        logManifest.manifest = splitHttpResponse[1];
        return logManifest;
    }

    private URI getSupportBundleUrl(InternalServerInfo server) {
        String host = server.getHostname();
        ScaService sca = this._scaServiceManager.getService((Object)host);
        if (sca == null) {
            _logger.error((Object)("Error getting SCA service for " + host));
            return null;
        }
        URI scaUrl = sca.getVmomiClient().getBinding().getEndpointUri();
        URIBuilder builder = new URIBuilder(scaUrl);
        builder.setPath(SCA_SUPPORT_BUNDLE_PATH);
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private URI getManifestUrl(InternalServerInfo server) {
        URI supportBundleUrl = this.getSupportBundleUrl(server);
        URI result = null;
        if (supportBundleUrl != null) {
            try {
                result = new URIBuilder(supportBundleUrl).setParameter("params", "--listmanifests%20--xmloutput").build();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    private double getUptime(InternalServerInfo server) {
        assert (server != null);
        double result = -1.0;
        if (this.isUnreachable(server)) {
            return result;
        }
        try {
            CloudVmService cloudVmService = this.getCloudVmService(server);
            if (cloudVmService == null) {
                return result;
            }
            result = cloudVmService.getSystemStats().uptime;
        }
        catch (CloudVmServiceException clse) {
            _logger.error((Object)("Cloudvm exception thrown while getting server uptime: " + clse.getMessage()));
        }
        return result;
    }

    private boolean isApplmgmtServiceAvailable(InternalServerInfo server) {
        CloudVmService applmgmtUrl = this._applmgmtServiceRegistry.getCloudVmService(server.getHostname());
        return applmgmtUrl != null;
    }

    private CloudVmService getCloudVmService(InternalServerInfo server) {
        return this._applmgmtServiceRegistry.getCloudVmService(server.getHostname());
    }

    private boolean isDomainController(InternalServerInfo server) {
        return server.isDomainController();
    }

    private synchronized boolean isVMCAClientAvailable(String hostName) {
        boolean result = false;
        ConcurrentHashMap vmcaClientHashMap = this._vmcaService.getVmcaClientMap();
        result = vmcaClientHashMap == null ? false : vmcaClientHashMap.containsKey(hostName);
        return result;
    }

    private static class ApplmgmtControlState {
        ServiceStatus runningState;
        HealthState healthState;
        String[] localizedHealthMessages;

        ApplmgmtControlState(ServiceTypes.Info vmonServiceInfo) {
            this.runningState = CmUtil.vmonCodeToServiceStatus(vmonServiceInfo.getState());
            this.healthState = CmUtil.healthStateFromVmonHealthStatus(vmonServiceInfo.getHealth());
            this.localizedHealthMessages = CmUtil.extractHealthMessages(vmonServiceInfo);
        }

        ApplmgmtControlState(ServiceState scaServiceState) {
            this.runningState = CmUtil.scaCodeToServiceStatus(scaServiceState.controlStatus);
            this.healthState = CmUtil.healthStateFromScaHealthStatus(scaServiceState.healthStatus);
            this.localizedHealthMessages = CmUtil.extractHealthMessages(scaServiceState);
        }

        ApplmgmtControlState(ServiceStatus status, HealthState healthState, String[] localizedHealthMessages) {
            this.runningState = status;
            this.healthState = healthState;
            this.localizedHealthMessages = localizedHealthMessages;
        }
    }
}

