/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.vim.binding.sca.ServiceInfo;
import com.vmware.vim.binding.sca.configuration.ServiceConfigurationManager;
import com.vmware.vim.binding.sca.control.ServiceControlManager;
import com.vmware.vim.binding.sca.control.ServiceState;
import com.vmware.vim.binding.sca.control.StartupInfo;
import com.vmware.vim.binding.sca.control.StartupType;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.ServiceStartupType;
import com.vmware.vsphere.client.cm.ServiceStatus;
import com.vmware.vsphere.client.cm.util.CachingPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUiFeatureSwitch;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import com.vmware.vsphere.client.cm.util.ScmUtil;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceInfoPropertyValueExtractor
extends CachingPropertyValueExtractor<InternalServiceInfo> {
    private final UserSessionService _usService;
    private final Set<String> _propertiesNeedingRemoteCall;
    private final CmUiFeatureSwitch _killSwitch;
    private ScaServiceManager _scaServiceManager;
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;
    private static final Log _logger = LogFactory.getLog(ServiceInfoPropertyValueExtractor.class);

    public ServiceInfoPropertyValueExtractor(UserSessionService usService, PropertyCache<InternalServiceInfo> cache, Set<String> cacheableProperties, Executor executor, CmUiFeatureSwitch killSwitch, VapiConnectionManagerRegistry<String> vmonConnectionRegistry) {
        super(cache, cacheableProperties, executor);
        this._usService = usService;
        this._killSwitch = killSwitch;
        this._vmonConnectionRegistry = vmonConnectionRegistry;
        this._propertiesNeedingRemoteCall = new HashSet<String>();
        this._propertiesNeedingRemoteCall.add("scaServiceState");
        this._propertiesNeedingRemoteCall.add("startupType");
        this._propertiesNeedingRemoteCall.add("configurationRegistered");
        this._propertiesNeedingRemoteCall.add("resources");
        this._propertiesNeedingRemoteCall.add("configurations");
        this._propertiesNeedingRemoteCall.add("definitions");
    }

    public void setScaServiceManager(ScaServiceManager scaServiceManager) {
        this._scaServiceManager = scaServiceManager;
    }

    public Object[][] getValues(InternalServiceInfo[] services, String[] propertyNames) {
        Object[][] result = new Object[propertyNames.length][services.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            result[i] = this.getValuesPerProperty(services, propertyNames[i]);
        }
        return result;
    }

    @Override
    protected boolean propertyNeedsRemoteCall(String propertyName) {
        return this._propertiesNeedingRemoteCall.contains(propertyName);
    }

    @Override
    protected String getServerId(InternalServiceInfo info) {
        return info.getServerHostname();
    }

    protected Object[] getValuesPerPropertyDirectly(InternalServiceInfo[] services, String propertyName, boolean objectsAreOnSameServer) {
        Object[] propertyValue;
        block30: {
            assert (!this.propertyNeedsRemoteCall(propertyName) || objectsAreOnSameServer);
            propertyValue = null;
            try {
                if ("health".equals(propertyName)) {
                    propertyValue = this.getServiceHealthStates(services);
                    break block30;
                }
                if ("scaServiceState".equals(propertyName)) {
                    propertyValue = this.getServiceScaStates(services);
                    break block30;
                }
                if ("server".equals(propertyName)) {
                    propertyValue = this.getServersForServices(services);
                    break block30;
                }
                if ("serverName".equals(propertyName)) {
                    propertyValue = this.getServerHostnamesForServices(services);
                    break block30;
                }
                if ("name".equals(propertyName)) {
                    propertyValue = this.getServiceNames(services);
                    break block30;
                }
                if ("status".equals(propertyName)) {
                    propertyValue = this.getServiceStatuses(services);
                    break block30;
                }
                if ("startupType".equals(propertyName)) {
                    propertyValue = this.getServiceStartupTypes(services);
                    break block30;
                }
                if ("healthMessages".equals(propertyName)) {
                    propertyValue = this.getServiceHealthMessages(services);
                    break block30;
                }
                propertyValue = new Object[services.length];
                for (int i = 0; i < services.length; ++i) {
                    InternalServiceInfo service = services[i];
                    if ("shortName".equals(propertyName)) {
                        propertyValue[i] = this.getServiceShortName(service);
                        continue;
                    }
                    if ("serviceId".equals(propertyName)) {
                        propertyValue[i] = service.getServiceId();
                        continue;
                    }
                    if ("serviceType".equals(propertyName)) {
                        propertyValue[i] = this.getScaServiceType(service);
                        continue;
                    }
                    if ("isStartable".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.START);
                        continue;
                    }
                    if ("isStoppable".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.STOP);
                        continue;
                    }
                    if ("isRestartable".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.RESTART);
                        continue;
                    }
                    if ("startupTypeEditable".equals(propertyName)) {
                        propertyValue[i] = this.isServiceStartupTypeEditable(service);
                        continue;
                    }
                    if ("autoStartupTypeSupported".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.SET_STARTUPTYPE_AUTOMATIC);
                        continue;
                    }
                    if ("manualStartupTypeSupported".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.SET_STARTUPTYPE_MANUAL);
                        continue;
                    }
                    if ("disabledStartupTypeSupported".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.SET_STARTUPTYPE_DISABLED);
                        continue;
                    }
                    if ("configurationRegistered".equals(propertyName)) {
                        propertyValue[i] = ScmUtil.isResourceRegistered(this.getScmService(service), service);
                        continue;
                    }
                    if ("resources".equals(propertyName)) {
                        propertyValue[i] = ScmUtil.getResources(this.getScmService(service), service);
                        continue;
                    }
                    if ("configurations".equals(propertyName)) {
                        propertyValue[i] = ScmUtil.getConfigurations(this.getScmService(service), service);
                        continue;
                    }
                    if ("definitions".equals(propertyName)) {
                        propertyValue[i] = ScmUtil.getDefinitions(this.getScmService(service), service);
                        continue;
                    }
                    if (ScmUtil.isSettingsProperty(propertyName)) {
                        propertyValue[i] = ScmUtil.getSettings(this.getScmService(service), service, propertyName);
                        continue;
                    }
                    if ("relatedVc".equals(propertyName)) {
                        propertyValue[i] = this.getRelatedVc(service);
                        continue;
                    }
                    if ("description".equals(propertyName)) {
                        propertyValue[i] = this.getServiceDescription(service);
                        continue;
                    }
                    if (!CmUtil.UNHANDLED_PROPERTIES_TO_IGNORE.contains(propertyName)) {
                        _logger.warn((Object)("Unknown Service property: " + propertyName));
                    }
                    break;
                }
            }
            catch (ServiceManagerFault scae) {
                _logger.error((Object)String.format("SCA Service manager threw an error with code %d and message %s", scae.getErrorCode(), scae.getErrorMessage()), (Throwable)scae);
            }
        }
        return propertyValue;
    }

    @Override
    protected void sanitizeValues(String propertyName, Object[] values) {
        block5: {
            block6: {
                block4: {
                    assert (values != null);
                    if (!"startupType".equals(propertyName)) break block4;
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] != null) continue;
                        values[i] = ServiceStartupType.UNKNOWN;
                    }
                    break block5;
                }
                if (!"status".equals(propertyName)) break block6;
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != null) continue;
                    values[i] = ServiceStatus.UNKNOWN;
                }
                break block5;
            }
            if (!"health".equals(propertyName)) break block5;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                values[i] = HealthState.UNKNOWN;
            }
        }
    }

    private Object[] getServiceHealthMessages(InternalServiceInfo[] services) {
        String[][] result = new String[services.length][];
        HashMap vmonResults = new HashMap();
        HashMap<InternalServiceInfo, String[]> scaResults = new HashMap<InternalServiceInfo, String[]>();
        this.partitionScaAndVmonServices(services, scaResults, vmonResults);
        for (Map.Entry entry : vmonResults.entrySet()) {
            ServiceTypes.Info vmonServiceInfo = ((InternalServiceInfo)entry.getKey()).getVmonServiceInfo();
            entry.setValue(CmUtil.extractHealthMessages(vmonServiceInfo));
        }
        if (scaResults.size() > 0) {
            InternalServiceInfo[] scaInfos = scaResults.keySet().toArray(new InternalServiceInfo[0]);
            Object[] objectArray = this.getValuesPerProperty(scaInfos, "scaServiceState");
            for (int i = 0; i < scaInfos.length; ++i) {
                scaResults.put(scaInfos[i], CmUtil.extractHealthMessages((ServiceState)objectArray[i]));
            }
        }
        this.mergeScaAndVmonServiceResults(services, vmonResults, scaResults, result);
        return result;
    }

    private Object[] getServiceHealthStates(InternalServiceInfo[] services) {
        HealthState[] result = new HealthState[services.length];
        HashMap vmonResults = new HashMap();
        HashMap<InternalServiceInfo, HealthState> scaResults = new HashMap<InternalServiceInfo, HealthState>();
        this.partitionScaAndVmonServices(services, scaResults, vmonResults);
        for (Map.Entry entry : vmonResults.entrySet()) {
            ServiceTypes.Info vmonServiceInfo = ((InternalServiceInfo)entry.getKey()).getVmonServiceInfo();
            entry.setValue(CmUtil.healthStateFromVmonHealthStatus(vmonServiceInfo.getHealth()));
        }
        if (scaResults.size() > 0) {
            InternalServiceInfo[] scaInfos = scaResults.keySet().toArray(new InternalServiceInfo[0]);
            Object[] objectArray = this.getValuesPerProperty(scaInfos, "scaServiceState");
            for (int i = 0; i < scaInfos.length; ++i) {
                ServiceState ss = (ServiceState)objectArray[i];
                String healthStatus = ss != null ? ss.healthStatus : null;
                scaResults.put(scaInfos[i], CmUtil.healthStateFromScaHealthStatus(healthStatus));
            }
        }
        this.mergeScaAndVmonServiceResults(services, vmonResults, scaResults, result);
        return result;
    }

    private Object getRelatedVc(InternalServiceInfo service) {
        if (!"vcenterserver".equals(this.getScaServiceType(service))) {
            _logger.warn((Object)("VC requested for non-VC service: " + service.getServiceId()));
            return null;
        }
        ServerInfo[] servers = this._usService.getUserSession().serversInfo;
        String vcHostname = service.getServerHostname();
        if (vcHostname != null) {
            for (ServerInfo server : servers) {
                if (!vcHostname.equals(server.name)) continue;
                ServerInfoEx serverInfoEx = (ServerInfoEx)server;
                return ((ServiceInstanceContent)serverInfoEx.content).rootFolder;
            }
        }
        return null;
    }

    private String getScaServiceType(InternalServiceInfo service) {
        String serviceId = service.getServiceId();
        if ("vmware-vpxd".equals(serviceId) || "vpxd".equals(serviceId)) {
            return "vcenterserver";
        }
        return null;
    }

    private String getServiceShortName(InternalServiceInfo service) {
        assert (service != null);
        String resourceKey = this._killSwitch.useVmonForHost(service.getServerHostname()) ? service.getVmonServiceInfo().getNameKey() : service.getScaServiceInfo().getServiceNameResourceKey();
        String serviceName = null;
        if (!StringUtil.isNullOrEmpty((String)resourceKey)) {
            serviceName = LocalizationUtil.getLocalizedMessage((String)resourceKey);
        }
        if (serviceName == null) {
            String serviceType = service.getServiceId();
            serviceName = String.format("(%s) instance", serviceType);
        }
        return serviceName;
    }

    private String getServiceDescription(InternalServiceInfo service) {
        assert (service != null);
        String resourceKey = this._killSwitch.useVmonForHost(service.getServerHostname()) ? service.getVmonServiceInfo().getDescriptionKey() : service.getScaServiceInfo().getServiceDescriptionResourceKey();
        String serviceDescription = null;
        if (!StringUtil.isNullOrEmpty((String)resourceKey)) {
            serviceDescription = LocalizationUtil.getLocalizedMessage((String)resourceKey);
        }
        return serviceDescription;
    }

    private String[] getServiceNames(InternalServiceInfo[] services) {
        assert (services != null);
        String[] result = new String[services.length];
        for (int i = 0; i < services.length; ++i) {
            String serviceShortName = this.getServiceShortName(services[i]);
            String serverHostname = services[i].getServerHostname();
            result[i] = String.format("%s (%s)", serviceShortName, serverHostname);
        }
        return result;
    }

    private ServiceState[] getServiceScaStates(InternalServiceInfo[] infos) throws ServiceManagerFault {
        String serverHostname = infos[0].getServerHostname();
        assert (!this._killSwitch.useVmonForHost(serverHostname));
        String[] serviceIds = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            serviceIds[i] = infos[i].getScaServiceInfo().getServiceId();
        }
        ScaService sca = this._scaServiceManager.getService((Object)serverHostname);
        ServiceControlManager control = (ServiceControlManager)sca.getManagedObject(sca.getServiceContent().controlManager);
        return control.getServiceStates(serviceIds, 10L);
    }

    private ServiceStatus[] getServiceStatuses(InternalServiceInfo[] infos) throws ServiceManagerFault {
        ServiceStatus[] result = new ServiceStatus[infos.length];
        HashMap vmonResults = new HashMap();
        HashMap<InternalServiceInfo, ServiceStatus> scaResults = new HashMap<InternalServiceInfo, ServiceStatus>();
        this.partitionScaAndVmonServices(infos, scaResults, vmonResults);
        for (Map.Entry entry : vmonResults.entrySet()) {
            ServiceTypes.Info vmonServiceInfo = ((InternalServiceInfo)entry.getKey()).getVmonServiceInfo();
            entry.setValue(CmUtil.vmonCodeToServiceStatus(vmonServiceInfo.getState()));
        }
        if (scaResults.size() > 0) {
            InternalServiceInfo[] scaInfos = scaResults.keySet().toArray(new InternalServiceInfo[0]);
            Object[] objectArray = this.getValuesPerProperty(scaInfos, "scaServiceState");
            for (int i = 0; i < scaInfos.length; ++i) {
                if (objectArray[i] == null) {
                    scaResults.put(scaInfos[i], ServiceStatus.UNKNOWN);
                    continue;
                }
                scaResults.put(scaInfos[i], CmUtil.scaCodeToServiceStatus(((ServiceState)objectArray[i]).controlStatus));
            }
        }
        this.mergeScaAndVmonServiceResults(infos, vmonResults, scaResults, result);
        return result;
    }

    private ServiceStartupType[] getServiceStartupTypes(InternalServiceInfo[] services) throws ServiceManagerFault {
        String serverHostname = services[0].getServerHostname();
        ServiceStartupType[] result = new ServiceStartupType[services.length];
        if (this._killSwitch.useVmonForHost(serverHostname)) {
            for (int i = 0; i < services.length; ++i) {
                result[i] = CmUtil.serviceStartupTypeFromVmonStartupType(services[i].getVmonServiceInfo().getStartupType());
            }
        } else {
            String[] serviceIds = new String[services.length];
            for (int i = 0; i < services.length; ++i) {
                serviceIds[i] = services[i].getScaServiceInfo().getServiceId();
            }
            ScaService sca = this._scaServiceManager.getService((Object)serverHostname);
            ServiceControlManager controlManager = (ServiceControlManager)sca.getManagedObject(sca.getServiceContent().getControlManager());
            StartupInfo[] startupInfos = controlManager.getStartupTypes(serviceIds);
            for (int i = 0; i < serviceIds.length; ++i) {
                StartupType startupType = null;
                for (int j = 0; j < startupInfos.length; ++j) {
                    if (!startupInfos[j].serviceId.equalsIgnoreCase(serviceIds[i])) continue;
                    startupType = startupInfos[j].type;
                    break;
                }
                result[i] = CmUtil.serviceStartupTypeFromScaStartupType(startupType);
            }
        }
        return result;
    }

    private ServiceStatus getServiceStatus(InternalServiceInfo serviceInfo) throws ServiceManagerFault {
        return this.getServiceStatuses(new InternalServiceInfo[]{serviceInfo})[0];
    }

    private boolean isServiceStartupTypeEditable(InternalServiceInfo service) {
        if (this._killSwitch.useVmonForHost(service.getServerHostname())) {
            return true;
        }
        Object[] permittedActions = service.getScaServiceInfo().permittedActions;
        if (ArrayUtil.isNullOrEmpty((Object[])permittedActions)) {
            return false;
        }
        int supportedActions = 0;
        if (ArrayUtil.contains((Object)ServiceInfo.ControlActions.SET_STARTUPTYPE_AUTOMATIC.toString(), (Object[])permittedActions).booleanValue()) {
            ++supportedActions;
        }
        if (ArrayUtil.contains((Object)ServiceInfo.ControlActions.SET_STARTUPTYPE_MANUAL.toString(), (Object[])permittedActions).booleanValue()) {
            ++supportedActions;
        }
        if (ArrayUtil.contains((Object)ServiceInfo.ControlActions.SET_STARTUPTYPE_DISABLED.toString(), (Object[])permittedActions).booleanValue()) {
            ++supportedActions;
        }
        return supportedActions > 1;
    }

    private boolean isServiceControlActionAvailable(InternalServiceInfo service, ServiceInfo.ControlActions action) throws ServiceManagerFault {
        boolean result = true;
        if (!this._killSwitch.useVmonForHost(service.getServerHostname())) {
            ServiceInfo serviceInfo = service.getScaServiceInfo();
            boolean bl = result = result && ArrayUtil.contains((Object)action.name(), (Object[])serviceInfo.permittedActions) != false;
        }
        if (action == ServiceInfo.ControlActions.START) {
            result = result && this.serviceIsEnabled(service);
            result = result && this.getServiceStatus(service).isStoppedState();
        } else if (action == ServiceInfo.ControlActions.RESTART) {
            result = result && this.serviceIsEnabled(service);
            result = result && this.getServiceStatus(service).isRunningState();
            result = result && !ServiceInfoPropertyValueExtractor.isLocalWebClientServiceInstance(service);
        } else if (action == ServiceInfo.ControlActions.STOP) {
            result = result && this.getServiceStatus(service).isRunningState();
            result = result && !ServiceInfoPropertyValueExtractor.isLocalWebClientServiceInstance(service);
        } else if (action == ServiceInfo.ControlActions.SET_STARTUPTYPE_DISABLED) {
            result = result && this.getServiceStatus(service).isStoppedState();
        }
        return result;
    }

    private static boolean isLocalWebClientServiceInstance(InternalServiceInfo service) {
        boolean result = false;
        if (!"vsphere-client".equalsIgnoreCase(service.getServiceId())) {
            return result;
        }
        InetAddress[] localAddresses = null;
        InetAddress webClientAddress = null;
        try {
            localAddresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            webClientAddress = InetAddress.getByName(service.getServerHostname());
        }
        catch (UnknownHostException e) {
            _logger.error((Object)"Error getting host address", (Throwable)e);
        }
        if (localAddresses != null && webClientAddress != null) {
            for (InetAddress localAddress : localAddresses) {
                if (!localAddress.getHostAddress().equalsIgnoreCase(webClientAddress.getHostAddress())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean serviceIsEnabled(InternalServiceInfo service) {
        ServiceStartupType startupType = (ServiceStartupType)((Object)this.getValuesPerProperty(new InternalServiceInfo[]{service}, "startupType")[0]);
        return ServiceStartupType.DISABLED != startupType;
    }

    private URI[] getServersForServices(InternalServiceInfo[] services) {
        assert (services != null);
        URI[] result = new URI[services.length];
        for (int i = 0; i < services.length; ++i) {
            result[i] = CmReferenceUtil.getServerReference(services[i].getServerHostname());
        }
        return result;
    }

    private String[] getServerHostnamesForServices(InternalServiceInfo[] services) {
        assert (services != null);
        String[] result = new String[services.length];
        for (int i = 0; i < services.length; ++i) {
            result[i] = services[i].getServerHostname();
        }
        return result;
    }

    private ServiceConfigurationManager getScmService(InternalServiceInfo service) {
        if (service == null) {
            return null;
        }
        String hostname = service.getServerHostname();
        ScaService scaService = this._scaServiceManager.getService((Object)hostname);
        com.vmware.vim.binding.sca.ServiceInstanceContent sic = scaService.getServiceContent();
        return (ServiceConfigurationManager)scaService.getManagedObject(sic.configManager);
    }

    private <ResultType> void partitionScaAndVmonServices(InternalServiceInfo[] services, Map<InternalServiceInfo, ResultType> scaServices, Map<InternalServiceInfo, ResultType> vmonServices) {
        assert (services != null && scaServices != null && vmonServices != null);
        assert (scaServices.size() == 0 && vmonServices.size() == 0);
        HashMap nodeSet = new HashMap();
        for (InternalServiceInfo i : services) {
            nodeSet.put(i.getServerHostname(), null);
        }
        for (Map.Entry entry : nodeSet.entrySet()) {
            entry.setValue(this._killSwitch.useVmonForHost((String)entry.getKey()));
        }
        for (InternalServiceInfo s : services) {
            if (((Boolean)nodeSet.get(s.getServerHostname())).booleanValue()) {
                vmonServices.put(s, null);
                continue;
            }
            scaServices.put(s, null);
        }
    }

    private <ResultType> void mergeScaAndVmonServiceResults(InternalServiceInfo[] services, Map<InternalServiceInfo, ResultType> scaResults, Map<InternalServiceInfo, ResultType> vmonResults, ResultType[] result) {
        for (int i = 0; i < services.length; ++i) {
            result[i] = vmonResults.containsKey(services[i]) ? vmonResults.get(services[i]) : scaResults.get(services[i]);
        }
    }
}

