/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.authentication;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class DsHttpSession
implements HttpSession {
    private static final ServletContext _servletContext = new DsServletContext();
    private static final String UNSUPPORTED_HTTP_SESSION_OPERATION = "Unsupported CIS DS http session operation";
    private final String _sessionId;
    private final ConcurrentMap<String, Object> _attributes = new ConcurrentHashMap<String, Object>();

    public DsHttpSession(String sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("The session ID should not be null");
        }
        this._sessionId = sessionId;
    }

    public String getId() {
        return this._sessionId;
    }

    public Object getAttribute(String name) {
        Object attribute = this._attributes.get(name);
        return attribute;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> en = this.doGetAttributeNames();
        return en;
    }

    private Enumeration<String> doGetAttributeNames() {
        Set attrNames = this._attributes.keySet();
        final Iterator iter = attrNames.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iter.next();
            }
        };
    }

    public String[] getValueNames() {
        Enumeration<String> en = this.doGetAttributeNames();
        if (!en.hasMoreElements()) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
    }

    public ServletContext getServletContext() {
        return _servletContext;
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException(UNSUPPORTED_HTTP_SESSION_OPERATION);
    }

    public long getLastAccessedTime() {
        throw new UnsupportedOperationException(UNSUPPORTED_HTTP_SESSION_OPERATION);
    }

    public void setMaxInactiveInterval(int interval) {
        throw new UnsupportedOperationException(UNSUPPORTED_HTTP_SESSION_OPERATION);
    }

    public int getMaxInactiveInterval() {
        throw new UnsupportedOperationException(UNSUPPORTED_HTTP_SESSION_OPERATION);
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException(UNSUPPORTED_HTTP_SESSION_OPERATION);
    }

    public boolean isNew() {
        throw new UnsupportedOperationException(UNSUPPORTED_HTTP_SESSION_OPERATION);
    }

    static class DsServletContext
    implements ServletContext {
        private static final String UNSUPPORTED_SERVLET_CONTEXT_OPERATION = "Unsupported CIS DS servlet context operation";

        DsServletContext() {
        }

        public String getServletContextName() {
            return "CIS Data Service";
        }

        public String getContextPath() {
            return "ds/sdk";
        }

        public ServletContext getContext(String uripath) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public int getMajorVersion() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public int getMinorVersion() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public String getMimeType(String file) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Set<String> getResourcePaths(String path) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public URL getResource(String path) throws MalformedURLException {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public InputStream getResourceAsStream(String path) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Servlet getServlet(String name) throws ServletException {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Enumeration<Servlet> getServlets() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Enumeration<String> getServletNames() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void log(String msg) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void log(Exception exception, String msg) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void log(String message, Throwable throwable) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public String getRealPath(String path) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public String getServerInfo() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public String getInitParameter(String name) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Enumeration<String> getInitParameterNames() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Object getAttribute(String name) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Enumeration<String> getAttributeNames() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void setAttribute(String name, Object object) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void removeAttribute(String name) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void declareRoles(String ... roleNames) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public String getVirtualServerName() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public FilterRegistration.Dynamic addFilter(String arg0, String arg1) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public FilterRegistration.Dynamic addFilter(String arg0, Filter arg1) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public FilterRegistration.Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void addListener(String arg0) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public <T extends EventListener> void addListener(T arg0) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void addListener(Class<? extends EventListener> arg0) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public ServletRegistration.Dynamic addServlet(String arg0, String arg1) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public ServletRegistration.Dynamic addServlet(String arg0, Servlet arg1) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public ServletRegistration.Dynamic addServlet(String arg0, Class<? extends Servlet> arg1) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public <T extends Filter> T createFilter(Class<T> arg0) throws ServletException {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public <T extends EventListener> T createListener(Class<T> arg0) throws ServletException {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public <T extends Servlet> T createServlet(Class<T> arg0) throws ServletException {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public ClassLoader getClassLoader() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public int getEffectiveMajorVersion() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public int getEffectiveMinorVersion() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public FilterRegistration getFilterRegistration(String arg0) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public ServletRegistration getServletRegistration(String arg0) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public SessionCookieConfig getSessionCookieConfig() {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public boolean setInitParameter(String arg0, String arg1) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> arg0) {
            throw new UnsupportedOperationException(UNSUPPORTED_SERVLET_CONTEXT_OPERATION);
        }
    }
}

