/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DevCeipConfigProviderWrapper
implements CeipConfigProvider {
    private static final String DEV_OVERRIDE_ENABLEMENT_FLAG = "dev.usageDataCollector.forceCollectorEnabled";
    private static final Log _log = LogFactory.getLog(DevCeipConfigProviderWrapper.class);
    private final CeipConfigProvider _ceipConfigProvider;
    private final ConfigurationService _configurationService;

    public DevCeipConfigProviderWrapper(CeipConfigProvider ceipConfigProvider, ConfigurationService configurationService) {
        this._ceipConfigProvider = ceipConfigProvider;
        this._configurationService = configurationService;
    }

    public boolean isCeipEnabled() {
        boolean devModeIsEnabled = this.getConfigFlag(DEV_OVERRIDE_ENABLEMENT_FLAG);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("dev property: " + devModeIsEnabled));
        }
        return this._ceipConfigProvider.isCeipEnabled() || devModeIsEnabled;
    }

    private boolean getConfigFlag(String flagName) {
        Object[] truths = new String[]{"yes", "on", "true"};
        String flagValue = this._configurationService.getProperty(flagName);
        return ArrayUtils.contains((Object[])truths, (Object)StringUtils.lowerCase((String)flagValue));
    }
}

