/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.util;

import com.vmware.ph.ceip.authentication.InitializationException;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.common.Environment;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsProperties {
    private static final Logger logger = LoggerFactory.getLogger(DsProperties.class);
    private static final DsProperties INSTANCE = new DsProperties();
    static final String DATA_SERVICE_CONFIG_FILE = "config/ds.properties";
    static final String SERVICE_HOME_LDU = "service.homeLdu";
    static final String KEYSTORE_PATH = "solutionUser.keyStorePath";
    static final String KEYSTORE_PASSWORD = "solutionUser.keyStorePassword";
    private final PropertiesLoader propertiesLoader = new PropertiesLoader();
    private final DsPropertiesFileLocator dsPropertiesFileLocator = new DsPropertiesFileLocator();
    private String homeLdu;
    Properties configProperties;

    public static DsProperties getInstance() {
        return INSTANCE;
    }

    DsProperties() {
    }

    public String getHomeLdu() {
        this.initializeOnce();
        return this.homeLdu;
    }

    public String getKeyStorePassword() {
        this.initializeOnce();
        return DsProperties.getConfigProperty(this.configProperties, KEYSTORE_PASSWORD);
    }

    public String getKeyStorePath() {
        this.initializeOnce();
        return DsProperties.getConfigProperty(this.configProperties, KEYSTORE_PATH);
    }

    private synchronized void initializeOnce() {
        if (this.homeLdu == null) {
            this.doInitializeConfiguration();
        }
    }

    private void doInitializeConfiguration() {
        File dsConfigFile = this.dsPropertiesFileLocator.getDsPropertiesFile(DATA_SERVICE_CONFIG_FILE);
        logger.info("Configuration file ds.properties absolute path=" + dsConfigFile);
        this.configProperties = this.propertiesLoader.loadProperties(dsConfigFile);
        this.homeLdu = DsProperties.getConfigProperty(this.configProperties, SERVICE_HOME_LDU);
    }

    static String getConfigProperty(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            String msg = String.format("Required configuration property `%s' not found in config file `%s'", key, DATA_SERVICE_CONFIG_FILE);
            throw new InitializationException(msg);
        }
        value = value.trim();
        logger.debug("Successfully loaded property with key: '{}' and value: '{}'", (Object)key, (Object)value);
        return value.trim();
    }

    static class DsPropertiesFileLocator {
        DsPropertiesFileLocator() {
        }

        public File getDsPropertiesFile(String relativePath) {
            File dsConfigFile = new File(Environment.clientAppDataFolder(), relativePath);
            return dsConfigFile;
        }
    }

    static class PropertiesLoader {
        PropertiesLoader() {
        }

        public Properties loadProperties(File loadFromFile) {
            String configFilePath = loadFromFile.getAbsolutePath();
            try {
                return FileUtil.loadProperties((String)configFilePath);
            }
            catch (IOException e) {
                throw new InitializationException("Cannot load properties file: " + configFilePath, e);
            }
        }
    }
}

