/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.codecapture;

import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.h5.codecapture.CodeCaptureRecordingService;
import com.vmware.vsphere.client.h5.codecapture.CodeCaptureTranslationService;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/codecapture"}, method={RequestMethod.POST}, produces={"text/plain;charset=utf-8"})
public class CodeCaptureController {
    private static final Log _logger = LogFactory.getLog(CodeCaptureController.class);
    private final CodeCaptureRecordingService _recordingService;
    private final CodeCaptureTranslationService _translationService;

    public CodeCaptureController(CodeCaptureRecordingService recordingService, CodeCaptureTranslationService translationService) {
        this._recordingService = recordingService;
        this._translationService = translationService;
    }

    @RequestMapping(value={"/start"})
    @ResponseBody
    public String startRecording() {
        String clientId = SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession());
        return String.valueOf(this._recordingService.startRecording(clientId));
    }

    @RequestMapping(value={"/stop"})
    @ResponseBody
    public String stopRecording() {
        String clientId = SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession());
        return String.valueOf(this._recordingService.stopRecording(clientId));
    }

    @RequestMapping(value={"/recording"})
    @ResponseBody
    public String isRecordingInProgress() {
        String clientId = SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession());
        return String.valueOf(this._recordingService.isRecordingInProgress(clientId));
    }

    @RequestMapping(value={"/recordedData"})
    @ResponseBody
    public String getRecordedData() {
        String clientId = SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession());
        return this._recordingService.getRecordedData(clientId);
    }

    @RequestMapping(value={"/translate"})
    @ResponseBody
    public String translate(@RequestBody Map<String, String> translationSpec) {
        if (translationSpec == null) {
            _logger.info((Object)"Received null translationSpec.");
            return null;
        }
        String clientId = SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession());
        String language = translationSpec.get("language");
        String recordedApiCalls = translationSpec.get("recordedData");
        return this._translationService.translate(clientId, language, recordedApiCalls);
    }
}

