/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.impl;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.common.data.DataProviderAdapterHelper;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.ResultObject;
import com.vmware.vsphere.client.vcextension.common.SearchUtil;
import com.vmware.vsphere.client.vcextension.common.VcExtensionManagerProxy;
import com.vmware.vsphere.client.vcextension.util.VcExtensionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="VirtualMachine")
public class ExtensionServerVmProvider
extends DataProviderAdapterBase {
    public static final Log _logger = LogFactory.getLog(ExtensionServerVmProvider.class);
    private static final String TYPE_VIRTUAL_MACHINE = "VirtualMachine";
    private static final String OPTION_STORE_RELATION_TYPE_PROPERTY = "storeRelationType";
    private final DataService _dataService;
    private final VcExtensionManagerProxy _extensionManagerProxy;

    public ExtensionServerVmProvider(DataService dataService, VcExtensionManagerProxy extensionManagerProxy) {
        assert (dataService != null) : "Data service null";
        assert (extensionManagerProxy != null) : "Extension manager proxy null";
        this._dataService = dataService;
        this._extensionManagerProxy = extensionManagerProxy;
    }

    protected ResultSet processQuery(RelationalConstraint constraint, QuerySpec query) {
        if (!constraint.hasInverseRelation || !"extensionServer".equals(constraint.relation)) {
            return ResultUtil.newEmptyResultSet();
        }
        ExtensionUriSpec extensionUri = SearchUtil.getRelatedExtensionSpec((RelationalConstraint)constraint);
        if (extensionUri == null) {
            return ResultUtil.newEmptyResultSet();
        }
        try {
            Extension extension = VcExtensionUtil.getExtension(extensionUri, this._extensionManagerProxy);
            if (extension == null) {
                _logger.warn((Object)"Server VM requested for a VC extension that does not exist");
                return ResultUtil.newEmptyResultSet();
            }
            ManagedObjectReference serverVm = VcExtensionUtil.getServerVm(extension);
            if (serverVm == null) {
                return ResultUtil.newEmptyResultSet();
            }
            if (query.resultSpec.maxResultCount == 0) {
                return SearchUtil.createResultSet((int)1);
            }
            ResultSet result = new ResultSet();
            result.totalMatchedObjectCount = 1;
            result.items = new ResultItem[1];
            result.items[0] = new ResultItem();
            result.items[0].resourceObject = serverVm;
            if (SearchUtil.queryHasOption((QuerySpec)query, (String)OPTION_STORE_RELATION_TYPE_PROPERTY, (Object)true) || SearchUtil.isPropertyRequested((String)"vcExtensionRelatedObjectType", (QuerySpec)query)) {
                String type2 = VcExtensionUtil.getLocalizedString("serverVm.relationType", new String[0]);
                PropertyValue property = ResultUtil.newProperty((String)"vcExtensionRelatedObjectType", (Object)type2);
                result.items[0].properties = new PropertyValue[]{property};
            }
            return result;
        }
        catch (Exception extMngrEx) {
            _logger.error((Object)("Exception trying to get ExtensionManager on VC " + extensionUri.getServerGuid()), (Throwable)extMngrEx);
            return ResultUtil.newErrorResultSet((Exception[])new Exception[]{extMngrEx});
        }
    }

    protected ResultSet processQuery(CompositeConstraint constraint, QuerySpec query) {
        Set relationalConstraints = SearchUtil.getSubConstraints((Constraint)constraint, RelationalConstraint.class, (String)TYPE_VIRTUAL_MACHINE, (Conjoiner)Conjoiner.OR, (boolean)true);
        Iterator relationItr = relationalConstraints.iterator();
        while (relationItr.hasNext()) {
            String relation = ((RelationalConstraint)relationItr.next()).relation;
            if ("extensionServer".equals(relation)) continue;
            relationItr.remove();
        }
        if (relationalConstraints.isEmpty()) {
            return ResultUtil.newEmptyResultSet();
        }
        Set propertyConstraints = SearchUtil.getSubConstraints((Constraint)constraint, PropertyConstraint.class, (String)TYPE_VIRTUAL_MACHINE, (Conjoiner)Conjoiner.OR, (boolean)true);
        if (SearchUtil.isPropertyConstrained((Iterable)propertyConstraints, (String)"vcExtensionRelatedObjectType")) {
            if (query.options == null) {
                query.options = new HashMap(1);
            }
            query.options.put(OPTION_STORE_RELATION_TYPE_PROPERTY, true);
        }
        ArrayList<ResultSet> results = new ArrayList<ResultSet>();
        for (RelationalConstraint relation : relationalConstraints) {
            ResultSet result = this.processQuery(relation, query);
            results.add(result);
        }
        if (propertyConstraints.isEmpty()) {
            return DataProviderAdapterHelper.mergeResultSets(results);
        }
        ArrayList<ResultObject> ojects = new ArrayList<ResultObject>();
        for (ResultSet result : results) {
            if (result.totalMatchedObjectCount <= 0) continue;
            assert (result.items.length == 1);
            assert (result.items[0].resourceObject instanceof ManagedObjectReference);
            ManagedObjectReference obj = (ManagedObjectReference)result.items[0].resourceObject;
            ResultObject resultObj = ResultObject.newInstance((ManagedObjectReference)obj);
            resultObj.add(result.items[0].properties);
            ojects.add(resultObj);
        }
        return SearchUtil.createFilteredResultSet(ojects, (Set)propertyConstraints, (QuerySpec)query, (DataService)this._dataService);
    }
}

