/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.SearchUtil;
import com.vmware.vsphere.client.vcextension.util.VcExtensionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="VirtualMachine,VirtualApp")
public class RelatedObjectsSearchProvider
extends DataProviderAdapterBase {
    private static final Log _logger = LogFactory.getLog(RelatedObjectsSearchProvider.class);
    private static final String RELATION_EXTENSION_VM = "extensionVirtualMachine";
    private static final String RELATION_EXTENSION_VAPP = "extensionVirtualApp";
    private static final String RELATION_VC_VMS = "dcFolderedVm";
    private static final String RELATION_VC_VAPPS = "allVApps";
    private static final String TYPE_VIRTUAL_MACHINE = "VirtualMachine";
    private static final String TYPE_VAPP = "VirtualApp";
    private static final String PROPERTY_VM_MANAGED_BY = "config.managedBy.extensionKey";
    private static final String PROPERTY_VAPP_MANAGED_BY = "vAppConfig.managedBy.extensionKey";
    private final DataService _dataService;

    public RelatedObjectsSearchProvider(DataService dataService) {
        this._dataService = dataService;
    }

    protected ResultSet processQuery(RelationalConstraint constraint, QuerySpec sourceQuery) {
        if (!this.isValidRelation(constraint)) {
            return ResultUtil.newEmptyResultSet();
        }
        ExtensionUriSpec relationSource = SearchUtil.getRelatedExtensionSpec((RelationalConstraint)constraint);
        if (relationSource == null) {
            return ResultUtil.newEmptyResultSet();
        }
        return this.getResult(relationSource, null, sourceQuery);
    }

    protected ResultSet processQuery(CompositeConstraint constraint, QuerySpec sourceQuery) {
        List relations = SearchUtil.getElementsOfType(RelationalConstraint.class, (Object[])constraint.nestedConstraints);
        if (relations.size() != 1) {
            return ResultUtil.newEmptyResultSet();
        }
        RelationalConstraint parentConstraint = (RelationalConstraint)relations.get(0);
        if (!this.isValidRelation(parentConstraint)) {
            return ResultUtil.newEmptyResultSet();
        }
        ExtensionUriSpec extensionContext = SearchUtil.getRelatedExtensionSpec((RelationalConstraint)parentConstraint);
        if (extensionContext == null) {
            _logger.warn((Object)("Invalid related object for the relation extensionVirtualMachine: " + parentConstraint.constraintOnRelatedObject));
            return ResultUtil.newEmptyResultSet();
        }
        Constraint remainingConstraints = this.removeSubConstraint(constraint, (Constraint)parentConstraint);
        return this.getResult(extensionContext, remainingConstraints, sourceQuery);
    }

    private ResultSet getResult(ExtensionUriSpec extension, Constraint constraintOnMatchedObjects, QuerySpec sourceQuery) {
        assert (extension != null && sourceQuery != null);
        QuerySpec query = this.createRelatedObjectsQuery(extension, sourceQuery, constraintOnMatchedObjects);
        ResultSet result = null;
        try {
            result = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        }
        catch (Exception ex) {
            _logger.error((Object)("Data service exception on on requesting related objects for " + extension), (Throwable)ex);
            return ResultUtil.newErrorResultSet((Exception[])new Exception[]{ex});
        }
        assert (result != null);
        if (SearchUtil.isObjectCountQuery((QuerySpec)sourceQuery) || ArrayUtil.isNullOrEmpty((Object[])result.items)) {
            return result;
        }
        this.addRelationTypeProperty(sourceQuery, result);
        if (!this.isLocalSortingRequired(sourceQuery)) {
            return result;
        }
        ResultUtil.sortResult((ResultSet)result, (ResultSpec)sourceQuery.resultSpec);
        ResultUtil.pageResult((ResultSet)result, (ResultSpec)sourceQuery.resultSpec);
        return result;
    }

    private void addRelationTypeProperty(QuerySpec sourceQuery, ResultSet result) {
        if (!SearchUtil.isPropertyRequested((String)"vcExtensionRelatedObjectType", (QuerySpec)sourceQuery)) {
            return;
        }
        String managedByType = VcExtensionUtil.getLocalizedString("managedVmOrVApp.relationType", new String[0]);
        for (ResultItem resultItem : result.items) {
            if (ResultUtil.hasProperty((ResultItem)resultItem, (String)"vcExtensionRelatedObjectType")) continue;
            PropertyValue managedByProperty = ResultUtil.newProperty((String)"vcExtensionRelatedObjectType", (Object)managedByType, (Object)resultItem.resourceObject);
            ResultUtil.addProperty((ResultItem)resultItem, (PropertyValue)managedByProperty);
        }
    }

    private QuerySpec createRelatedObjectsQuery(ExtensionUriSpec extension, QuerySpec sourceQuery, Constraint matchedObjectConstraint) {
        String targetType = sourceQuery.resourceSpec.constraint.targetType;
        Constraint relatedObjectsConstraint = null;
        if (TYPE_VAPP.equals(targetType)) {
            relatedObjectsConstraint = this.createManagedByConstraint(extension, TYPE_VAPP);
        } else {
            assert (TYPE_VIRTUAL_MACHINE.equals(targetType));
            relatedObjectsConstraint = this.createRelatedVmsConstraint(extension);
        }
        matchedObjectConstraint = this.transformMatchedObjectConstraint(matchedObjectConstraint, targetType, extension);
        Object queryConstraint = null;
        queryConstraint = matchedObjectConstraint != null ? QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relatedObjectsConstraint, matchedObjectConstraint}, (Conjoiner)Conjoiner.AND) : relatedObjectsConstraint;
        QuerySpec query = new QuerySpec();
        query.name = sourceQuery.name + "-childQuery";
        query.resourceSpec = new ResourceSpec();
        query.resourceSpec.constraint = queryConstraint;
        query.resourceSpec.propertySpecs = sourceQuery.resourceSpec.propertySpecs;
        if (this.isLocalSortingRequired(sourceQuery)) {
            assert (sourceQuery.resultSpec != null);
            query.resultSpec = (ResultSpec)ObjectUtil.shallowCopy((Object)sourceQuery.resultSpec, ResultSpec.class);
            query.resultSpec.maxResultCount = -1;
        } else {
            query.resultSpec = sourceQuery.resultSpec;
        }
        return query;
    }

    private Constraint createRelatedVmsConstraint(ExtensionUriSpec extension) {
        Constraint[] relations = new Constraint[3];
        ObjectIdentityConstraint relatedVcExtension = new ObjectIdentityConstraint();
        relatedVcExtension.target = extension.getUri();
        relatedVcExtension.targetType = "VcExtension";
        relations[0] = QueryUtil.createRelationalConstraint((String)"extensionServer", (Constraint)relatedVcExtension, (Boolean)true, (String)TYPE_VIRTUAL_MACHINE);
        relations[1] = QueryUtil.createRelationalConstraint((String)"esxAgent", (Constraint)relatedVcExtension, (Boolean)true, (String)TYPE_VIRTUAL_MACHINE);
        relations[2] = this.createManagedByConstraint(extension, TYPE_VIRTUAL_MACHINE);
        Constraint relatedVmsConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])relations, (Conjoiner)Conjoiner.OR);
        relatedVmsConstraint.targetType = TYPE_VIRTUAL_MACHINE;
        return relatedVmsConstraint;
    }

    private Constraint createManagedByConstraint(ExtensionUriSpec extension, String targetType) {
        assert (TYPE_VAPP.equals(targetType) || TYPE_VIRTUAL_MACHINE.equals(targetType));
        Constraint[] subConstraints = new Constraint[2];
        subConstraints[0] = this.createManagedByPropertyConstraint(extension, targetType);
        ManagedObjectReference rootFolderRef = this.serverGuidToRootFolder(extension.getServerGuid());
        subConstraints[1] = TYPE_VIRTUAL_MACHINE.equals(targetType) ? QueryUtil.createConstraintForRelationship((Object)rootFolderRef, (String)RELATION_VC_VMS, (String)targetType) : QueryUtil.createConstraintForRelationship((Object)rootFolderRef, (String)RELATION_VC_VAPPS, (String)targetType);
        CompositeConstraint result = QueryUtil.createCompositeConstraint((Constraint[])subConstraints, (Conjoiner)Conjoiner.AND);
        result.targetType = targetType;
        return result;
    }

    private PropertyConstraint createManagedByPropertyConstraint(ExtensionUriSpec extension, String targetType) {
        assert (TYPE_VAPP.equals(targetType) || TYPE_VIRTUAL_MACHINE.equals(targetType));
        if (TYPE_VIRTUAL_MACHINE.equals(targetType)) {
            return QueryUtil.createPropertyConstraint((String)targetType, (String)PROPERTY_VM_MANAGED_BY, (Comparator)Comparator.EQUALS, (Object)extension.getKey());
        }
        return QueryUtil.createPropertyConstraint((String)targetType, (String)PROPERTY_VAPP_MANAGED_BY, (Comparator)Comparator.EQUALS, (Object)extension.getKey());
    }

    private Constraint transformMatchedObjectConstraint(Constraint constraints, String targetType, ExtensionUriSpec extensionContext) {
        if (constraints == null) {
            return constraints;
        }
        Set propertyConstraints = SearchUtil.getSubConstraints((Constraint)constraints, PropertyConstraint.class, (String)targetType, (Conjoiner)Conjoiner.OR, (boolean)true);
        PropertyConstraint relationTypeConstraint = SearchUtil.getPropertyConstraint((Iterable)propertyConstraints, (String)"vcExtensionRelatedObjectType");
        if (relationTypeConstraint == null) {
            return constraints;
        }
        String managedByRelation = VcExtensionUtil.getLocalizedString("managedVmOrVApp.relationType", new String[0]);
        if (!SearchUtil.meetsConstraint((Object)managedByRelation, (PropertyConstraint)relationTypeConstraint)) {
            return constraints;
        }
        PropertyConstraint managedByConstraint = this.createManagedByPropertyConstraint(extensionContext, targetType);
        if (constraints instanceof CompositeConstraint && ((CompositeConstraint)constraints).conjoiner == Conjoiner.OR) {
            CompositeConstraint composite = (CompositeConstraint)constraints;
            int newLength = composite.nestedConstraints.length + 1;
            composite.nestedConstraints = Arrays.copyOfRange(composite.nestedConstraints, 0, newLength);
            composite.nestedConstraints[newLength - 1] = managedByConstraint;
            return composite;
        }
        return QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{constraints, managedByConstraint}, (Conjoiner)Conjoiner.OR);
    }

    private Constraint removeSubConstraint(CompositeConstraint constraint, Constraint filterTarget) {
        assert (ArrayUtil.contains((Object)filterTarget, (Object[])constraint.nestedConstraints).booleanValue());
        Constraint remainingConstraints = null;
        if (constraint.nestedConstraints.length > 1) {
            Constraint[] subConstraints = new Constraint[constraint.nestedConstraints.length - 1];
            int subConstraintIdx = 0;
            for (Constraint subConstraint : constraint.nestedConstraints) {
                if (subConstraint == filterTarget) continue;
                subConstraints[subConstraintIdx++] = subConstraint;
            }
            remainingConstraints = QueryUtil.combineIntoSingleConstraint((Constraint[])subConstraints, (Conjoiner)constraint.conjoiner);
        }
        return remainingConstraints;
    }

    private boolean isLocalSortingRequired(QuerySpec query) {
        if (query.resultSpec == null || query.resultSpec.order == null || SearchUtil.isObjectCountQuery((QuerySpec)query)) {
            return false;
        }
        for (OrderingPropertySpec orderSpec : query.resultSpec.order.orderingProperties) {
            for (String propertyName : orderSpec.propertyNames) {
                if (!"vcExtensionRelatedObjectType".equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidRelation(RelationalConstraint constraint) {
        if (!constraint.hasInverseRelation) {
            return false;
        }
        if (TYPE_VIRTUAL_MACHINE.equals(constraint.targetType) && RELATION_EXTENSION_VM.equals(constraint.relation)) {
            return true;
        }
        return TYPE_VAPP.equals(constraint.targetType) && RELATION_EXTENSION_VAPP.equals(constraint.relation);
    }

    private ManagedObjectReference serverGuidToRootFolder(String serverGuid) {
        String morefString = "urn:vmomi:Folder:group-d1:" + serverGuid;
        return ManagedObjectUtil.stringToMoref((String)morefString);
    }
}

