/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.vmware.opsmgmt.client.advperfcharts.ChartSeriesOptions;
import com.vmware.opsmgmt.client.advperfcharts.ChartSeriesOptionsAdapter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.data.QueryStatsError;
import com.vmware.opsmgmt.client.advperfcharts.topn.ChartSeriesTopNResult;
import com.vmware.opsmgmt.client.advperfcharts.topn.CounterId;
import com.vmware.opsmgmt.client.advperfcharts.topn.ReportDescriptor;
import com.vmware.opsmgmt.client.advperfcharts.topn.TimeRange;
import com.vmware.opsmgmt.client.advperfcharts.topn.TopNQuery;
import com.vmware.vapi.std.errors.InternalServerError;
import com.vmware.vcenter.stats.topn.TopResult;
import com.vmware.vcenter.stats.topn.TopRow;
import com.vmware.vcenter.stats.topn.datastore.ByDatacenter;
import com.vmware.vcenter.stats.topn.datastore.ByStoragePod;
import com.vmware.vcenter.stats.topn.host.ByCluster;
import com.vmware.vcenter.stats.topn.resourcechild.ByResourcePool;
import com.vmware.vcenter.stats.topn.resourcechild.ByVapp;
import com.vmware.vcenter.stats.topn.vm.ByHost;
import com.vmware.vim.binding.vim.fault.RestrictedByAdministrator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.util.FormatUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerfchartsServiceTopNProvider {
    private static final Log _logger = LogFactory.getLog(PerfchartsServiceTopNProvider.class);
    private static final String verbosity = "verbose";
    private static final long TOP_TEN = 10L;
    private static final int INTERVAL_OFFSET_IN_SECONDS = 60;
    private static final List<String> HOSTS_IN_CLUSTER_REPORTS = ImmutableList.of((Object)"clusterStackedCpuReport", (Object)"clusterStackedMemReport", (Object)"clusterStackedDiskReport", (Object)"clusterStackedNetReport");
    private static final List<String> VMS_IN_HOST_REPORTS = ImmutableList.of((Object)"hostCpuUsageHostedReport", (Object)"hostMemUsageHostedReport", (Object)"hostNetUsageHostedReport", (Object)"hostDiskUsageHostedReport");
    private static final List<String> DATASTORES_BY_POD_REPROTS = ImmutableList.of((Object)"storagePodDiskProvisionedReport", (Object)"storagePodDiskCapacityReport", (Object)"storagePodDiskUsageReport");
    private static final List<String> RPS_IN_RP_REPORTS = ImmutableList.of((Object)"resourcePoolCpuUsagemhzHostedReport", (Object)"resourcePoolMemUsageHostedReport");
    private static final List<String> RPS_IN_VAPP_REPORTS = ImmutableList.of((Object)"vAppCpuUsagemhzHostedReport", (Object)"vAppMemUsageHostedReport");
    private static final List<String> RPS_IN_CLUSTER_REPORTS = ImmutableList.of((Object)"clusterRpVmStackedCpuReport", (Object)"clusterRpVmStackedMemReport");
    private static final String DATASTORES_BY_DATACENTER_REPROT = "datacenterDiskIOReport";
    private static final ImmutableMap<PerformanceMetricTimeIntervals, Long> SAMPLING_INTERVALS = ImmutableMap.builder().put((Object)PerformanceMetricTimeIntervals.REALTIME, (Object)20L).put((Object)PerformanceMetricTimeIntervals.LAST_DAY, (Object)300L).put((Object)PerformanceMetricTimeIntervals.LAST_WEEK, (Object)1800L).put((Object)PerformanceMetricTimeIntervals.LAST_MONTH, (Object)7200L).put((Object)PerformanceMetricTimeIntervals.LAST_YEAR, (Object)86400L).put((Object)PerformanceMetricTimeIntervals.CUSTOM, (Object)300L).build();
    private static final ImmutableMap<PerformanceMetricTimeIntervals, Integer> INTERVAL_DURATION = ImmutableMap.of((Object)((Object)PerformanceMetricTimeIntervals.REALTIME), (Object)10, (Object)((Object)PerformanceMetricTimeIntervals.LAST_DAY), (Object)5, (Object)((Object)PerformanceMetricTimeIntervals.LAST_WEEK), (Object)3, (Object)((Object)PerformanceMetricTimeIntervals.LAST_MONTH), (Object)2, (Object)((Object)PerformanceMetricTimeIntervals.LAST_YEAR), (Object)1);
    private final ByCluster _topHostsByCluster;
    private final com.vmware.vcenter.stats.topn.resourcechild.ByCluster _topRpsByCluster;
    private final ByResourcePool _topRpsByRp;
    private final ByVapp _topRpsByVApp;
    private final ByHost _topVmsByHost;
    private final ByDatacenter _topDatastoresByDatacenter;
    private final ByStoragePod _topDatastoresByPod;
    private final Map<String, ReportDescriptor> _reportDescriptors;
    private final ChartSeriesOptionsAdapter _chartSeriesOptionsAdapter;

    PerfchartsServiceTopNProvider(Map<String, ReportDescriptor> reportDescriptors, ChartSeriesOptionsAdapter chartSeriesOptionsAdapter, ByCluster topHostsByCluster, com.vmware.vcenter.stats.topn.resourcechild.ByCluster topRpsByCluster, ByResourcePool topRpsByRp, ByVapp topRpsByVApp, ByHost topVmsByHost, ByDatacenter topDatastoresByDatacenter, ByStoragePod topDatastoresByPod) {
        this._reportDescriptors = reportDescriptors;
        this._topHostsByCluster = topHostsByCluster;
        this._chartSeriesOptionsAdapter = chartSeriesOptionsAdapter;
        this._topRpsByCluster = topRpsByCluster;
        this._topRpsByRp = topRpsByRp;
        this._topRpsByVApp = topRpsByVApp;
        this._topVmsByHost = topVmsByHost;
        this._topDatastoresByDatacenter = topDatastoresByDatacenter;
        this._topDatastoresByPod = topDatastoresByPod;
    }

    public ChartSeriesTopNResult queryReports(ManagedObjectReference objectRef, TopNQuery query) throws Exception {
        String objectId = PerfchartsServiceTopNProvider.getObjectId(objectRef);
        Calendar now = Calendar.getInstance();
        Calendar startDate = PerfchartsServiceTopNProvider.getStartDate(query.timeRange, (Calendar)now.clone());
        Calendar endDate = PerfchartsServiceTopNProvider.getEndDate(query.timeRange, (Calendar)now.clone());
        long interval = PerfchartsServiceTopNProvider.getInterval(query.timeRange.interval);
        String reportId = query.reportIds.get(0);
        String counter = this.getCounter(reportId);
        long startTimestamp = startDate.getTimeInMillis();
        long endTimestamp = endDate.getTimeInMillis();
        TopResult topResult = null;
        boolean isRestrictedByAdministrator = false;
        try {
            topResult = this.getTopResult(objectId, objectRef.getType(), reportId, startDate, endDate, interval, counter);
        }
        catch (InternalServerError error) {
            _logger.error((Object)"Error occurred while retrieving top 10 stats: ", (Throwable)error);
            if (error.getMessage().contains(RestrictedByAdministrator.class.getSimpleName())) {
                isRestrictedByAdministrator = true;
            }
            throw error;
        }
        if (topResult == null || topResult.getDataset() == null) {
            ChartSeriesTopNResult seriesTopNResult = PerfchartsServiceTopNProvider.createChartSeriesTopNResult(reportId, startTimestamp, endTimestamp);
            if (isRestrictedByAdministrator) {
                seriesTopNResult.errorCode = QueryStatsError.RESTRICTED_BY_ADMINISTRATOR;
            }
            return seriesTopNResult;
        }
        String unit = this.getUnit(reportId);
        List rows = topResult.getDataset();
        ChartSeriesTopNResult seriesTopNResult = PerfchartsServiceTopNProvider.createChartSeriesTopNResult(reportId, startTimestamp, endTimestamp);
        for (TopRow row : rows) {
            seriesTopNResult.series.add(this._chartSeriesOptionsAdapter.createSeriesOptions(unit, row));
        }
        return seriesTopNResult;
    }

    private TopResult getTopResult(String objectId, String objectType, String reportId, Calendar startDate, Calendar endDate, long interval, String counter) {
        TopResult topResult = null;
        if (HOSTS_IN_CLUSTER_REPORTS.contains(reportId)) {
            topResult = this._topHostsByCluster.get(counter, 10L, objectId, interval, startDate, endDate, verbosity);
        } else if (RPS_IN_CLUSTER_REPORTS.contains(reportId)) {
            topResult = this._topRpsByCluster.get(counter, 10L, objectId, interval, startDate, endDate, verbosity);
        } else if (RPS_IN_RP_REPORTS.contains(reportId)) {
            topResult = this._topRpsByRp.get(counter, 10L, objectId, interval, startDate, endDate, verbosity);
        } else if (RPS_IN_VAPP_REPORTS.contains(reportId)) {
            topResult = this._topRpsByVApp.get(counter, 10L, objectId, interval, startDate, endDate, verbosity);
        } else if (VMS_IN_HOST_REPORTS.contains(reportId)) {
            topResult = this._topVmsByHost.get(counter, 10L, objectId, interval, startDate, endDate, verbosity);
        } else if (DATASTORES_BY_DATACENTER_REPROT.equals(reportId)) {
            topResult = this._topDatastoresByDatacenter.get(counter, 10L, objectId, interval, startDate, endDate, verbosity);
        } else if (DATASTORES_BY_POD_REPROTS.contains(reportId)) {
            topResult = this._topDatastoresByPod.get(counter, 10L, objectId, interval, startDate, endDate, verbosity);
        }
        return topResult;
    }

    private static ChartSeriesTopNResult createChartSeriesTopNResult(String reportId, long startTimestamp, long endTimestamp) {
        ChartSeriesTopNResult seriesTopNResult = new ChartSeriesTopNResult();
        seriesTopNResult.reportId = reportId;
        seriesTopNResult.series = new ArrayList<ChartSeriesOptions>();
        seriesTopNResult.intervalStartTimestamp = startTimestamp;
        seriesTopNResult.intervalEndTimestamp = endTimestamp;
        return seriesTopNResult;
    }

    private String getUnit(String reportId) {
        String unit;
        String counter;
        if (!this._reportDescriptors.containsKey(reportId)) {
            throw new IllegalArgumentException("Unsupported reportId: " + reportId);
        }
        ReportDescriptor reportDescriptor = this._reportDescriptors.get(reportId);
        CounterId counterId = reportDescriptor.getCounterIds().get(0);
        switch (counter = counterId.getGroupKey() + "." + counterId.getNameKey() + "." + counterId.getRollupType()) {
            case "cpu.usage.average": {
                unit = FormatUtil.getFrequencyUnit((long)FormatUtil.MHz);
                break;
            }
            case "mem.usage.average": {
                unit = FormatUtil.getStorageUnit((long)0x100000L);
                break;
            }
            case "space.usage.average": 
            case "space.allocated.average": 
            case "space.capacity.average": {
                unit = FormatUtil.getStorageUnit((long)0x40000000L);
                break;
            }
            case "disk.usage.average": {
                unit = FormatUtil.getByteRateUnit((long)FormatUtil.KBYTESPS);
                break;
            }
            case "net.usage.average": {
                unit = FormatUtil.getBitRateUnit((long)FormatUtil.MBPS);
                break;
            }
            case "cpu.usage.percent": 
            case "mem.usage.percent": {
                unit = "%";
                break;
            }
            default: {
                unit = "";
                _logger.error((Object)("Unsupported counter: " + counter));
            }
        }
        return unit;
    }

    private String getCounter(String reportId) {
        if (!this._reportDescriptors.containsKey(reportId)) {
            throw new IllegalArgumentException("Unsupported reportId: " + reportId);
        }
        ReportDescriptor reportDescriptor = this._reportDescriptors.get(reportId);
        CounterId counterId = reportDescriptor.getCounterIds().get(0);
        return counterId.getGroupKey() + "." + counterId.getNameKey();
    }

    private static long getInterval(PerformanceMetricTimeIntervals interval) {
        if (!SAMPLING_INTERVALS.containsKey((Object)interval)) {
            throw new InvalidArgument("Unsupported interval: " + (Object)((Object)interval));
        }
        long intervalInSeconds = (Long)SAMPLING_INTERVALS.get((Object)interval);
        return intervalInSeconds;
    }

    private static String getObjectId(ManagedObjectReference object) {
        return CisIdConverter.toGlobalCisId((ManagedObjectReference)object, (String)object.getServerGuid());
    }

    private static Calendar getEndDate(TimeRange timeRange, Calendar now) {
        Calendar endDate = now;
        switch (timeRange.interval) {
            case REALTIME: 
            case LAST_DAY: 
            case LAST_WEEK: 
            case LAST_MONTH: 
            case LAST_YEAR: {
                endDate = now;
                break;
            }
            case CUSTOM: {
                endDate.setTime(timeRange.endDate);
                break;
            }
            default: {
                throw new InvalidArgument("Unsupported interval: " + (Object)((Object)timeRange.interval));
            }
        }
        return endDate;
    }

    private static Calendar getStartDate(TimeRange timeRange, Calendar endDate) {
        Calendar startDate = endDate;
        PerformanceMetricTimeIntervals interval = timeRange.interval;
        if (INTERVAL_DURATION.containsKey((Object)interval)) {
            startDate.add((Integer)INTERVAL_DURATION.get((Object)interval), -1);
        } else if (PerformanceMetricTimeIntervals.CUSTOM.equals((Object)interval)) {
            startDate.setTime(timeRange.startDate);
        } else {
            throw new InvalidArgument(String.format("Unsupported interval: %s", new Object[]{interval}));
        }
        startDate.add(13, 60);
        return startDate;
    }
}

