/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.SubEntityNameInstanceNameTranslator;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatacenterClustersMetricIdProvider
implements MetricIdProvider {
    private final QueryService _queryService;

    public DatacenterClustersMetricIdProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    @Override
    public MetricIdData getMetricIdData(ManagedObjectReference object, List<PerformanceCounter> queriedCounters) {
        Map<ManagedObjectReference, String> objectNames = this.getSubEntities(object, "dc", ClusterComputeResource.class);
        MetricIdData result = new MetricIdData();
        result.queriedMetricIds = this.getQueriedMetrics(objectNames, queriedCounters);
        result.nameTranslator = new SubEntityNameInstanceNameTranslator(objectNames);
        return result;
    }

    private Map<ManagedObjectReference, String> getSubEntities(ManagedObjectReference parent, String relation, Class<? extends ManagedEntity> resourceModel) {
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", "name"}).from(new String[]{resourceModel.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate(relation, PropertyPredicate.ComparisonOperator.EQUAL, (Object)parent)}).fetch();
        HashMap<ManagedObjectReference, String> subEntityNames = new HashMap<ManagedObjectReference, String>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            ManagedObjectReference provider = (ManagedObjectReference)resourceItem.get("@modelKey");
            String name = (String)resourceItem.get("name");
            subEntityNames.put(provider, name);
        }
        return subEntityNames;
    }

    private Map<ManagedObjectReference, List<PerformanceManager.MetricId>> getQueriedMetrics(Map<ManagedObjectReference, String> subEntities, List<PerformanceCounter> allCounters) {
        HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>> queriedMetricIdsByObject = new HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>>(subEntities.size());
        for (ManagedObjectReference subEntity : subEntities.keySet()) {
            ArrayList<PerformanceManager.MetricId> queriedMetrics = new ArrayList<PerformanceManager.MetricId>(allCounters.size());
            for (PerformanceCounter counter : allCounters) {
                PerformanceManager.MetricId metricId = new PerformanceManager.MetricId();
                metricId.counterId = counter.id;
                metricId.instance = "";
                queriedMetrics.add(metricId);
            }
            queriedMetricIdsByObject.put(subEntity, queriedMetrics);
        }
        return queriedMetricIdsByObject;
    }
}

