/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.data.VmFtData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.VmFtInstanceNameTranslator;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VmFtMetricIdProvider
implements MetricIdProvider {
    public static final List<String> VM_FT_REPORTS = Arrays.asList("vmCpuUsedPercentReport", "vmCpuSystemPercentReport", "vmCpuUsageMegahertzReport", "vmMemActiveMbReport", "vmMemSwapOutMbReport");
    public static final String GROUP_ID_CPU = "cpu";
    public static final String NAME_KEY_USAGEMHZ = "usagemhz";
    private final QueryBindingService _queryBindingService;

    public VmFtMetricIdProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @Override
    public MetricIdData getMetricIdData(ManagedObjectReference object, List<PerformanceCounter> queriedCounters) {
        VmFtData vmData = (VmFtData)this._queryBindingService.prepare(VmFtData.class).fetch((Object)object);
        MetricIdData result = new MetricIdData();
        result.queriedMetricIds = this.getQueriedMetrics(object, vmData.secondaries, queriedCounters, vmData.numCpu);
        result.nameTranslator = new VmFtInstanceNameTranslator(object, queriedCounters);
        return result;
    }

    private Map<ManagedObjectReference, List<PerformanceManager.MetricId>> getQueriedMetrics(ManagedObjectReference primary, ManagedObjectReference[] secondaries, List<PerformanceCounter> allCounters, int numCpu) {
        if (secondaries == null) {
            return Collections.emptyMap();
        }
        ArrayList<PerformanceManager.MetricId> queriedMetrics = new ArrayList<PerformanceManager.MetricId>();
        for (PerformanceCounter counter : allCounters) {
            List<String> instances = Collections.singletonList("");
            if (GROUP_ID_CPU.equals(counter.groupId) && !NAME_KEY_USAGEMHZ.equals(counter.nameKey)) {
                instances = new ArrayList<String>();
                for (int i = 0; i < numCpu; ++i) {
                    instances.add("" + i);
                }
            }
            for (String instance : instances) {
                PerformanceManager.MetricId metricId = new PerformanceManager.MetricId();
                metricId.counterId = counter.id;
                metricId.instance = instance;
                queriedMetrics.add(metricId);
            }
        }
        HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>> result = new HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>>(secondaries.length + 1);
        result.put(primary, queriedMetrics);
        for (ManagedObjectReference object : secondaries) {
            result.put(object, queriedMetrics);
        }
        return result;
    }
}

