/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.util.BasePerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCache;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterProvider;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterUtil;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositePerformanceStats
extends BasePerformanceStats {
    private static final Log _logger = LogFactory.getLog(CompositePerformanceStats.class);
    private final QueryService _queryService;
    private final PerformanceCounterCache _perfCounterCache;

    public CompositePerformanceStats(ManagedObjectReference moRef, QueryService queryService, PerformanceManager performanceManager, PerformanceInfoQuerySpec params, PerformanceCounterProvider counterProvider, PerformanceCounterCache perfCounterCache) {
        super(Collections.singletonList(moRef), params, performanceManager, null, counterProvider);
        this._queryService = queryService;
        this._perfCounterCache = perfCounterCache;
    }

    @Override
    protected Map<ManagedObjectReference, PerformanceManager.QuerySpec> prepareQuerySpec() {
        PerformanceManager.MetricId metricId = new PerformanceManager.MetricId();
        metricId.instance = "";
        if (this.hasCoutnerIdsItems()) {
            metricId.counterId = this.originalParams.counterIds.get(0);
        }
        ManagedObjectReference moRef = (ManagedObjectReference)this.moRefs.get(0);
        PerformanceManager.QuerySpec querySpec = this.initBaseQuerySpec(moRef);
        querySpec.metricId = new PerformanceManager.MetricId[]{metricId};
        return Collections.singletonMap(moRef, querySpec);
    }

    @Override
    protected List<PerformanceCounterStats> executeQuery(Map<ManagedObjectReference, PerformanceManager.QuerySpec> querySpecs) {
        PerformanceManager.QuerySpec querySpec = querySpecs.get(this.moRefs.get(0));
        if (querySpec.metricId.length == 0) {
            return Collections.emptyList();
        }
        _logger.debug((Object)("Calling PerformanceManager.queryCompositeStats(" + querySpec + ")"));
        PerformanceManager.CompositeEntityMetric compositeMetric = this.perfManager.queryCompositeStats(querySpec);
        ArrayList<PerformanceCounterStats> result = new ArrayList<PerformanceCounterStats>();
        if (this.isHostStatsRequested()) {
            result.addAll(this.retrieveHostStats(compositeMetric));
        }
        result.addAll(this.retrieveRequestedVMStats(compositeMetric));
        return result;
    }

    private List<PerformanceCounterStats> retrieveHostStats(PerformanceManager.CompositeEntityMetric compositeMetric) {
        ArrayList<PerformanceCounterStats> result = new ArrayList<PerformanceCounterStats>();
        PerformanceManager.EntityMetricBase entityMetricBase = compositeMetric.entity;
        PerformanceManager.EntityMetricCSV entityMetric = (PerformanceManager.EntityMetricCSV)entityMetricBase;
        if (entityMetric != null && entityMetric.getValue() != null) {
            PerformanceManager.MetricSeriesCSV[] metricSeriesArray = entityMetric.getValue();
            Date[] samples = CompositePerformanceStats.extractSamples(entityMetricBase);
            this.addValuesToResult((PerformanceManager.MetricSeries[])metricSeriesArray, entityMetric.entity, samples, result);
        }
        return result;
    }

    private List<PerformanceCounterStats> retrieveRequestedVMStats(PerformanceManager.CompositeEntityMetric compositeMetric) {
        PerformanceManager.EntityMetricBase[] vmEntityMetricBaseArr = compositeMetric.childEntity;
        if (vmEntityMetricBaseArr == null) {
            return Collections.emptyList();
        }
        ArrayList<ManagedObjectReference> vms = new ArrayList<ManagedObjectReference>(vmEntityMetricBaseArr.length);
        for (PerformanceManager.EntityMetricBase emb : vmEntityMetricBaseArr) {
            vms.add(emb.entity);
        }
        ResultSet vmNames = this._queryService.select(new String[]{"@modelKey", "name"}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vms).opId("retrieve-composite-stats-vm-names").fetch();
        HashMap<ManagedObjectReference, String> vmNameMap = new HashMap<ManagedObjectReference, String>();
        for (ResourceItem ri : vmNames.getItems()) {
            ManagedObjectReference key = (ManagedObjectReference)ri.getKey();
            String name = (String)ri.get("name");
            vmNameMap.put(key, name);
        }
        ArrayList<PerformanceCounterStats> result = new ArrayList<PerformanceCounterStats>();
        for (PerformanceManager.EntityMetricBase entityMetricBase : vmEntityMetricBaseArr) {
            PerformanceManager.EntityMetricCSV entityMetric = (PerformanceManager.EntityMetricCSV)entityMetricBase;
            if (entityMetric.value == null) continue;
            String vmName = (String)vmNameMap.get(entityMetric.entity);
            if (!this.isVmRequested(entityMetric.entity)) continue;
            Date[] samples = CompositePerformanceStats.extractSamples(entityMetricBase);
            for (PerformanceManager.MetricSeriesCSV metricSeries : entityMetric.getValue()) {
                int counterId = metricSeries.getId().counterId;
                PerformanceManager.CounterInfo counterInfo = this._perfCounterCache.getCounterById(this.perfManager, counterId);
                PerformanceCounter performanceCounter = PerformanceCounterUtil.createCounter(counterInfo, vmName);
                PerformanceCounterStats stats = new PerformanceCounterStats();
                stats.entity = entityMetricBase.entity;
                stats.performanceCounter = performanceCounter;
                stats.statistics = this.createPerfMetricStatsValues(samples, CompositePerformanceStats.extractValues((PerformanceManager.MetricSeries)metricSeries), stats.performanceCounter.statsUnitKey, stats.performanceCounter.isUptime);
                result.add(stats);
            }
        }
        return result;
    }

    private boolean isVmRequested(ManagedObjectReference vmMor) {
        List<String> reqVmNames = this.originalParams.relatedDeviceIds;
        String moString = ManagedObjectUtil.morefToString((ManagedObjectReference)vmMor);
        return reqVmNames.contains("*") || reqVmNames.contains(moString);
    }

    private boolean isHostStatsRequested() {
        List<String> reqVmNames = this.originalParams.relatedDeviceIds;
        return reqVmNames.contains("*") || reqVmNames.contains("");
    }
}

