/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCounterCache {
    private static final Log _logger = LogFactory.getLog(PerformanceCounterCache.class);
    private static final String CACHE_COUNTERS_SETTING = "cachePerformanceCounters";
    private final ConcurrentMap<String, ConcurrentMap<Integer, PerformanceManager.CounterInfo>> _cache;
    private final boolean _useCache;

    public PerformanceCounterCache(ConfigurationService configurationService) {
        this._useCache = PropertyUtil.getBooleanProperty((ConfigurationService)configurationService, (String)CACHE_COUNTERS_SETTING, (boolean)true);
        this._cache = this._useCache ? new ConcurrentHashMap<String, ConcurrentMap<Integer, PerformanceManager.CounterInfo>>() : null;
    }

    public Map<Integer, PerformanceManager.CounterInfo> getCounterInfoMapForMetrics(PerformanceManager.MetricId[] realtimeMetrics, PerformanceManager.MetricId[] historicalMetrics, PerformanceManager perfManager) {
        HashMap<Integer, PerformanceManager.CounterInfo> result;
        if (this._useCache) {
            result = new HashMap();
            ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache = this.cacheForServer(perfManager);
            if (cache != null) {
                HashSet<Integer> missingKeys = new HashSet<Integer>();
                PerformanceCounterCache.fetchCountersForMetricIds(realtimeMetrics, cache, result, missingKeys);
                PerformanceCounterCache.fetchCountersForMetricIds(historicalMetrics, cache, result, missingKeys);
                PerformanceCounterCache.fillMissingCounterInfos(perfManager, missingKeys, cache, result);
            }
        } else {
            result = this.fetchCounterInfos(realtimeMetrics, historicalMetrics, perfManager);
        }
        return result;
    }

    public PerformanceManager.CounterInfo getCounterById(PerformanceManager perfManager, int id) {
        PerformanceManager.CounterInfo result;
        if (this._useCache) {
            ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache = this.cacheForServer(perfManager);
            if (cache != null) {
                result = (PerformanceManager.CounterInfo)cache.get(id);
                if (result == null) {
                    HashMap<Integer, PerformanceManager.CounterInfo> resultMap = new HashMap<Integer, PerformanceManager.CounterInfo>(1);
                    PerformanceCounterCache.fillMissingCounterInfos(perfManager, Collections.singleton(id), cache, resultMap);
                    result = (PerformanceManager.CounterInfo)resultMap.get(id);
                }
            } else {
                result = null;
            }
        } else {
            PerformanceManager.CounterInfo[] counterInfos = perfManager.queryCounter(new int[]{id});
            if (counterInfos != null) {
                result = counterInfos[0];
            } else {
                _logger.warn((Object)("Could not find counter with id: " + id));
                result = null;
            }
        }
        return result;
    }

    public Collection<PerformanceManager.CounterInfo> getCountersForServer(PerformanceManager perfManager) {
        if (this._useCache) {
            ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache = this.cacheForServer(perfManager);
            return Collections.unmodifiableCollection(cache.values());
        }
        PerformanceManager.CounterInfo[] result = perfManager.getPerfCounter();
        return result == null ? Collections.emptyList() : Arrays.asList(result);
    }

    private ConcurrentMap<Integer, PerformanceManager.CounterInfo> cacheForServer(PerformanceManager perfManager) {
        String serverGuid = perfManager._getRef().getServerGuid();
        ConcurrentMap result = (ConcurrentMap)this._cache.get(serverGuid);
        if (result == null) {
            PerformanceManager.CounterInfo[] counterInfos = perfManager.getPerfCounter();
            if (counterInfos != null) {
                ConcurrentHashMap<Integer, PerformanceManager.CounterInfo> countersForServer = new ConcurrentHashMap<Integer, PerformanceManager.CounterInfo>(counterInfos.length);
                for (PerformanceManager.CounterInfo ci : counterInfos) {
                    countersForServer.putIfAbsent(ci.key, PerformanceCounterCache.internCounterInfo(ci));
                }
                this._cache.putIfAbsent(serverGuid, countersForServer);
                result = (ConcurrentMap)this._cache.get(serverGuid);
            } else {
                _logger.warn((Object)("PerfManager returned zero counters for server " + serverGuid));
            }
        }
        return result;
    }

    private Map<Integer, PerformanceManager.CounterInfo> fetchCounterInfos(PerformanceManager.MetricId[] realtime, PerformanceManager.MetricId[] historical, PerformanceManager perfManager) {
        assert (realtime != null && historical != null && realtime.length + historical.length > 0);
        HashMap<Integer, PerformanceManager.CounterInfo> counterInfosById = new HashMap<Integer, PerformanceManager.CounterInfo>();
        for (PerformanceManager.MetricId mid : realtime) {
            counterInfosById.put(mid.counterId, null);
        }
        for (PerformanceManager.MetricId mid : historical) {
            counterInfosById.put(mid.counterId, null);
        }
        int[] counterIds = new int[counterInfosById.size()];
        int i = 0;
        for (Integer counterIdBoxed : counterInfosById.keySet()) {
            counterIds[i++] = counterIdBoxed;
        }
        PerformanceManager.CounterInfo[] counterInfos = perfManager.queryCounter(counterIds);
        if (counterInfos.length != counterIds.length) {
            _logger.warn((Object)String.format("Requested information for %d counters, but received %d results.", counterIds.length, counterInfos.length));
        }
        for (PerformanceManager.CounterInfo ci : counterInfos) {
            counterInfosById.put(ci.key, ci);
        }
        return counterInfosById;
    }

    private static void fetchCountersForMetricIds(PerformanceManager.MetricId[] metricIds, ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache, Map<Integer, PerformanceManager.CounterInfo> result, Set<Integer> missing) {
        if (metricIds == null) {
            return;
        }
        for (PerformanceManager.MetricId mid : metricIds) {
            int counterId = mid.counterId;
            if (result.containsKey(counterId)) continue;
            PerformanceManager.CounterInfo info = (PerformanceManager.CounterInfo)cache.get(counterId);
            if (info != null) {
                result.put(info.key, info);
                continue;
            }
            missing.add(counterId);
        }
    }

    private static void fillMissingCounterInfos(PerformanceManager perfManager, Set<Integer> missing, ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache, Map<Integer, PerformanceManager.CounterInfo> result) {
        if (!missing.isEmpty()) {
            int[] missingKeysArr = new int[missing.size()];
            int i = 0;
            for (Integer k : missing) {
                missingKeysArr[i++] = k;
            }
            PerformanceManager.CounterInfo[] missingInfos = perfManager.queryCounter(missingKeysArr);
            if (missingInfos == null || missingInfos.length != missingKeysArr.length) {
                _logger.warn((Object)"Could not get all missing counter IDs!");
                return;
            }
            for (PerformanceManager.CounterInfo ci : missingInfos) {
                PerformanceManager.CounterInfo internedCounter = PerformanceCounterCache.internCounterInfo(ci);
                cache.put(ci.key, internedCounter);
                result.put(ci.key, internedCounter);
            }
        }
    }

    private static PerformanceManager.CounterInfo internCounterInfo(PerformanceManager.CounterInfo original) {
        original.nameInfo = PerformanceCounterCache.internElementStrings(original.nameInfo);
        original.unitInfo = PerformanceCounterCache.internElementStrings(original.unitInfo);
        original.groupInfo = PerformanceCounterCache.internElementStrings(original.groupInfo);
        return original;
    }

    private static ElementDescription internElementStrings(ElementDescription e) {
        if (e != null) {
            e.label = e.label == null ? null : e.label.intern();
            e.key = e.key == null ? null : e.key.intern();
            e.summary = e.summary == null ? null : e.summary.intern();
        }
        return e;
    }
}

