/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.util.BasePerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterProvider;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceStats;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PerformanceStatsCollector {
    private final BasePerformanceStats _stats;
    private final PerformanceInfoQuerySpec _params;

    public PerformanceStatsCollector(ManagedObjectReference moRef, PerformanceManager performanceManager, PerformanceInfoQuerySpec params, PerformanceCounterProvider counterProvider) {
        this._params = params;
        this._stats = new PerformanceStats(Collections.singletonList(moRef), params, performanceManager, null, counterProvider);
    }

    public List<PerformanceCounterStats> getStats() {
        return this.filterStats(this._stats.getStats(), this._params.relatedDeviceIds);
    }

    private List<PerformanceCounterStats> filterStats(List<PerformanceCounterStats> statsList, List<String> devices) {
        ArrayList<PerformanceCounterStats> result = new ArrayList<PerformanceCounterStats>(statsList.size());
        for (PerformanceCounterStats stats : statsList) {
            if (devices == null || !devices.contains(stats.performanceCounter.relatedDeviceId) && !devices.contains("*")) continue;
            result.add(stats);
        }
        return result;
    }
}

