/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.CustomDateTimeUnits;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.PerformanceManager;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;

public class PerformanceTimeIntervalRetriever {
    private static final int LAST_DAY_INDEX = 0;
    private static final int LAST_WEEK_INDEX = 1;
    private static final int LAST_MONTH_INDEX = 2;
    private static final int LAST_YEAR_INDEX = 3;
    private static final EnumMap<CustomDateTimeUnits, Integer> CUSTOM_DATE_TO_CALENDAR = new EnumMap(CustomDateTimeUnits.class);
    private HistoricalInterval[] _historicalIntervals;
    private Date _startDate;
    private Date _endDate;
    private int _sampleInterval;
    private boolean _available;

    PerformanceTimeIntervalRetriever(HistoricalInterval[] historicalIntervals, PerformanceInfoQuerySpec params, PerformanceManager.ProviderSummary summary) {
        this._historicalIntervals = historicalIntervals;
        this._available = summary.summarySupported;
        if (this._available) {
            switch (params.interval) {
                case HISTORICAL_STATS: {
                    throw new IllegalStateException();
                }
                case LAST_DAY: {
                    this.retrieveData(0);
                    break;
                }
                case LAST_WEEK: {
                    this.retrieveData(1);
                    break;
                }
                case LAST_MONTH: {
                    this.retrieveData(2);
                    break;
                }
                case LAST_YEAR: {
                    this.retrieveData(3);
                    break;
                }
                case RAW_DATA_FEED: {
                    HistoricalInterval chosenInterval = this._historicalIntervals[0];
                    this._sampleInterval = chosenInterval.samplingPeriod;
                    this._startDate = null;
                    this._endDate = null;
                    break;
                }
                case REALTIME: {
                    throw new IllegalStateException();
                }
                case CUSTOM: {
                    this._sampleInterval = -1;
                    if (params.customPeriodUnits != null && params.customPeriodUnitsCount != 0) {
                        Calendar startDate = Calendar.getInstance();
                        startDate.add(CUSTOM_DATE_TO_CALENDAR.get((Object)params.customPeriodUnits), -1 * params.customPeriodUnitsCount);
                        this._startDate = startDate.getTime();
                        this._endDate = new Date();
                        break;
                    }
                    this._startDate = params.startDate;
                    this._endDate = params.endDate;
                }
            }
        }
    }

    public Date getStartDate() {
        return this._available ? this._startDate : null;
    }

    public Date getEndDate() {
        return this._available ? this._endDate : null;
    }

    Integer getSampleInterval() {
        if (this._available) {
            return this._sampleInterval;
        }
        return -1;
    }

    private void retrieveData(int historicalIntervalIndex) {
        HistoricalInterval chosenInterval = this._historicalIntervals[historicalIntervalIndex];
        this._sampleInterval = chosenInterval.samplingPeriod;
        this._endDate = new Date();
        Calendar startDate = Calendar.getInstance();
        startDate.add(13, -1 * chosenInterval.length);
        this._startDate = startDate.getTime();
    }

    static {
        CUSTOM_DATE_TO_CALENDAR.put(CustomDateTimeUnits.HOUR, 10);
        CUSTOM_DATE_TO_CALENDAR.put(CustomDateTimeUnits.DAY, 5);
        CUSTOM_DATE_TO_CALENDAR.put(CustomDateTimeUnits.WEEK, 3);
        CUSTOM_DATE_TO_CALENDAR.put(CustomDateTimeUnits.MONTH, 2);
    }
}

