/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.CustomizationSpecInfo;
import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.fault.CustomizationFault;
import com.vmware.vim.binding.vim.fault.MissingLinuxCustResources;
import com.vmware.vim.binding.vim.fault.MissingWindowsCustResources;
import com.vmware.vim.binding.vim.fault.UncustomizableGuest;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.vm.configuration.TimeZoneConfiguration;
import com.vmware.vsphere.client.h5.vm.configuration.TimeZoneConfigurator;
import com.vmware.vsphere.client.h5.vm.data.CustomizationSpecData;
import com.vmware.vsphere.client.h5.vm.impl.CustomizationSpecsHelper;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmCustomizationSpecsPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VmCustomizationSpecsPropertyProvider.class);
    private CustomizationSpecsHelper _customizationSpecsHelper;
    private static final String PROP_GUEST_ID = "VirtualMachine/config/guestId";
    private static final String PROP_GUEST_FULL_NAME = "VirtualMachine/config/guestFullName";
    private static final String PROP_PENDING_CUSOMITZATION = "VirtualMachine/config/tools/pendingCustomization";
    private static final String WIN_OS_PREFIX = "win";
    private static final String GOS_TYPE_WINDOWS = "Windows";
    private static final String GOS_TYPE_LINUX = "Linux";

    public VmCustomizationSpecsPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._customizationSpecsHelper = new CustomizationSpecsHelper(queryServiceFactory);
    }

    @type(value="VirtualMachine")
    public CustomizationSpecData getCustomizationSpecData(ManagedObjectReference vmRef, String guestId) throws Exception {
        assert (vmRef != null);
        VcService service = VimSessionUtil.getService((String)vmRef.getServerGuid());
        CustomizationSpecManager manager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().customizationSpecManager);
        return this.retrieveCustomizationSpecData(manager, guestId);
    }

    @type(value="CustomizationSpecManager")
    public CustomizationSpecData getCustomizationSpecListData(ManagedObjectReference cusManagerRef, String guestId) throws Exception {
        assert (cusManagerRef != null);
        CustomizationSpecManager cusManager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cusManagerRef);
        return this.retrieveCustomizationSpecData(cusManager, guestId);
    }

    @type(value="CustomizationSpecManager")
    public TimeZoneConfiguration getTimeZones(ManagedObjectReference dummyRef) throws JAXBException {
        return new TimeZoneConfigurator().parseConfig();
    }

    private CustomizationSpecData retrieveCustomizationSpecData(CustomizationSpecManager manager, String guestId) throws CustomizationFault {
        CustomizationSpecData result = new CustomizationSpecData();
        result.compatibility = CustomizationSpecData.CustomizationCompatibility.CUSTOMIZATION_RESOURCES_VALID;
        try {
            manager.checkResources(guestId);
            result.customizationSpecs = manager.getInfo();
        }
        catch (MissingWindowsCustResources e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            result.compatibility = CustomizationSpecData.CustomizationCompatibility.MISSING_WINDOWS_CUSTOMIZATION;
        }
        catch (MissingLinuxCustResources e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            result.compatibility = CustomizationSpecData.CustomizationCompatibility.MISSING_LINUX_CUSTOMIZATION;
        }
        catch (UncustomizableGuest e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            result.compatibility = CustomizationSpecData.CustomizationCompatibility.UNCUSTOMIZABLE_GUEST;
        }
        return result;
    }

    private CustomizationSpecInfo[] filterSpecs(CustomizationSpecInfo[] specs, String typeToFilterBy) {
        ArrayList<CustomizationSpecInfo> list = new ArrayList<CustomizationSpecInfo>();
        for (CustomizationSpecInfo spec : specs) {
            if (!typeToFilterBy.equals(spec.type)) continue;
            list.add(spec);
        }
        return list.toArray(new CustomizationSpecInfo[0]);
    }
}

