/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorItemsData;
import com.vmware.vsphere.client.h5.vm.service.provisioning.VmProvisioningStorageLocatorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmStorageLocatorDerivedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VmStorageLocatorDerivedPropertyProviderAdapter.class);
    private static final String PROPERTY_DATASTORE = "datastore";
    private static final String PROPERTY_OWNER = "owner";
    private static final String PROPERTY_LOCATOR_ITEMS = "storageLocator:provisioningStorageLocatorItemsData";
    private static Map<String, DerivedPropertyInfo[]> TYPE_MAP = new HashMap<String, DerivedPropertyInfo[]>();
    private final DataServiceExtensionRegistry _dataServiceExtensionRegistry;
    private final VmProvisioningStorageLocatorService _vmStorageLocatorService;

    public VmStorageLocatorDerivedPropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, VmProvisioningStorageLocatorService vmStorageLocatorService) {
        this._dataServiceExtensionRegistry = dataServiceExtensionRegistry;
        this._vmStorageLocatorService = vmStorageLocatorService;
    }

    public void initialize() {
        this._dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, VmStorageLocatorDerivedPropertyProviderAdapter.getTypeInfo());
    }

    public void destroy() {
        this._dataServiceExtensionRegistry.unregisterDataAdapter((PropertyProviderAdapter)this);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        if (!VmStorageLocatorDerivedPropertyProviderAdapter.checkPropertyRequestSpec(propertyRequest)) {
            return ResultUtil.newEmptyResultSet();
        }
        ResultSet rs = new ResultSet();
        ArrayList<ResultItem> itemList = new ArrayList<ResultItem>();
        for (Object obj : propertyRequest.objects) {
            ResultItem item = VmStorageLocatorDerivedPropertyProviderAdapter.newResultItem(obj);
            itemList.add(item);
            for (PropertySpec pSpec : propertyRequest.properties) {
                if (!this.shouldComputeProperty(PROPERTY_LOCATOR_ITEMS, obj, pSpec)) continue;
                StorageLocatorItemsData propertyValue = this.computeProvisioningStorageLocatorItemsData((ManagedObjectReference)obj, propertyRequest.derivedPropertyData);
                ResultUtil.addProperty((ResultItem)item, (PropertyValue)ResultUtil.newProperty((String)PROPERTY_LOCATOR_ITEMS, (Object)propertyValue));
            }
        }
        rs.items = (ResultItem[])ArrayUtil.toArray(itemList, ResultItem.class);
        rs.totalMatchedObjectCount = itemList.size();
        return rs;
    }

    private StorageLocatorItemsData computeProvisioningStorageLocatorItemsData(ManagedObjectReference objRef, DerivedPropertyData derivedData) {
        if (objRef == null || derivedData == null) {
            return null;
        }
        Map derivedProperties = derivedData.getSourcePropertyValuesByObject();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualApp.class)) {
            ManagedObjectReference computeResource = (ManagedObjectReference)VmStorageLocatorDerivedPropertyProviderAdapter.getDerivedPropertyValue(objRef, PROPERTY_OWNER, derivedProperties);
            return this._vmStorageLocatorService.getStorageLocatorData(computeResource, null);
        }
        Object[] datastores = (Object[])VmStorageLocatorDerivedPropertyProviderAdapter.getDerivedPropertyValue(objRef, PROPERTY_DATASTORE, derivedProperties);
        return this._vmStorageLocatorService.getStorageLocatorData(objRef, datastores);
    }

    private boolean shouldComputeProperty(String propertyName, Object obj, PropertySpec propSpec) {
        if (!(obj instanceof ManagedObjectReference)) {
            return false;
        }
        ManagedObjectReference ref = (ManagedObjectReference)obj;
        if (!TYPE_MAP.containsKey(ref.getType())) {
            return false;
        }
        return ArrayUtil.contains((Object)propertyName, (Object[])propSpec.propertyNames) != false;
    }

    private static <T> T getDerivedPropertyValue(Object obj, String propertyName, Map<Object, Map<String, Object>> derivedProperties) {
        Map<String, Object> objectProperties = derivedProperties.get(obj);
        if (objectProperties == null || !objectProperties.containsKey(propertyName)) {
            throw new RuntimeException(String.format("Derived data for %s does not contain property %s", obj.toString(), propertyName));
        }
        Object result = objectProperties.get(propertyName);
        return (T)result;
    }

    private static boolean checkPropertyRequestSpec(PropertyRequestSpec spec) {
        if (ArrayUtil.isNullOrEmpty((Object[])spec.objects) || ArrayUtil.isNullOrEmpty((Object[])spec.properties) || spec.derivedPropertyData == null) {
            _logger.error((Object)"Invalid property request spec send by data service.");
            return false;
        }
        return true;
    }

    private static TypeInfo[] getTypeInfo() {
        TypeInfo[] typeInfo = new TypeInfo[TYPE_MAP.size()];
        int index = 0;
        for (Map.Entry<String, DerivedPropertyInfo[]> entry : TYPE_MAP.entrySet()) {
            typeInfo[index++] = VmStorageLocatorDerivedPropertyProviderAdapter.newTypeInfo(entry.getKey(), entry.getValue());
        }
        return typeInfo;
    }

    private static ResultItem newResultItem(Object obj) {
        ResultItem item = new ResultItem();
        item.resourceObject = obj;
        item.properties = new PropertyValue[0];
        return item;
    }

    private static TypeInfo newTypeInfo(String objectType, DerivedPropertyInfo[] derivedProperties) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = objectType;
        typeInfo.derivedProperties = derivedProperties;
        typeInfo.properties = new String[derivedProperties.length];
        for (int index = 0; index < derivedProperties.length; ++index) {
            typeInfo.properties[index] = derivedProperties[index].propertyName;
        }
        return typeInfo;
    }

    private static DerivedPropertyInfo newDerivedPropertyInfo(String computedProperty, String[] sourceProperties) {
        DerivedPropertyInfo derivedInfo = new DerivedPropertyInfo();
        derivedInfo.propertyName = computedProperty;
        derivedInfo.sourcePropertyNames = sourceProperties;
        return derivedInfo;
    }

    static {
        TYPE_MAP.put(HostSystem.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_DATASTORE})});
        TYPE_MAP.put(ComputeResource.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_DATASTORE})});
        TYPE_MAP.put(ClusterComputeResource.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_DATASTORE})});
        TYPE_MAP.put(ResourcePool.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_OWNER})});
        TYPE_MAP.put(VirtualApp.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_OWNER})});
    }
}

