/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vsphere.client.common.model.PropertyValueData;

@QueryBinding(value="Folder")
public class VmDashboardData
extends IdentifiableQueryBinding {
    @Relationship(value={"Folder/allNormalVMOrPrimaryFTVM"})
    @Property(value="VirtualMachine/runtime/powerState")
    private VirtualMachine.PowerState[] vmsPowerState;

    public PropertyValueData[] getDashboardData() {
        int vmCount = 0;
        int vmPoweredOnCount = 0;
        int vmPoweredOffCount = 0;
        int vmSuspendedCount = 0;
        if (this.vmsPowerState != null) {
            vmCount = this.vmsPowerState.length;
            for (int i = 0; i < this.vmsPowerState.length; ++i) {
                if (this.vmsPowerState[i] == VirtualMachine.PowerState.poweredOn) {
                    ++vmPoweredOnCount;
                    continue;
                }
                if (this.vmsPowerState[i] == VirtualMachine.PowerState.poweredOff) {
                    ++vmPoweredOffCount;
                    continue;
                }
                ++vmSuspendedCount;
            }
        }
        return new PropertyValueData[]{PropertyValueData.newInstance((String)"vmCount", (String)Integer.toString(vmCount)), PropertyValueData.newInstance((String)"vmPoweredOnCount", (String)Integer.toString(vmPoweredOnCount)), PropertyValueData.newInstance((String)"vmPoweredOffCount", (String)Integer.toString(vmPoweredOffCount)), PropertyValueData.newInstance((String)"vmSuspendedCount", (String)Integer.toString(vmSuspendedCount))};
    }
}

