/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import com.vmware.vsphere.client.h5.perspective.model.Identifiable;
import java.util.Set;
import java.util.UUID;

public class PerspectiveBase
implements Identifiable {
    private final String id;
    private String name;
    private String description;
    private Set<String> disabledExtensionIds;

    protected PerspectiveBase(String id, String name, String description, String[] disabledExtensionIds) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.disabledExtensionIds = Sets.newHashSet((Object[])disabledExtensionIds);
    }

    private PerspectiveBase(String name, String description, String[] disabledExtensionIds) {
        this(UUID.randomUUID().toString(), name, description, disabledExtensionIds);
    }

    @JsonCreator
    public static PerspectiveBase newPerspective(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="disabledExtensionIds") String[] disabledExtensionIds) {
        if (id == null) {
            return new PerspectiveBase(name, description, disabledExtensionIds);
        }
        return new PerspectiveBase(id, name, description, disabledExtensionIds);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getDisabledExtensionIds() {
        return this.disabledExtensionIds;
    }

    public String toString() {
        return String.format("[%s] (%s, %s)", this.getClass().getSimpleName(), this.getId(), this.getName());
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (!(anotherObject instanceof PerspectiveBase)) {
            return false;
        }
        PerspectiveBase anotherPerspective = (PerspectiveBase)anotherObject;
        if (anotherPerspective.getDisabledExtensionIds() == null) {
            return false;
        }
        if (this.getDisabledExtensionIds() == null) {
            return false;
        }
        if (this.getDisabledExtensionIds().size() != anotherPerspective.getDisabledExtensionIds().size()) {
            return false;
        }
        return Sets.difference(this.getDisabledExtensionIds(), anotherPerspective.getDisabledExtensionIds()).isEmpty();
    }
}

