/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.vmware.vsphere.client.h5.perspective.model.Group;
import com.vmware.vsphere.client.h5.perspective.model.User;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=User.class), @JsonSubTypes.Type(value=Group.class)})
public abstract class Principal {
    protected String name;
    protected String domain;

    @JsonCreator
    public Principal(@JsonProperty(value="name") String name, @JsonProperty(value="domain") String domain) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(domain);
        this.setName(name);
        this.setDomain(domain);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name.toLowerCase();
    }

    public String getDomain() {
        return this.domain;
    }

    protected void setDomain(String domain) {
        this.domain = domain.toLowerCase();
    }

    protected String getAsUpn() {
        return String.format("%s@%s", this.name, this.domain);
    }

    public String toString() {
        return this.getAsUpn();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Principal principal = (Principal)o;
        return Objects.equals(this.name, principal.name) && Objects.equals(this.domain, principal.domain);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.domain);
    }
}

