/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.vmware.vsphere.client.h5.perspective.model.PerspectiveBase;
import java.util.Collections;
import java.util.Set;

public final class UiRestriction {
    private final Set<PerspectiveBase> perspectives;
    private Set<String> disabledExtensionIds;

    public UiRestriction(Set<PerspectiveBase> perspectives) {
        this.perspectives = perspectives;
    }

    public Set<String> getDisabledExtensionIds() {
        if (this.disabledExtensionIds == null) {
            this.disabledExtensionIds = UiRestriction.getCommonDisabledExtensionIds(this.perspectives.toArray(new PerspectiveBase[0]));
        }
        return this.disabledExtensionIds;
    }

    public Set<PerspectiveBase> getPerspectives() {
        return this.perspectives;
    }

    private static Set<String> getCommonDisabledExtensionIds(PerspectiveBase[] perspectives) {
        if (perspectives == null || perspectives.length == 0) {
            return Collections.emptySet();
        }
        ImmutableSet result = perspectives[0].getDisabledExtensionIds();
        for (int i = 1; i < perspectives.length; ++i) {
            PerspectiveBase perspective = perspectives[i];
            if (perspective == null || perspective.getDisabledExtensionIds() == null || !(result = Sets.intersection(result, perspective.getDisabledExtensionIds()).immutableCopy()).isEmpty()) continue;
            return result;
        }
        return result;
    }
}

