/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.services;

import com.vmware.vise.store.PersistenceService;
import com.vmware.vsphere.client.h5.perspective.exception.PerspectiveException;
import com.vmware.vsphere.client.h5.perspective.model.Assignment;
import com.vmware.vsphere.client.h5.perspective.model.AssignmentBase;
import com.vmware.vsphere.client.h5.perspective.model.Perspective;
import com.vmware.vsphere.client.h5.perspective.model.PerspectiveBase;
import com.vmware.vsphere.client.h5.perspective.model.UiRestriction;
import com.vmware.vsphere.client.h5.perspective.services.JsonObjectMapper;
import com.vmware.vsphere.client.h5.perspective.services.PerspectiveService;
import com.vmware.vsphere.client.h5.perspective.services.PrincipalManagementService;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerspectiveServiceImpl
implements PerspectiveService {
    private static final Log logger = LogFactory.getLog(PerspectiveServiceImpl.class);
    private static final String CURRENT_VERSION = "1";
    private static final String PERSPECTIVE_UI_USER = "user@perspective@viper";
    private static final Map<Class<?>, String> TYPE_TO_COLLECTION_INDEX = new HashMap();
    private final PersistenceService persistenceService;
    private final PrincipalManagementService principalManagementService;
    private final JsonObjectMapper objectMapper;

    public PerspectiveServiceImpl(PersistenceService persistenceService, PrincipalManagementService principalManagementService, JsonObjectMapper objectMapper) {
        this.persistenceService = persistenceService;
        this.principalManagementService = principalManagementService;
        this.objectMapper = objectMapper;
    }

    @Override
    public PerspectiveBase savePerspective(PerspectiveBase perspective) throws Exception {
        if (perspective == null) {
            throw new IllegalArgumentException("Cannot save Perspective: the Perspective is not valid.");
        }
        boolean isPerspectiveNameUnique = this.isPerspectiveNameUnique(perspective.getName());
        if (!isPerspectiveNameUnique) {
            throw new PerspectiveException(String.format("A perspective with name '%s' already exists.", perspective.getName()), "validation.perspective.sameName", new String[]{perspective.getName()});
        }
        this.savePerspectiveInternal(perspective);
        return perspective;
    }

    @Override
    public PerspectiveBase updatePerspective(PerspectiveBase perspective) throws Exception {
        boolean isPerspectiveNameUnique;
        if (perspective == null || perspective.getId() == null) {
            throw new IllegalArgumentException("Cannot update Perspective: the Perspective is not valid.");
        }
        PerspectiveBase existingPerspective = this.loadPerspective(perspective.getId());
        if (existingPerspective == null) {
            throw new PerspectiveException(String.format("There is no existing perspective with id '%s'.", perspective.getId()), "validation.perspective.notExisting");
        }
        if (!existingPerspective.getName().equals(perspective.getName()) && !(isPerspectiveNameUnique = this.isPerspectiveNameUnique(perspective.getName()))) {
            throw new PerspectiveException(String.format("A perspective with name '%s' already exists.", perspective.getName()), "validation.perspective.sameName", new String[]{perspective.getName()});
        }
        this.savePerspectiveInternal(perspective);
        return perspective;
    }

    @Override
    public Assignment saveAssignment(AssignmentBase assignmentBase) throws Exception {
        if (assignmentBase == null || assignmentBase.getAssignee() == null || assignmentBase.getPriority() == null || assignmentBase.getPriority() < 0 || assignmentBase.getPerspectiveId() == null) {
            throw new IllegalArgumentException();
        }
        AssignmentBase[] assignmentsForTheSameAssignee = this.loadByProperties(AssignmentBase.class, new KeyValuePair("version", CURRENT_VERSION), new KeyValuePair("assignee", assignmentBase.getAssignee().toString()));
        if (assignmentsForTheSameAssignee != null && assignmentsForTheSameAssignee.length > 0) {
            throw new PerspectiveException(String.format("There are existing perspectives assigned to '%s'.", assignmentBase.getAssignee()), "validation.assignment.alreadyAssigned", new String[]{assignmentBase.getAssignee().toString()});
        }
        PerspectiveBase perspective = this.loadPerspective(assignmentBase.getPerspectiveId());
        if (perspective == null) {
            throw new IllegalStateException(String.format("No Perspective with id '%s'.", assignmentBase.getPerspectiveId()));
        }
        this.saveAssignmentInternal(assignmentBase);
        return new Assignment(assignmentBase, perspective);
    }

    @Override
    public boolean reprioritize(AssignmentBase.AssignmentReprioritization[] assignmentReprioritizations) throws Exception {
        if (assignmentReprioritizations == null || assignmentReprioritizations.length == 0) {
            throw new IllegalArgumentException("Assignment reprioritizations are null or empty.");
        }
        if (!PerspectiveServiceImpl.isAssignmentReprioritizationValid(assignmentReprioritizations)) {
            throw new IllegalArgumentException("Reprioritization priorities are not valid.");
        }
        logger.debug((Object)"Reprioritization started.");
        AssignmentBase[] baseAssignments = this.loadByProperties(AssignmentBase.class, new KeyValuePair("version", CURRENT_VERSION));
        if (baseAssignments == null || baseAssignments.length == 0) {
            logger.warn((Object)"Assignment reprioritization invoked but no assignments found.");
            return false;
        }
        Map<String, AssignmentBase> assignmentsPerId = PerspectiveServiceImpl.toAssignmentMap(baseAssignments);
        for (AssignmentBase.AssignmentReprioritization assignmentReprioritization : assignmentReprioritizations) {
            AssignmentBase assignmentBaseToReprioritize = assignmentsPerId.get(assignmentReprioritization.getAssignmentId());
            if (assignmentBaseToReprioritize == null) {
                logger.error((Object)String.format("No assignment with id '%s' found.", assignmentReprioritization.getAssignmentId()));
                return false;
            }
            assignmentBaseToReprioritize.setPriority(assignmentReprioritization.getNewPriority());
        }
        if (PerspectiveServiceImpl.isAssignmentReprioritizationValid(baseAssignments)) {
            for (AssignmentBase.AssignmentReprioritization assignmentReprioritization : assignmentReprioritizations) {
                AssignmentBase assignmentToReprioritize = assignmentsPerId.get(assignmentReprioritization.getAssignmentId());
                this.saveAssignmentInternal(assignmentToReprioritize);
            }
            logger.debug((Object)"Reprioritization finished successfully.");
            return true;
        }
        logger.debug((Object)"Reprioritization will not have been valid if applied.");
        logger.debug((Object)"Reprioritization finished.");
        return false;
    }

    @Override
    public Perspective[] loadAllPerspectives() throws Exception {
        logger.debug((Object)"Loading all perspectives started.");
        PerspectiveBase[] basePerspectives = this.loadByProperties(PerspectiveBase.class, new KeyValuePair("version", CURRENT_VERSION));
        if (basePerspectives == null || basePerspectives.length == 0) {
            logger.debug((Object)"Loading all perspectives finished.");
            return new Perspective[0];
        }
        AssignmentBase[] baseAssignments = this.loadByProperties(AssignmentBase.class, new KeyValuePair("version", CURRENT_VERSION));
        Perspective[] perspectives = PerspectiveServiceImpl.groupAssignmentsInPerspectives(basePerspectives, baseAssignments);
        logger.debug((Object)"Loading all perspectives finished.");
        return perspectives;
    }

    @Override
    public Assignment[] loadAllAssignments() throws Exception {
        logger.debug((Object)"Loading all assignments started.");
        AssignmentBase[] baseAssignments = this.loadByProperties(AssignmentBase.class, new KeyValuePair("version", CURRENT_VERSION));
        if (baseAssignments == null) {
            return new Assignment[0];
        }
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        HashMap<String, PerspectiveBase> perspectivesById = new HashMap<String, PerspectiveBase>();
        for (AssignmentBase assignment : baseAssignments) {
            if (assignment == null) {
                logger.warn((Object)"An assignment could not be deserialized from JSON.");
                continue;
            }
            String perspectiveId = assignment.getPerspectiveId();
            if (perspectiveId == null) {
                logger.warn((Object)String.format("No perspectiveId for assignment '%s'.", assignment.getId()));
                continue;
            }
            PerspectiveBase perspectiveForAssignment = (PerspectiveBase)perspectivesById.get(perspectiveId);
            if (perspectiveForAssignment != null) {
                assignments.add(new Assignment(assignment, perspectiveForAssignment));
                continue;
            }
            try {
                perspectiveForAssignment = this.loadPerspective(perspectiveId);
                if (perspectiveForAssignment == null) {
                    logger.warn((Object)String.format("No perspective for assignment '%s'.", assignment.getId()));
                    continue;
                }
                perspectivesById.put(perspectiveForAssignment.getId(), perspectiveForAssignment);
                assignments.add(new Assignment(assignment, perspectiveForAssignment));
            }
            catch (Exception e) {
                logger.error((Object)String.format("Cannot deserialize perspective with id '%s'.", assignment.getPerspectiveId()), (Throwable)e);
            }
        }
        logger.debug((Object)"Loading all assignments finished.");
        return assignments.toArray(new Assignment[0]);
    }

    @Override
    public PerspectiveBase loadPerspectiveForAssignee(String assignee) throws Exception {
        String[] relevantAssignees = this.principalManagementService.findNestedParentGroups(assignee);
        if (relevantAssignees.length > 0) {
            List<AssignmentBase> relevantAssignments = this.loadAssignmentsForAssignees(relevantAssignees);
            Collections.sort(relevantAssignments);
            for (AssignmentBase relevantAssignment : relevantAssignments) {
                if (relevantAssignment.getPerspectiveId() == null) {
                    logger.warn((Object)String.format("Assignment with id '%s' does not have an associated perspective.", relevantAssignment.getId()));
                    continue;
                }
                PerspectiveBase perspective = this.loadPerspective(relevantAssignment.getPerspectiveId());
                if (perspective == null) {
                    logger.warn((Object)String.format("No perspective with id '%s'.", relevantAssignment.getPerspectiveId()));
                    continue;
                }
                return perspective;
            }
            return null;
        }
        return null;
    }

    @Override
    public UiRestriction loadUiRestrictionForAssignee(String assignee) throws Exception {
        String normalizedAssignee = assignee.toLowerCase();
        String[] relevantAssignees = this.principalManagementService.findNestedParentGroups(normalizedAssignee);
        if (relevantAssignees == null || relevantAssignees.length == 0) {
            return null;
        }
        List<AssignmentBase> relevantAssignments = this.loadAssignmentsForAssignees(relevantAssignees);
        HashSet<PerspectiveBase> relevantPerspectives = new HashSet<PerspectiveBase>();
        for (AssignmentBase relevantAssignment : relevantAssignments) {
            if (relevantAssignment.getPerspectiveId() == null) {
                logger.warn((Object)String.format("Assignment with id '%s' does not have an associated perspective.", relevantAssignment.getId()));
                continue;
            }
            PerspectiveBase perspective = this.loadPerspective(relevantAssignment.getPerspectiveId());
            if (perspective == null) {
                logger.warn((Object)String.format("No perspective with id '%s'.", relevantAssignment.getPerspectiveId()));
                continue;
            }
            relevantPerspectives.add(perspective);
        }
        if (relevantPerspectives.isEmpty()) {
            return null;
        }
        return new UiRestriction(relevantPerspectives);
    }

    @Override
    public PerspectiveBase loadPerspective(String perspectiveId) throws Exception {
        String persistencePath = PerspectiveServiceImpl.getPersistencePathForType(PerspectiveBase.class, perspectiveId);
        String perspectiveAsJsonString = this.persistenceService.loadData(PERSPECTIVE_UI_USER, persistencePath);
        if (perspectiveAsJsonString == null) {
            return null;
        }
        return this.objectMapper.readValue(perspectiveAsJsonString, PerspectiveBase.class);
    }

    @Override
    public void deletePerspective(String perspectiveId) throws Exception {
        if (this.loadPerspective(perspectiveId) == null) {
            return;
        }
        String persistencePath = PerspectiveServiceImpl.getPersistencePathForType(PerspectiveBase.class, perspectiveId);
        AssignmentBase[] assignmentsForPerspective = this.loadByProperties(AssignmentBase.class, new KeyValuePair("version", CURRENT_VERSION), new KeyValuePair("perspectiveId", perspectiveId));
        logger.debug((Object)String.format("Deleting Perspective '%s'...", perspectiveId));
        if (assignmentsForPerspective != null && assignmentsForPerspective.length > 0) {
            logger.debug((Object)String.format("Found '%d' assignments to delete along with Perspective '%s'.", assignmentsForPerspective.length, perspectiveId));
            for (AssignmentBase assignment : assignmentsForPerspective) {
                this.persistenceService.deleteData(PERSPECTIVE_UI_USER, PerspectiveServiceImpl.getPersistencePathForType(AssignmentBase.class, assignment.getId()));
            }
        }
        this.persistenceService.deleteData(PERSPECTIVE_UI_USER, persistencePath);
        logger.debug((Object)String.format("Perspective '%s' deleted.", perspectiveId));
    }

    @Override
    public void deleteAssignment(String assignmentId) throws Exception {
        if (this.loadAssignment(assignmentId) == null) {
            return;
        }
        logger.debug((Object)String.format("Deleting Assignment '%s'...", assignmentId));
        String persistencePath = PerspectiveServiceImpl.getPersistencePathForType(AssignmentBase.class, assignmentId);
        this.persistenceService.deleteData(PERSPECTIVE_UI_USER, persistencePath);
        logger.debug((Object)String.format("Assignment '%s' deleted.", assignmentId));
    }

    private boolean isPerspectiveNameUnique(String name) throws Exception {
        PerspectiveBase[] perspectivesWithTheSameName = this.loadByProperties(PerspectiveBase.class, new KeyValuePair("version", CURRENT_VERSION), new KeyValuePair("name", name));
        return perspectivesWithTheSameName == null || perspectivesWithTheSameName.length == 0;
    }

    private void savePerspectiveInternal(PerspectiveBase perspective) throws Exception {
        logger.debug((Object)String.format("Persisting Perspective '%s'...", perspective.toString()));
        String perspectiveAsJsonString = this.objectMapper.writeValueAsString(perspective);
        String persistencePath = PerspectiveServiceImpl.getPersistencePathForType(PerspectiveBase.class, perspective.getId());
        Map<String, String> properties = PerspectiveServiceImpl.toPropertyMap(new KeyValuePair("version", CURRENT_VERSION), new KeyValuePair("name", perspective.getName()));
        this.persistenceService.saveDataWithProperties(PERSPECTIVE_UI_USER, persistencePath, perspectiveAsJsonString, properties);
        logger.debug((Object)String.format("Perspective '%s' persisted.", perspective.getId()));
    }

    private AssignmentBase loadAssignment(String assignmentId) throws Exception {
        String persistencePath = PerspectiveServiceImpl.getPersistencePathForType(AssignmentBase.class, assignmentId);
        String assignmentAsJsonString = this.persistenceService.loadData(PERSPECTIVE_UI_USER, persistencePath);
        if (assignmentAsJsonString == null) {
            return null;
        }
        return this.objectMapper.readValue(assignmentAsJsonString, AssignmentBase.class);
    }

    private void saveAssignmentInternal(AssignmentBase assignmentBase) throws Exception {
        logger.debug((Object)String.format("Persisting Assignment '%s'...", assignmentBase.toString()));
        String assignmentAsJsonString = this.objectMapper.writeValueAsString(assignmentBase);
        String persistencePath = PerspectiveServiceImpl.getPersistencePathForType(AssignmentBase.class, assignmentBase.getId());
        Map<String, String> properties = PerspectiveServiceImpl.toPropertyMap(new KeyValuePair("version", CURRENT_VERSION), new KeyValuePair("perspectiveId", assignmentBase.getPerspectiveId()), new KeyValuePair("assignee", assignmentBase.getAssignee().toString()));
        this.persistenceService.saveDataWithProperties(PERSPECTIVE_UI_USER, persistencePath, assignmentAsJsonString, properties);
        logger.debug((Object)String.format("Assignment '%s' persisted.", assignmentBase.getId()));
    }

    private List<AssignmentBase> loadAssignmentsForAssignees(String[] assignees) {
        ArrayList<AssignmentBase> assignments = new ArrayList<AssignmentBase>(assignees.length);
        for (String relevantAssignee : assignees) {
            try {
                AssignmentBase[] currentAssignmentBase = this.loadByProperties(AssignmentBase.class, new KeyValuePair("version", CURRENT_VERSION), new KeyValuePair("assignee", relevantAssignee.toLowerCase()));
                if (currentAssignmentBase.length > 1) {
                    logger.warn((Object)String.format("There are multiple assignments for assignee '%s'.", relevantAssignee));
                    continue;
                }
                if (currentAssignmentBase.length == 0) continue;
                assignments.add(currentAssignmentBase[0]);
            }
            catch (Exception e) {
                logger.warn((Object)String.format("No assignment(s) for assignee '%s' could be loaded.", relevantAssignee), (Throwable)e);
            }
        }
        return assignments;
    }

    private <E> E[] loadByProperties(Class<E> type2, KeyValuePair ... properties) throws Exception {
        Map<String, String> propertyMap = PerspectiveServiceImpl.toPropertyMap(properties);
        String[] objectsAsJson = this.persistenceService.loadDataByProperties(PERSPECTIVE_UI_USER, PerspectiveServiceImpl.getCollectionNameForType(type2), propertyMap);
        if (objectsAsJson == null || objectsAsJson.length == 0) {
            Object[] entities = (Object[])Array.newInstance(type2, 0);
            return entities;
        }
        return this.objectMapper.fromJsonString(objectsAsJson, type2);
    }

    private static <E> String getCollectionNameForType(Class<E> type2) {
        return TYPE_TO_COLLECTION_INDEX.get(type2);
    }

    private static String getPersistencePathForType(Class<?> type2, String entityId) {
        return String.format("%s/%s", TYPE_TO_COLLECTION_INDEX.get(type2), entityId);
    }

    private static boolean isAssignmentReprioritizationValid(AssignmentBase.AssignmentReprioritization[] reprioritizations) {
        Integer[] priorities = new Integer[reprioritizations.length];
        for (int i = 0; i < reprioritizations.length; ++i) {
            priorities[i] = reprioritizations[i].getNewPriority();
        }
        return PerspectiveServiceImpl.isAssignmentReprioritizationValid(priorities);
    }

    private static boolean isAssignmentReprioritizationValid(AssignmentBase[] baseAssignments) {
        Integer[] priorities = new Integer[baseAssignments.length];
        for (int i = 0; i < baseAssignments.length; ++i) {
            priorities[i] = baseAssignments[i].getPriority();
        }
        return PerspectiveServiceImpl.isAssignmentReprioritizationValid(priorities);
    }

    private static boolean isAssignmentReprioritizationValid(Integer[] priorities) {
        HashSet<Integer> observedPriorities = new HashSet<Integer>(priorities.length);
        for (Integer priority : priorities) {
            if (priority == null || priority < 1 || observedPriorities.contains(priority)) {
                return false;
            }
            observedPriorities.add(priority);
        }
        return true;
    }

    private static Perspective[] groupAssignmentsInPerspectives(PerspectiveBase[] basePerspectives, AssignmentBase[] baseAssignments) {
        Perspective[] perspectives = new Perspective[basePerspectives.length];
        HashMap<String, LinkedList<AssignmentBase>> assignmentsPerPerspective = new HashMap<String, LinkedList<AssignmentBase>>();
        if (baseAssignments != null && baseAssignments.length > 0) {
            for (AssignmentBase assignmentBase : baseAssignments) {
                if (assignmentBase == null) continue;
                LinkedList<AssignmentBase> assignmentsForPerspective = (LinkedList<AssignmentBase>)assignmentsPerPerspective.get(assignmentBase.getPerspectiveId());
                if (assignmentsForPerspective == null) {
                    assignmentsForPerspective = new LinkedList<AssignmentBase>();
                    assignmentsPerPerspective.put(assignmentBase.getPerspectiveId(), assignmentsForPerspective);
                }
                assignmentsForPerspective.add(assignmentBase);
            }
        }
        for (int i = 0; i < basePerspectives.length; ++i) {
            if (basePerspectives[i] == null) continue;
            LinkedList assignmentsForPerspective = (LinkedList)assignmentsPerPerspective.get(basePerspectives[i].getId());
            perspectives[i] = assignmentsForPerspective == null || assignmentsForPerspective.isEmpty() ? new Perspective(basePerspectives[i], new AssignmentBase[0]) : new Perspective(basePerspectives[i], assignmentsForPerspective.toArray(new AssignmentBase[0]));
        }
        return perspectives;
    }

    private static Map<String, AssignmentBase> toAssignmentMap(AssignmentBase[] assignments) {
        HashMap<String, AssignmentBase> assignmentsPerId = new HashMap<String, AssignmentBase>();
        for (AssignmentBase assignment : assignments) {
            assignmentsPerId.put(assignment.getId(), assignment);
        }
        return assignmentsPerId;
    }

    private static Map<String, String> toPropertyMap(KeyValuePair ... keyValuePairs) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (KeyValuePair keyValuePair : keyValuePairs) {
            properties.put(keyValuePair.key, keyValuePair.value);
        }
        return properties;
    }

    static {
        TYPE_TO_COLLECTION_INDEX.put(PerspectiveBase.class, "perspectives");
        TYPE_TO_COLLECTION_INDEX.put(AssignmentBase.class, "assignments");
    }

    private static class KeyValuePair {
        private String key;
        private String value;

        private KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

