/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.tree;

import com.google.common.collect.Sets;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vsphere.client.h5.perspective.tree.ExtensionObjectTypeService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExtensionObjectTypeServiceImpl
implements ExtensionObjectTypeService {
    private static final String OBJECT_TYPE_EXTENSION_POINT_ID = "vsphere.core.objectTypes";
    private final ExtensionService extensionService;
    private final Map<String, ObjectTypeSpec> objectTypeSpecsPerType = new HashMap<String, ObjectTypeSpec>();
    private Set<ExtensionInfo> objectTypesExtensions;

    public ExtensionObjectTypeServiceImpl(ExtensionService extensionService) {
        this.extensionService = extensionService;
    }

    @Override
    public ObjectTypeSpec findForType(String objectTypeStr) {
        if (objectTypeStr == null || objectTypeStr.isEmpty()) {
            return null;
        }
        String[] objectTypes = objectTypeStr.split(",");
        if (objectTypes.length > 0) {
            for (String objectType : objectTypes) {
                ObjectTypeSpec candidateSpec = this.findForTypeInternal(objectType);
                if (candidateSpec == null) continue;
                return candidateSpec;
            }
        }
        return this.findForTypeInternal(objectTypeStr);
    }

    private ObjectTypeSpec findForTypeInternal(String objectType) {
        ObjectTypeSpec candidateObjectTypeSpec = this.objectTypeSpecsPerType.get(objectType);
        if (candidateObjectTypeSpec != null) {
            return candidateObjectTypeSpec;
        }
        Set<ExtensionInfo> objectTypesExtensions = this.retrieveRemainingObjectTypesExtensionInfos();
        for (ExtensionInfo objectTypeExtensionInfo : objectTypesExtensions) {
            String[] objectTypes;
            Object obj = this.extensionService.getExtensionObject(objectTypeExtensionInfo, null, true);
            if (obj instanceof ObjectTypeSpec && (objectTypes = ((ObjectTypeSpec)obj).types) != null && objectTypes.length > 0) {
                for (String currentObjectType : objectTypes) {
                    this.objectTypeSpecsPerType.put(currentObjectType, (ObjectTypeSpec)obj);
                }
            }
            this.objectTypesExtensions.remove(objectTypeExtensionInfo);
            candidateObjectTypeSpec = this.objectTypeSpecsPerType.get(objectType);
            if (candidateObjectTypeSpec == null) continue;
            return candidateObjectTypeSpec;
        }
        return null;
    }

    private Set<ExtensionInfo> retrieveRemainingObjectTypesExtensionInfos() {
        if (this.objectTypesExtensions == null) {
            Object[] allObjectTypeExtensions = this.extensionService.getExtensionInfos(OBJECT_TYPE_EXTENSION_POINT_ID);
            this.objectTypesExtensions = Sets.newHashSet((Object[])allObjectTypeExtensions);
        }
        return Sets.newHashSet(this.objectTypesExtensions);
    }
}

