/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.tree;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.model.ViewSpec;
import com.vmware.vsphere.client.h5.perspective.tree.ExtensionObjectTypeService;
import com.vmware.vsphere.client.h5.perspective.tree.PerspectiveTreeNode;
import com.vmware.vsphere.client.h5.perspective.tree.PerspectiveTreeNodeBuilderService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectViewTreeNodeBuilderService
implements PerspectiveTreeNodeBuilderService {
    private static final Log logger = LogFactory.getLog(ObjectViewTreeNodeBuilderService.class);
    private static final String SERVER_OBJECT_VIEWS_EXTENSION_POINT = "vsphere.core.inventory.serverObjectViews";
    private static final String OBJECT_TYPE_KEY = "objectType";
    private static final String PERSPECTIVE_NAME_KEY = "perspectivesName";
    private final ExtensionService extensionService;
    private final ExtensionObjectTypeService extensionObjectTypeService;

    public ObjectViewTreeNodeBuilderService(ExtensionService extensionService, ExtensionObjectTypeService extensionObjectTypeService) {
        this.extensionService = extensionService;
        this.extensionObjectTypeService = extensionObjectTypeService;
    }

    @Override
    public void populateNode(PerspectiveTreeNode.PerspectiveTreeNodePayload payload, ExtensionInfo extensionInfo) {
        if (payload == null || extensionInfo == null) {
            return;
        }
        Object objectTypeMetadataValue = extensionInfo.getMetadata().get(OBJECT_TYPE_KEY);
        ObjectTypeSpec objectTypeSpec = objectTypeMetadataValue instanceof String && SERVER_OBJECT_VIEWS_EXTENSION_POINT.equals(extensionInfo.getExtendedPointIds()[0]) ? this.extensionObjectTypeService.findForType((String)objectTypeMetadataValue) : null;
        if (objectTypeSpec != null) {
            payload.icon = objectTypeSpec.icon;
        }
        this.populateName(payload, extensionInfo, objectTypeSpec);
        payload.extensionId = extensionInfo.getId();
    }

    private void populateName(PerspectiveTreeNode.PerspectiveTreeNodePayload payload, ExtensionInfo extensionInfo, ObjectTypeSpec objectTypeSpec) {
        Object perspectivesNameMetadataValue = extensionInfo.getMetadata().get(PERSPECTIVE_NAME_KEY);
        if (perspectivesNameMetadataValue instanceof String && !((String)perspectivesNameMetadataValue).isEmpty()) {
            payload.name = (String)perspectivesNameMetadataValue;
        } else {
            Object extensionObject = null;
            try {
                extensionObject = this.extensionService.getExtensionObject(extensionInfo, null, true);
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Error while retrieving the extension object for extension with id '%s'.", extensionInfo.getId()), (Throwable)e);
            }
            if (extensionObject instanceof ViewSpec) {
                ViewSpec view = (ViewSpec)extensionObject;
                ViewSpec dummyView = new ViewSpec();
                payload.name = dummyView.name.equals(view.name) ? (objectTypeSpec != null ? objectTypeSpec.label : extensionInfo.getId()) : view.name;
            }
        }
    }
}

