/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.util;

import com.vmware.vim.binding.sso.PrincipalId;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.perspective.exception.PerspectiveException;

public abstract class PerspectiveUtil {
    private static final String RESOURCE_BUNDLE_NAME = "h5perspectiveservice";
    private static final ClassLoader CLASS_LOADER = PerspectiveUtil.class.getClassLoader();

    public static MethodFault getMethodFault(Exception e) {
        if (e instanceof PerspectiveException) {
            return MixedUtil.getMethodFault((Throwable)((PerspectiveException)e).getLocalizedException());
        }
        return MixedUtil.getMethodFault((Throwable)PerspectiveUtil.getLocalizedException("error.general", e));
    }

    public static Exception getLocalizedException(String localizationKey) {
        return new Exception(PerspectiveUtil.getLocalizedString(localizationKey));
    }

    public static Exception getLocalizedException(String localizationKey, Exception cause) {
        return new Exception(PerspectiveUtil.getLocalizedString(localizationKey), cause);
    }

    public static String getLocalizedString(String localizationKey) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)localizationKey, (ClassLoader)CLASS_LOADER);
    }

    public static String getLocalizedString(String localizationKey, String ... attributes) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)localizationKey, (String[])attributes, (ClassLoader)CLASS_LOADER);
    }

    public static String getDomain(String principalId) {
        if (principalId != null && principalId.contains("@")) {
            return principalId.substring(principalId.indexOf("@"));
        }
        return null;
    }

    public static PrincipalId toPrincipalId(String assignee) {
        if (assignee == null || !assignee.contains("@")) {
            return null;
        }
        String[] principalIdParts = assignee.split("@");
        PrincipalId principalId = new PrincipalId();
        principalId.name = principalIdParts[0];
        principalId.domain = principalIdParts[1];
        return principalId;
    }

    public static String toString(PrincipalId principalId) {
        if (principalId == null) {
            return null;
        }
        return String.format("%s@%s", principalId.getName(), principalId.getDomain());
    }

    public static String normalizeAssignee(String assignee) {
        PrincipalId principalId = PerspectiveUtil.toPrincipalId(assignee);
        if (principalId == null) {
            return assignee;
        }
        PrincipalId normalizedPrincipalId = new PrincipalId();
        normalizedPrincipalId.setName(principalId.getName());
        normalizedPrincipalId.setDomain(principalId.getDomain().toLowerCase());
        return PerspectiveUtil.toString(normalizedPrincipalId);
    }
}

