/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.actions;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.security.AuthorizationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostActionResolverPropertyProvider {
    private static final String RUNTIME_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String PARENT = "parent";
    private static final String DATACENTER_HOST_FOLDER = "hostFolder";
    private static final String DATACENTER_TYPE = Datacenter.class.getSimpleName();
    private static final String PARENT_CONFIG_INFO_VM_SWAP_PLACEMENT = "configurationEx.vmSwapPlacement";
    private static final String ADD_STANDALONE_HOST_PRIVILEGE = "Host.Inventory.AddStandaloneHost";
    private static final String DISABLED_METHODS_PROP = "disabledOperations";
    private static final String ADD_STANDALONE_HOST_TASK = "AddStandaloneHost_Task";
    private static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    private final QueryExecutor _queryExecutor;
    private final QueryService _queryService;

    public HostActionResolverPropertyProvider(QueryExecutor queryExecutor, QueryServiceFactory queryServiceFactory) {
        this._queryExecutor = queryExecutor;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="HostSystem/isHostSwapfileLocationEditAllow")
    public List<Boolean> getIsHostSwapfileLocationEditAllow(Collection<ManagedObjectReference> hostRefs) throws Exception {
        PropertyValue[] propValues = this._queryExecutor.getProperties((Object[])hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]), new String[]{RUNTIME_CONNECTION_STATE_PROPERTY, PARENT});
        HashMap propValuesByHost = new HashMap();
        HashMap<ManagedObjectReference, PropertyValue> vmSwapPlacementPropertyValueByCluster = new HashMap<ManagedObjectReference, PropertyValue>();
        for (ManagedObjectReference hostRef : hostRefs) {
            propValuesByHost.put(hostRef, new HashMap());
        }
        for (PropertyValue propValue : propValues) {
            ((Map)propValuesByHost.get(propValue.resourceObject)).put(propValue.propertyName, propValue);
        }
        ArrayList<ManagedObjectReference> parentClusterRefs = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference hostRef : hostRefs) {
            PropertyValue parentPropValue = (PropertyValue)((Map)propValuesByHost.get(hostRef)).get(PARENT);
            ManagedObjectReference parentRef = null;
            if (parentPropValue != null && parentPropValue.value != null) {
                parentRef = (ManagedObjectReference)parentPropValue.value;
            }
            if (parentRef == null || !parentRef.getType().equals(CLUSTER_TYPE)) continue;
            parentClusterRefs.add((ManagedObjectReference)parentPropValue.value);
        }
        if (!parentClusterRefs.isEmpty()) {
            PropertyValue[] propValuesForClusters;
            for (PropertyValue propValue : propValuesForClusters = this._queryExecutor.getProperties((Object[])parentClusterRefs.toArray(new ManagedObjectReference[parentClusterRefs.size()]), new String[]{PARENT_CONFIG_INFO_VM_SWAP_PLACEMENT})) {
                vmSwapPlacementPropertyValueByCluster.put((ManagedObjectReference)propValue.resourceObject, propValue);
            }
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (ManagedObjectReference hostRef : hostRefs) {
            PropertyValue connStatePropValue = (PropertyValue)((Map)propValuesByHost.get(hostRef)).get(RUNTIME_CONNECTION_STATE_PROPERTY);
            if (connStatePropValue == null || !this.isHostConnected(connStatePropValue.value).booleanValue()) {
                result.add(false);
                continue;
            }
            PropertyValue parentPropValue = (PropertyValue)((Map)propValuesByHost.get(hostRef)).get(PARENT);
            if (parentPropValue == null || !(parentPropValue.value instanceof ManagedObjectReference)) {
                result.add(false);
                continue;
            }
            ManagedObjectReference parentObject = (ManagedObjectReference)parentPropValue.value;
            if (!parentObject.getType().equals(CLUSTER_TYPE)) {
                result.add(true);
                continue;
            }
            PropertyValue parentClusterSwapPlacementPropValue = (PropertyValue)vmSwapPlacementPropertyValueByCluster.get(parentObject);
            if (parentClusterSwapPlacementPropValue == null) {
                result.add(false);
                continue;
            }
            result.add(!ConfigInfo.SwapPlacementType.vmDirectory.name().equals(parentClusterSwapPlacementPropValue.value));
        }
        return result;
    }

    @PropertyProvider(value="Datacenter/isAddHostToDatacenterAvailable")
    public boolean getIsAddHostToDatacenterAvailable(ManagedObjectReference managedObjectReference) {
        ResultSet resultSet = this._queryService.select(new String[]{DATACENTER_HOST_FOLDER}).from(new String[]{DATACENTER_TYPE}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)managedObjectReference).fetch();
        if (resultSet.getItems().isEmpty()) {
            return false;
        }
        ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(0);
        managedObjectReference = (ManagedObjectReference)resourceItem.get(DATACENTER_HOST_FOLDER);
        return this.canAddHost(managedObjectReference);
    }

    private boolean canAddHost(ManagedObjectReference target) {
        ResultSet resultSet = this._queryService.select(new String[]{"grantedPrivileges", DISABLED_METHODS_PROP}).from(new String[]{Folder.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)target).fetch();
        if (resultSet.getItems().size() == 0) {
            return false;
        }
        ResourceItem resourceItems = (ResourceItem)resultSet.getItems().get(0);
        String[] grantedPriv = (String[])resourceItems.get("grantedPrivileges");
        String[] disabledMethods = (String[])resourceItems.get(DISABLED_METHODS_PROP);
        return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{ADD_STANDALONE_HOST_PRIVILEGE}, (String[])grantedPriv) && AuthorizationUtil.isOperationAllowed((String[])new String[]{ADD_STANDALONE_HOST_TASK}, (String[])disabledMethods);
    }

    private Boolean isHostConnected(Object hostConnectionState) {
        Boolean isConnected = false;
        if (hostConnectionState instanceof HostSystem.ConnectionState) {
            HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)hostConnectionState;
            isConnected = connectionState == HostSystem.ConnectionState.connected;
        }
        return isConnected;
    }
}

