/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.CimMessageReader;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HealthStatus;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SensorDetails;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SensorStatus;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SystemEventData;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Sensor
implements Cloneable {
    private static final Log logger = LogFactory.getLog(Sensor.class);
    public String id;
    public String sensorId;
    public String parentId;
    public String name;
    public String sensorType;
    public String reading;
    public List<SensorDetails> details;
    public HealthStatus healthStatus = HealthStatus.HEALTH_STATUS_NOT_DEFINED;
    public Long timestamp;
    public Long selEntries;
    public List<SystemEventData> selEntriesList;
    public String rateUnits;
    public String fru;

    public List<SensorStatus> getStatus() {
        return Collections.singletonList(this.getSensorStatus(this.healthStatus));
    }

    public String getStatusMessage() {
        return this.getSensorStatus(this.healthStatus) != null ? this.getStatus().get((int)0).statusMessage : "";
    }

    public void setStatus(String value) {
        this.healthStatus = HealthStatus.getHealthStatus(value);
    }

    private SensorStatus getSensorStatus(HealthStatus healthStatus) {
        String statusKey = healthStatus.getStatusKey();
        return new SensorStatus(statusKey, this.getStatusMessage(statusKey));
    }

    private String getStatusMessage(String statusKey) {
        return StringUtil.isNullOrEmpty((String)statusKey) ? "" : CimMessageReader.getMessage(statusKey);
    }

    @JsonIgnore
    public boolean hasAlert() {
        return HealthStatus.HEALTH_STATUS_ALERT == this.healthStatus;
    }

    @JsonIgnore
    public boolean hasWarning() {
        return HealthStatus.HEALTH_STATUS_WARNING == this.healthStatus;
    }

    public Sensor clone() {
        Sensor result = null;
        try {
            Sensor duplicateSensor = (Sensor)super.clone();
            duplicateSensor.healthStatus = this.healthStatus;
            result = duplicateSensor;
        }
        catch (CloneNotSupportedException ex) {
            logger.error((Object)"Cannot clone sensor", (Throwable)ex);
        }
        return result;
    }

    public String toString() {
        String info = "Id: " + this.id + "\n" + "Parent id:" + this.parentId + "\nName: " + this.name + "\nSensor type: " + this.sensorType + "\nReading: " + this.reading;
        if (this.details != null && !this.details.isEmpty()) {
            info = info + "\nHas details";
            for (SensorDetails detail : this.details) {
                info = info + detail.toString();
            }
        } else {
            info = info + "\nNo details";
        }
        info = info + "\n";
        return info;
    }
}

