/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.moveHost.services;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vsphere.client.h5.host.moveHost.MoveHostSpec;
import com.vmware.vsphere.client.h5.host.moveHost.MoveVmsAndRpsConfigSpec;
import com.vmware.vsphere.client.h5.host.moveHost.services.MoveHostMutationHelperProvider;
import com.vmware.vsphere.client.mixed.ManagedEntityMoveSpec;
import java.util.HashMap;

public class MoveHostToClusterService {
    private static final String DPM_ENABLED_PROPERTY = "configurationEx.dpmConfigInfo.enabled";
    private MutationService _mutationService;
    private MoveHostMutationHelperProvider _moveHostMutationHelperProvider;

    public MoveHostToClusterService(MutationService mutationService, MoveHostMutationHelperProvider moveHostMutationHelperProvider) {
        this._mutationService = mutationService;
        this._moveHostMutationHelperProvider = moveHostMutationHelperProvider;
    }

    public OperationResult moveHostToDrsDisabled(ManagedObjectReference targetEntity, ManagedObjectReference hostRef, MoveHostSpec spec) throws Exception {
        boolean hostHasNestedRps = this._moveHostMutationHelperProvider.hostHasNestedRps(hostRef);
        OperationResult opResult = new OperationResult();
        ManagedEntityMoveSpec specToSendToMove = new ManagedEntityMoveSpec();
        specToSendToMove.entities = new ManagedObjectReference[]{hostRef};
        HashMap<MoveHostMutationHelperProvider.HelperConstants, Object> parameters = new HashMap<MoveHostMutationHelperProvider.HelperConstants, Object>();
        if (hostHasNestedRps) {
            parameters.put(MoveHostMutationHelperProvider.HelperConstants.showWarningDialog, true);
            parameters.put(MoveHostMutationHelperProvider.HelperConstants.clusterName, this._moveHostMutationHelperProvider.getEntityName(targetEntity));
            opResult.parameter = parameters;
            if (spec.allowLoosingNestedRps) {
                opResult = this._mutationService.apply((Object)targetEntity, (Object)specToSendToMove);
            }
        } else {
            opResult = this._mutationService.apply((Object)targetEntity, (Object)specToSendToMove);
        }
        return opResult;
    }

    public OperationResult moveHostToDrsEnabled(ManagedObjectReference targetEntity, ManagedObjectReference hostRef, MoveHostSpec spec) throws Exception {
        OperationResult opResult = new OperationResult();
        ManagedEntityMoveSpec specToSendToMove = new ManagedEntityMoveSpec();
        specToSendToMove.entities = new ManagedObjectReference[1];
        specToSendToMove.entities[0] = hostRef;
        HashMap<MoveHostMutationHelperProvider.HelperConstants, Object> parameters = new HashMap<MoveHostMutationHelperProvider.HelperConstants, Object>();
        parameters.put(MoveHostMutationHelperProvider.HelperConstants.showMovementDialog, true);
        parameters.put(MoveHostMutationHelperProvider.HelperConstants.dpmTurnedOn, this._moveHostMutationHelperProvider.isClusterServiceEnabled(DPM_ENABLED_PROPERTY, targetEntity));
        parameters.put(MoveHostMutationHelperProvider.HelperConstants.hostName, this._moveHostMutationHelperProvider.getEntityName(hostRef));
        parameters.put(MoveHostMutationHelperProvider.HelperConstants.hostRef, hostRef);
        MoveVmsAndRpsConfigSpec moveVmSpec = spec.moveVmsAndRpsConfigSpec;
        if (moveVmSpec.moveEnabled) {
            if (moveVmSpec.moveToRoot) {
                opResult = this._mutationService.apply((Object)targetEntity, (Object)specToSendToMove);
            } else if (moveVmSpec.moveToCustomRp) {
                specToSendToMove = this._moveHostMutationHelperProvider.createMoveCustomRpSpec(targetEntity, specToSendToMove, moveVmSpec);
                opResult = this._mutationService.apply((Object)targetEntity, (Object)specToSendToMove);
                if (opResult.error != null) {
                    parameters.put(MoveHostMutationHelperProvider.HelperConstants.unsuccessfulMovementOperation, true);
                    opResult.parameter = parameters;
                    opResult.error = null;
                }
            }
        } else {
            opResult.parameter = parameters;
        }
        return opResult;
    }
}

