/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.util;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.cluster.DasFdmAvailabilityState;
import com.vmware.vim.binding.vim.cluster.DasFdmHostState;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.commonservice.util.Util;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;

public class HostFormatUtil {
    private static String IMAGES_BUNDLE = "CommonImages";
    private static final String HYPERVISOR_TYPE_HYPERV = "hyperv";
    private static final String HYPERVISOR_TYPE_KVM = "kvm";
    private static final String HYPERVISOR_TYPE_VCHS = "vchs";

    public static String formatHaState(DasFdmHostState availabilityState) {
        if (!HostFormatUtil.isValidHaState(availabilityState).booleanValue()) {
            return "haState.NA";
        }
        return String.format("haState.%s", availabilityState.state);
    }

    public static String getHaStateImage(DasFdmHostState dasHostState) {
        String imageName = "statusUnknown";
        if (HostFormatUtil.isValidHaState(dasHostState).booleanValue()) {
            switch (DasFdmAvailabilityState.valueOf((String)dasHostState.state)) {
                case master: 
                case connectedToMaster: {
                    imageName = "statusGreen";
                    break;
                }
                case uninitialized: 
                case election: {
                    imageName = "statusYellow";
                    break;
                }
                case fdmUnreachable: 
                case hostDown: 
                case initializationError: 
                case networkIsolated: 
                case networkPartitionedFromMaster: 
                case uninitializationError: {
                    imageName = "statusRed";
                }
            }
        }
        return ResourceUtil.getString((String)IMAGES_BUNDLE, (String)imageName);
    }

    public static String formatUptime(int uptimeInSeconds) {
        if (uptimeInSeconds < 0) {
            return Util.getLocalizedString((String)"uptimeFormat.unknown");
        }
        int t = uptimeInSeconds;
        int s = t % 60;
        t = (t - s) / 60;
        int m = t % 60;
        t = (t - m) / 60;
        int h = t % 24;
        int d = t = (t - h) / 24;
        if (m < 2 && h < 1 && d < 1) {
            String result = String.valueOf(s += m * 60);
            if (s > 1) {
                return Util.getLocalizedString((String)"uptimeFormat.seconds", (String[])new String[]{result});
            }
            return Util.getLocalizedString((String)"uptimeFormat.second", (String[])new String[]{result});
        }
        if (h < 2 && d < 1) {
            String result = String.valueOf(m + h * 60);
            return Util.getLocalizedString((String)"uptimeFormat.minutes", (String[])new String[]{result});
        }
        if (d < 1) {
            String result = String.valueOf(h);
            return Util.getLocalizedString((String)"uptimeFormat.hours", (String[])new String[]{result});
        }
        String result = String.valueOf(d);
        return Util.getLocalizedString((String)"uptimeFormat.days", (String[])new String[]{result});
    }

    public static String formatHostConnectionState(HostSystem.ConnectionState state, boolean inMaintenanceMode, HostSystem.PowerState powerState) {
        if (state == null || powerState == null) {
            return "";
        }
        String key = null;
        switch (state) {
            case connected: {
                key = "hostState.connected";
                if (HostSystem.PowerState.standBy.equals((Object)powerState)) {
                    key = "hostState.standBy";
                }
                if (!inMaintenanceMode) break;
                key = "hostState.inMaintenance";
                break;
            }
            case notResponding: {
                key = "hostState.notResponding";
                if (!HostSystem.PowerState.standBy.equals((Object)powerState)) break;
                key = "hostState.standBy";
                break;
            }
            case disconnected: {
                key = "hostState.disconnected";
            }
        }
        return Util.getLocalizedString((String)key);
    }

    public static String formatHypervisorType(String hypervisorType) {
        String key = "hypervisorType.esx";
        if (hypervisorType != null) {
            switch (hypervisorType) {
                case "hyperv": {
                    key = "hypervisorType.hyperv";
                    break;
                }
                case "kvm": {
                    key = "hypervisorType.kvm";
                    break;
                }
                case "vchs": {
                    key = "hypervisorType.vchs";
                }
            }
        }
        return HostStringUtil.getString(key, new String[0]);
    }

    private static Boolean isValidHaState(DasFdmHostState dasState) {
        return dasState != null && dasState.state != null;
    }
}

