/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.mvc.model.AlienVcSpec;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.vim.commons.AlienVcDescriptor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.security.AuthData;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/alienvc"})
public class AlienVcController {
    public static final String CONTROLLER_PATH = "/alienvc";
    public static final String ADD_ALIEN_VC_PATH = "/add";
    public static final String REMOVE_ALIEN_VC_PATH = "/remove";
    public static final long DEFAULT_VC_PORT = 443L;
    private static final Log _logger = LogFactory.getLog(AlienVcController.class);
    @Nullable
    private final KeystoreService _keystoreService;

    @Autowired
    public AlienVcController(@Nullable KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public ServerInfo addAlienVc(@RequestBody AlienVcSpec vcSpec) throws Exception {
        Validate.notBlank((CharSequence)vcSpec.vcHostName, (String)"Need a FQDN or IP address of the VC to add to DS", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)vcSpec.sslThumbprintDigestAlgorithm)) {
            vcSpec.sslThumbprintDigestAlgorithm = "SHA-1";
        }
        if (vcSpec.vcPortNumber <= 0L) {
            vcSpec.vcPortNumber = 443L;
        }
        ServerInfoEx retVal = null;
        AuthData authData = new AuthData(vcSpec.username, vcSpec.password);
        String vcUrlWithPortNumber = vcSpec.vcHostName.trim() + ":" + Long.toString(vcSpec.vcPortNumber);
        AlienVcDescriptor descriptor = AlienVcDescriptor.newBuilder((String)vcUrlWithPortNumber, (AuthData)authData).trustStore(this._keystoreService != null ? this._keystoreService.getKeyStore() : null).thumbprintAndDigestAlgorithm(vcSpec.sslThumbprint, vcSpec.sslThumbprintDigestAlgorithm).build();
        try {
            VcService vc = VcServiceUtil.addAlienVc((AlienVcDescriptor)descriptor);
            retVal = VcServiceUtil.toServerInfoEx((VcService)vc);
            retVal.sessionCookie = "";
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to add alien VC to DS ", (Throwable)ex);
            throw ex;
        }
        return retVal;
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public void removeAlienVc(@RequestBody String vcObjectId) throws Exception {
        ManagedObjectReference vcMoref = ManagedObjectUtil.stringToMoref((String)vcObjectId);
        String vcGuid = vcMoref.getServerGuid();
        Validate.notBlank((CharSequence)vcGuid, (String)"Need an alienVc server-guid to be removed from DS", (Object[])new Object[0]);
        try {
            VcServiceUtil.removeAlienVcByGuid((String)vcGuid);
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not remove alienVc from dataservice ", (Throwable)ex);
        }
    }
}

