/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.model.data.FilterSpec;
import com.vmware.vise.mvc.model.data.MultiPropertyRequestSpec;
import com.vmware.vise.mvc.model.data.ParamSpec;
import com.vmware.vise.mvc.util.ParameterSpecHelper;
import com.vmware.vise.util.serialization.ObjectSerializer;
import com.vmware.vise.util.service.ClassLoaderService;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.vim.http.transport.data.IDownloadHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/data"}, method={RequestMethod.GET})
public class DataAccessController {
    private static final String OBJECT_ID = "id";
    private static final Log _logger = LogFactory.getLog(DataAccessController.class);
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private final ObjectReferenceService _objectReferenceService;
    private final ClassLoaderService _classLoaderService;
    private final ObjectSerializer _objectMapper;
    private final QueryBindingServiceFactory _queryBindingServiceFactory;
    private final QueryService _queryService;
    private final ServiceRegistry _serviceRegistry;

    @Autowired
    public DataAccessController(ObjectSerializer objectMapper, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ClassLoaderService classLoaderService, QueryBindingServiceFactory queryBindingServiceFactory, QueryServiceFactory queryServiceFactory, ServiceRegistry serviceRegistry) {
        this._objectMapper = objectMapper;
        this._objectReferenceService = objectReferenceService;
        this._classLoaderService = classLoaderService;
        this._queryBindingServiceFactory = queryBindingServiceFactory;
        this._queryService = queryServiceFactory.getQueryService();
        this._serviceRegistry = serviceRegistry;
    }

    @RequestMapping(value={"/{objectId:.*}"})
    @ResponseBody
    public <T> T getData(@PathVariable(value="objectId") String objectId, @RequestParam(value="model", required=true) String model, @RequestHeader(value="queryName", required=false) String queryName) throws ClassNotFoundException {
        if (StringUtils.isEmpty((CharSequence)model)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            queryName = this._opId;
        }
        Object ref = this._objectReferenceService.getReference(objectId, true);
        Class clazz = this._classLoaderService.loadClass(model);
        if (!clazz.isAnnotationPresent(QueryBinding.class)) {
            throw new UnsupportedOperationException("Not supported model class " + clazz);
        }
        QueryBindingService queryService = this._queryBindingServiceFactory.getQueryBindingService();
        Object dataModel = queryService.prepare(clazz).opId(queryName).fetch(ref);
        return (T)dataModel;
    }

    @RequestMapping(value={"/properties/{objectId:.*}"})
    @ResponseBody
    public Map<String, Object> getProperties(@PathVariable(value="objectId") String objectId, @RequestParam(value="properties", required=true) String properties, @RequestParam(value="resourceModels", required=false) String[] resourceModels, @RequestHeader(value="queryName", required=false) String queryName) throws Exception {
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            queryName = this._opId;
        }
        Map<String, Object> result = this.getPropertiesWithParams(objectId, properties, resourceModels, null, queryName);
        return result;
    }

    @RequestMapping(value={"/propertiesByRelation/{objectId:.*}"})
    @ResponseBody
    public Map<String, Object> getPropertiesForRelatedObject(@PathVariable(value="objectId") String objectId, @RequestParam(value="relation", required=true) String relation, @RequestParam(value="targetType", required=true) String[] targetTypes, @RequestParam(value="properties", required=true) String properties) throws Exception {
        String queryName = this._opId;
        Object ref = this._objectReferenceService.getReference(objectId, true);
        String[] props = properties == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.stripAll((String[])properties.split(","));
        ResultSet resultSet = this._queryService.select(props).from(targetTypes).where(relation, PropertyPredicate.ComparisonOperator.EQUAL, ref).opId(queryName).fetch();
        Map<String, Object> transformedResultSet = this.transformResults(resultSet, props);
        return transformedResultSet;
    }

    @RequestMapping(value={"/propertiesWithParameters/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getProperties(@PathVariable(value="objectId") String objectId, @RequestParam(value="properties", required=true) String properties, @RequestParam(value="resourceModels", required=false) String[] resourceModels, @RequestBody(required=false) ParamSpec[] parametersByPropertyName, @RequestHeader(value="queryName", required=false) String queryName) throws Exception {
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            queryName = this._opId;
        }
        ParameterSpecHelper helper = new ParameterSpecHelper(this._classLoaderService, this._objectMapper, parametersByPropertyName);
        Map<String, List<ParameterSpec>> paramSpecsByProperty = helper.getParameterSpecs();
        Map<String, Object> result = this.getPropertiesWithParams(objectId, properties, resourceModels, paramSpecsByProperty, queryName);
        return result;
    }

    @RequestMapping(value={"/propertiesByFilter"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getPropertiesByFilter(@RequestParam(value="properties", required=true) String properties, @RequestParam(value="resourceModels", required=true) String[] resourceModels, @RequestBody FilterSpec filterSpec, @RequestHeader(value="queryName", required=false) String queryName) throws Exception {
        Validate.notEmpty((Object[])resourceModels, (String)"The resource models can't be null or empty!");
        Validate.notNull((Object)filterSpec, (String)"No filter has been extracted from the request body!");
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            queryName = this._opId;
        }
        if (StringUtils.isEmpty((CharSequence)properties)) {
            return Collections.emptyMap();
        }
        String[] props = StringUtils.stripAll((String[])properties.split(","));
        ResultSet resultSet = !filterSpec.getCriteria().isEmpty() ? this._queryService.select(props).from(resourceModels).where(filterSpec.buildFilterFromSpec()).opId(queryName).fetch() : this._queryService.select(props).from(resourceModels).opId(queryName).fetch();
        return this.transformResults(resultSet, props);
    }

    @RequestMapping(value={"/multipleProperties"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getProperties(@RequestBody(required=false) MultiPropertyRequestSpec requestSpec, @RequestHeader(value="queryName", required=false) String queryName) throws Exception {
        if (requestSpec.objectIds == null || requestSpec.objectIds.length == 0) {
            return Collections.emptyMap();
        }
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            queryName = this._opId;
        }
        int objectCount = requestSpec.objectIds.length;
        Object[] objectRefs = new Object[objectCount];
        String targetType = null;
        String prevTargetType = null;
        for (int objectIndex = 0; objectIndex < objectCount; ++objectIndex) {
            objectRefs[objectIndex] = this._objectReferenceService.getReference(requestSpec.objectIds[objectIndex], true);
            targetType = this._objectReferenceService.getResourceObjectType(objectRefs[objectIndex]);
            Validate.isTrue((prevTargetType == null || prevTargetType.equals(targetType) ? 1 : 0) != 0, (String)"Cannot retrieve properties for heterogeneous object set.");
            prevTargetType = targetType;
        }
        ParameterSpecHelper helper = new ParameterSpecHelper(this._classLoaderService, this._objectMapper, requestSpec.params);
        Map<String, List<ParameterSpec>> paramSpecsByProperty = helper.getParameterSpecs();
        String[] resourceModels = ArrayUtils.isEmpty((Object[])requestSpec.resourceModels) ? new String[]{targetType} : requestSpec.resourceModels;
        List<PropertyPredicate> filter = this.buildFilterSpec(objectRefs, paramSpecsByProperty);
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            queryName = this._opId;
        }
        ResultSet resultSet = this._queryService.select(requestSpec.properties).from(resourceModels).where(LogicalOperator.AND, filter).opId(queryName).fetch();
        Map<String, Object> transformedResultSet = this.transformResults(resultSet, requestSpec.properties);
        return transformedResultSet;
    }

    @RequestMapping(value={"/download/{downloadPath:.*}"}, method={RequestMethod.GET})
    public void download(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="downloadPath") String downloadPath) throws Exception {
        List handlers = this._serviceRegistry.getServices(IDownloadHandler.class.getName());
        ArrayList<IDownloadHandler> applicableHandlers = new ArrayList<IDownloadHandler>();
        if (handlers != null && handlers.size() > 0) {
            applicableHandlers = new ArrayList();
            for (IDownloadHandler handler : handlers) {
                if (!handler.canHandleDownloadRequest(request, downloadPath)) continue;
                applicableHandlers.add(handler);
            }
        }
        if (applicableHandlers.size() == 1) {
            ((IDownloadHandler)applicableHandlers.get(0)).download(request, response);
        } else if (applicableHandlers.size() == 0) {
            response.sendError(404);
        } else {
            response.sendError(500);
            _logger.error((Object)String.format("Found more than one handler for path: %s", downloadPath));
            for (IDownloadHandler handler : applicableHandlers) {
                _logger.error((Object)String.format("Handler %s can handle path: %s", handler.getClass().getName(), downloadPath));
            }
        }
    }

    private Map<String, Object> transformResults(ResultSet resultSet, String[] requestedProperties) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object objRef = resourceItem.getKey();
            String objectId = this._objectReferenceService.getUid(objRef, true);
            HashMap<String, Object> propertiesPerObject = new HashMap<String, Object>();
            propsMap.put(objectId, propertiesPerObject);
            for (String property : requestedProperties) {
                propertiesPerObject.put(property, resourceItem.get(property));
            }
        }
        return propsMap;
    }

    private Map<String, Object> getPropertiesWithParams(String objectId, String properties, String[] models, Map<String, List<ParameterSpec>> paramSpecsByProperty, String queryName) {
        Object ref = this._objectReferenceService.getReference(objectId, true);
        String[] props = properties == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.stripAll((String[])properties.split(","));
        List<PropertyPredicate> filter = this.buildFilterSpec(new Object[]{ref}, paramSpecsByProperty);
        String[] resourceModels = models == null ? new String[]{this._objectReferenceService.getResourceObjectType(ref)} : models;
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            queryName = this._opId;
        }
        ResultSet resultSet = this._queryService.select(props).from(resourceModels).where(LogicalOperator.AND, filter).opId(queryName).fetch();
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object objRef = resourceItem.getKey();
            propsMap.put(OBJECT_ID, this._objectReferenceService.getUid(objRef, true));
            for (String property : props) {
                propsMap.put(property, resourceItem.get(property));
            }
        }
        return propsMap;
    }

    private List<PropertyPredicate> buildFilterSpec(Object[] objects, Map<String, List<ParameterSpec>> paramSpecsByProperty) {
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(objects)));
        if (paramSpecsByProperty != null && !paramSpecsByProperty.isEmpty()) {
            for (Map.Entry<String, List<ParameterSpec>> entry : paramSpecsByProperty.entrySet()) {
                for (ParameterSpec paramSpec : entry.getValue()) {
                    PropertyPredicate predicate = new PropertyPredicate(entry.getKey() + "/@param", PropertyPredicate.ComparisonOperator.EQUAL, paramSpec.parameter);
                    filter.add(predicate);
                }
            }
        }
        return filter;
    }
}

