/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.FileManager;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreBrowserItem;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreData;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreItem;
import com.vmware.vise.mvc.datastorebrowser.model.FileItem;
import com.vmware.vise.mvc.datastorebrowser.model.FolderItem;
import com.vmware.vise.mvc.util.CommonUtils;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.storage.FileSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datastoreBrowserTree"}, method={RequestMethod.GET})
public class DatastoreBrowserController {
    private final DataService _dataService;
    private final MutationService _mutationService;
    private final ObjectReferenceService _objReferenceService;
    private final String HOST_DATASTORE_BROWSER_TYPE = "HostDatastoreBrowser";
    private final String SEARCHABLE_DATASTORES_PROP_NAME = "searchableDatastore";
    private static final int VM_DISK_TYPE = 1;
    private static final int FLOPPY_IMAGE_TYPE = 2;
    private static final int ISO_IMAGE_TYPE = 4;
    private static final int VM_CONFIG_FILES_TYPE = 8;
    private static final String ALL_FILES_TYPE_STR = "0x0010";
    private static final int ALL_FILES_TYPE = Integer.parseInt("0x0010".replaceAll("0x", ""), 16);
    private static final int FOLDERS_TYPE = 32;
    private static final int VM_DISK_TYPE_WITH_DETAILS = 64;

    @Autowired
    public DatastoreBrowserController(DataService dataService, MutationService mutationService, @Qualifier(value="objectReferenceService") ObjectReferenceService objReferenceService) {
        this._dataService = dataService;
        this._mutationService = mutationService;
        this._objReferenceService = objReferenceService;
    }

    @ResponseBody
    @RequestMapping(value={"/root/{objectId}"})
    public List<DatastoreBrowserItem> getRoot(@PathVariable(value="objectId") String objectId, @RequestParam(value="datastores", required=false) String[] datastores, @RequestParam(value="showVmImagesFolder", required=false, defaultValue="false") boolean showVmImagesFolder) throws Exception {
        List<DatastoreBrowserItem> listItems = null;
        ManagedObjectReference targetObjectRef = (ManagedObjectReference)this._objReferenceService.getReference(objectId, true);
        if (targetObjectRef == null) {
            throw new IllegalArgumentException("Object id is invalid");
        }
        Object[] datastoreRefs = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetObjectRef, (String)"HostDatastoreBrowser")) {
            if (ArrayUtils.isEmpty((Object[])datastores)) {
                return null;
            }
            datastoreRefs = new ManagedObjectReference[datastores.length];
            int count = 0;
            for (String datastore : datastores) {
                ManagedObjectReference dsRef = (ManagedObjectReference)this._objReferenceService.getReference(datastore, true);
                datastoreRefs[count++] = dsRef;
            }
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetObjectRef, VirtualMachine.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)targetObjectRef, HostSystem.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)targetObjectRef, ComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)targetObjectRef, ClusterComputeResource.class)) {
            datastoreRefs = (ManagedObjectReference[])QueryUtil.getProperty((DataService)this._dataService, (Object)targetObjectRef, (String)"searchableDatastore");
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetObjectRef, Datastore.class)) {
            datastoreRefs = new ManagedObjectReference[]{targetObjectRef};
        }
        if (ArrayUtils.isEmpty((Object[])datastoreRefs)) {
            throw new IllegalArgumentException("No datastores to request data for");
        }
        listItems = this.getDatastoreItems((ManagedObjectReference[])datastoreRefs);
        if (showVmImagesFolder) {
            listItems.add(this.createVmImagesFolderItem());
        }
        return listItems;
    }

    @ResponseBody
    @RequestMapping(value={"/children/{objectId}"})
    public List<DatastoreBrowserItem> getChildren(@PathVariable(value="objectId") String objectId, @RequestParam(value="datastorePath", required=true) String datastorePath, @RequestParam(value="fileQueryType", required=false, defaultValue="0x0010") int fileQueryType, @RequestParam(value="pattern", required=false) String pattern, @RequestParam(value="searchInSubFolders", required=false, defaultValue="false") boolean searchInSubFolders) throws Exception {
        ArrayList<DatastoreBrowserItem> listItems = new ArrayList<DatastoreBrowserItem>();
        ManagedObjectReference targetObjectRef = (ManagedObjectReference)this._objReferenceService.getReference(objectId, true);
        if (targetObjectRef == null) {
            throw new IllegalArgumentException("Object id is invalid");
        }
        DatastoreBrowser.SearchSpec spec = this.createSearchSpec(fileQueryType, pattern, true);
        FileSpec fileSpec = this.createFileSpec(datastorePath, spec, searchInSubFolders);
        OperationResult opRes = this._mutationService.apply((Object)targetObjectRef, (Object)fileSpec);
        if (opRes.result == null) {
            if (opRes.error != null) {
                throw opRes.error;
            }
            return listItems;
        }
        DatastoreBrowser.SearchResults[] searchResults = null;
        if (opRes.result instanceof DatastoreBrowser.SearchResults) {
            searchResults = new DatastoreBrowser.SearchResults[]{(DatastoreBrowser.SearchResults)opRes.result};
        } else if (opRes.result.getClass().isArray()) {
            searchResults = (DatastoreBrowser.SearchResults[])opRes.result;
        } else {
            return listItems;
        }
        FolderItem item = null;
        for (DatastoreBrowser.SearchResults searchResult : searchResults) {
            if (searchResult.file == null) continue;
            for (DatastoreBrowser.FileInfo fileInfo : searchResult.file) {
                if (fileInfo instanceof DatastoreBrowser.FolderInfo) {
                    item = this.createFolderItem((DatastoreBrowser.FolderInfo)fileInfo, searchResult.folderPath);
                    listItems.add(item);
                } else if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
                    item = this.createFileItem(fileInfo, searchResult.folderPath);
                    DatastoreBrowser.VmDiskInfo diskInfo = (DatastoreBrowser.VmDiskInfo)fileInfo;
                    item.diskExtents = diskInfo.diskExtents;
                    listItems.add(item);
                } else {
                    item = this.createFileItem(fileInfo, searchResult.folderPath);
                    listItems.add(item);
                }
                item.localizedType = this.getLocalizedFileType(fileInfo);
                item.friendlyName = fileInfo.friendlyName;
            }
        }
        this.sortDatastoreItems(listItems);
        this.updateSortOrder(listItems);
        return listItems;
    }

    @ResponseBody
    @RequestMapping(value={"/isFileExists/{objectId}"})
    public boolean isFileExists(@PathVariable(value="objectId") String objectId, @RequestParam(value="filePath", required=true) String filePath, @RequestParam(value="fileQueryType", required=true) int fileQueryType) throws Exception {
        ManagedObjectReference targetObjectRef = (ManagedObjectReference)this._objReferenceService.getReference(objectId, true);
        Validate.notNull((Object)targetObjectRef, (String)"Object id is invalid", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)filePath, (String)"File path cannot be null", (Object[])new Object[0]);
        Integer fileNameSeparator = filePath.lastIndexOf(47);
        if (fileNameSeparator == -1) {
            fileNameSeparator = filePath.indexOf(93);
            if (fileNameSeparator == -1 || fileNameSeparator == filePath.length() - 1) {
                return false;
            }
            Integer n = fileNameSeparator;
            Integer n2 = fileNameSeparator = Integer.valueOf(fileNameSeparator + 1);
        }
        String dirPath = filePath.substring(0, fileNameSeparator);
        String fileName = filePath.substring(fileNameSeparator + 1);
        DatastoreBrowser.SearchSpec spec = this.createSearchSpec(fileQueryType, fileName, false);
        FileSpec fileSpec = this.createFileSpec(dirPath, spec, false);
        OperationResult opRes = this._mutationService.apply((Object)targetObjectRef, (Object)fileSpec);
        if (opRes.result == null) {
            return false;
        }
        DatastoreBrowser.SearchResults searchResults = (DatastoreBrowser.SearchResults)opRes.result;
        if (searchResults == null || ArrayUtils.isEmpty((Object[])searchResults.getFile())) {
            return false;
        }
        DatastoreBrowser.FileInfo fileInfo = searchResults.getFile()[0];
        return fileName.equals(fileInfo.getPath());
    }

    private void sortDatastoreItems(List<DatastoreBrowserItem> listItems) {
        Collections.sort(listItems, new Comparator<DatastoreBrowserItem>(){

            @Override
            public int compare(DatastoreBrowserItem o1, DatastoreBrowserItem o2) {
                if (o1.getType() == null) {
                    if (o2.getType() == null) {
                        return this.compareItemsByName(o1, o2);
                    }
                    return -1;
                }
                if (o2.getType() == null) {
                    return 1;
                }
                if (o1.getType().equals(o2.getType())) {
                    return this.compareItemsByName(o1, o2);
                }
                if (o1.getType().equals("folder")) {
                    return -1;
                }
                if (o2.getType().equals("folder")) {
                    return 1;
                }
                return this.compareItemsByName(o1, o2);
            }

            private int compareItemsByName(DatastoreBrowserItem o1, DatastoreBrowserItem o2) {
                String name2;
                String name1 = o1.friendlyName != null && !o1.friendlyName.isEmpty() ? o1.friendlyName : o1.name;
                String string = name2 = o2.friendlyName != null && !o2.friendlyName.isEmpty() ? o2.friendlyName : o2.name;
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
    }

    private void updateSortOrder(List<DatastoreBrowserItem> listItems) {
        int sortOrder = 0;
        for (DatastoreBrowserItem item : listItems) {
            item.nameSortOrder = sortOrder++;
        }
    }

    private List<DatastoreBrowserItem> getDatastoreItems(ManagedObjectReference[] datastoreRefs) {
        ArrayList<DatastoreBrowserItem> dsItems = new ArrayList<DatastoreBrowserItem>();
        DataFetchCommand dfc = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
        Collection data = dfc.execute(DatastoreData.class, (Object[])datastoreRefs);
        if (data == null) {
            return dsItems;
        }
        for (DatastoreData dsModel : data) {
            DatastoreItem dsItem = this.createDatastoreItem(dsModel);
            dsItems.add(dsItem);
        }
        return dsItems;
    }

    private DatastoreItem createDatastoreItem(DatastoreData dsModel) {
        DatastoreItem item = new DatastoreItem();
        item.name = dsModel.name;
        item.path = String.format("[%s]", dsModel.name);
        item.spriteCssClass = dsModel.primaryIconId;
        item.totalCapacity = FormatUtil.getStorageFormatted((Long)dsModel.totalCapacity, (long)1L, (long)-1L);
        item.availableCapacity = FormatUtil.getStorageFormatted((Long)dsModel.availableCapacity, (long)1L, (long)-1L);
        return item;
    }

    private FolderItem createVmImagesFolderItem() {
        return this.createFolderItem(null, null);
    }

    private FolderItem createFolderItem(DatastoreBrowser.FolderInfo folderInfo, String parentFolderPath) {
        FolderItem item = new FolderItem();
        item.spriteCssClass = "vsphere-icon-folder";
        if (folderInfo == null) {
            item.name = CommonUtils.text("vmImagesFolder.name");
            item.path = "<vmimages>";
        } else {
            item.name = folderInfo.path;
            item.path = this.getFilePath(item.name, parentFolderPath);
            item.lastModified = folderInfo.modification;
        }
        return item;
    }

    private FileItem createFileItem(DatastoreBrowser.FileInfo fileInfo, String parentFolderPath) {
        DatastoreBrowser.VmConfigInfo.VmConfigEncryptionInfo encryptionInfo;
        FileItem item = new FileItem();
        item.name = fileInfo.path;
        item.path = this.getFilePath(fileInfo.path, parentFolderPath);
        item.fileType = FileManager.FileType.File.name();
        item.className = fileInfo.getClass().getSimpleName();
        if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
            DatastoreBrowser.VmDiskInfo diskInfo = (DatastoreBrowser.VmDiskInfo)fileInfo;
            item.fileType = FileManager.FileType.VirtualDisk.name();
            item.isInflatable = this.isInflatable(diskInfo);
            encryptionInfo = diskInfo.encryption;
            boolean bl = item.isEncrypted = encryptionInfo != null && encryptionInfo.keyId != null;
        }
        if (fileInfo instanceof DatastoreBrowser.VmConfigInfo) {
            DatastoreBrowser.VmConfigInfo vmConfigInfo = (DatastoreBrowser.VmConfigInfo)fileInfo;
            encryptionInfo = vmConfigInfo.encryption;
            item.isEncrypted = encryptionInfo != null && encryptionInfo.keyId != null;
        }
        item.fileInfo = fileInfo;
        item.spriteCssClass = this.getFileIcon(fileInfo);
        item.lastModified = fileInfo.modification;
        item.size = fileInfo.fileSize;
        return item;
    }

    private boolean isInflatable(DatastoreBrowser.VmDiskInfo diskInfo) {
        return diskInfo != null && diskInfo.capacityKb != null && diskInfo.fileSize != null && diskInfo.thin == true && diskInfo.capacityKb * 1024L > diskInfo.fileSize;
    }

    private String getFilePath(String path, String parentFolderPath) {
        String result = null;
        String parentFolderPathTrimmed = StringUtils.trim((String)parentFolderPath);
        result = parentFolderPathTrimmed.endsWith("/") ? parentFolderPathTrimmed + path : (parentFolderPathTrimmed.endsWith("]") ? String.format("%s %s", parentFolderPathTrimmed, path) : String.format("%s/%s", parentFolderPathTrimmed, path));
        return result;
    }

    private String getFileIcon(DatastoreBrowser.FileInfo fileInfo) {
        if (fileInfo instanceof DatastoreBrowser.FloppyImageInfo) {
            return "icon-vSphere-dsFloppyImage";
        }
        if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
            return "icon-vSphere-dsVmDisk";
        }
        if (fileInfo instanceof DatastoreBrowser.VmLogInfo) {
            return "icon-vSphere-dsVmLog";
        }
        if (fileInfo instanceof DatastoreBrowser.VmNvramInfo) {
            return "icon-vSphere-dsVmNvram";
        }
        if (fileInfo instanceof DatastoreBrowser.IsoImageInfo) {
            return "icon-vSphere-dsIsoImage";
        }
        if (fileInfo instanceof DatastoreBrowser.VmSnapshotInfo) {
            return "icon-vSphere-dsVmSnapshot";
        }
        if (fileInfo instanceof DatastoreBrowser.TemplateVmConfigInfo) {
            return "icon-vSphere-dsVmTemplate";
        }
        if (fileInfo instanceof DatastoreBrowser.VmConfigInfo) {
            return "vsphere-icon-vm";
        }
        return "icon-vSphere-dsFile";
    }

    public String getLocalizedFileType(DatastoreBrowser.FileInfo fileInfo) {
        String typeKey = "";
        typeKey = fileInfo instanceof DatastoreBrowser.FloppyImageInfo ? "dsExplorer.floppyImage" : (fileInfo instanceof DatastoreBrowser.IsoImageInfo ? "dsExplorer.isoImage" : (fileInfo instanceof DatastoreBrowser.VmDiskInfo ? "dsExplorer.vmDisk" : (fileInfo instanceof DatastoreBrowser.TemplateVmConfigInfo ? "dsExplorer.templateVMConfig" : (fileInfo instanceof DatastoreBrowser.VmConfigInfo ? "dsExplorer.vmConfig" : (fileInfo instanceof DatastoreBrowser.VmLogInfo ? "dsExplorer.vmLog" : (fileInfo instanceof DatastoreBrowser.VmNvramInfo ? "dsExplorer.vmNvram" : (fileInfo instanceof DatastoreBrowser.VmSnapshotInfo ? "dsExplorer.vmSnapshot" : (fileInfo instanceof DatastoreBrowser.FolderInfo ? "dsExplorer.folder" : "dsExplorer.file"))))))));
        return CommonUtils.text(typeKey);
    }

    private FileSpec createFileSpec(String datastorePath, DatastoreBrowser.SearchSpec searchSpec, boolean searchInSubFolders) {
        FileSpec fileSpec = new FileSpec();
        fileSpec.datastorePath = datastorePath;
        fileSpec.subFolders = searchInSubFolders;
        fileSpec.searchSpec = searchSpec;
        return fileSpec;
    }

    private DatastoreBrowser.SearchSpec createSearchSpec(int fileQueryType, String pattern, boolean setSearchDetails) {
        ArrayList<Object> browserQuery = new ArrayList<Object>();
        if ((fileQueryType & 2) > 0) {
            browserQuery.add(new DatastoreBrowser.FloppyImageQuery());
        }
        if ((fileQueryType & 4) > 0) {
            browserQuery.add(new DatastoreBrowser.IsoImageQuery());
        }
        if ((fileQueryType & 1) > 0) {
            browserQuery.add(new DatastoreBrowser.VmDiskQuery());
        }
        if ((fileQueryType & 0x40) > 0) {
            DatastoreBrowser.VmDiskQuery vmDiskQuery = new DatastoreBrowser.VmDiskQuery();
            vmDiskQuery.details = new DatastoreBrowser.VmDiskQuery.Details();
            vmDiskQuery.details.capacityKb = true;
            vmDiskQuery.details.diskType = true;
            vmDiskQuery.details.thin = true;
            vmDiskQuery.details.hardwareVersion = true;
            vmDiskQuery.details.encryption = true;
            browserQuery.add(vmDiskQuery);
        }
        if ((fileQueryType & 8) > 0) {
            browserQuery.add(new DatastoreBrowser.VmConfigQuery());
            browserQuery.add(new DatastoreBrowser.TemplateVmConfigQuery());
        }
        if ((fileQueryType & 0x20) > 0) {
            browserQuery.add(new DatastoreBrowser.FolderQuery());
        }
        if ((fileQueryType & ALL_FILES_TYPE) > 0) {
            browserQuery.add(new DatastoreBrowser.FolderQuery());
            browserQuery.add(new DatastoreBrowser.FloppyImageQuery());
            browserQuery.add(new DatastoreBrowser.IsoImageQuery());
            DatastoreBrowser.VmConfigQuery vmConfigQuery = new DatastoreBrowser.VmConfigQuery();
            vmConfigQuery.details = new DatastoreBrowser.VmConfigQuery.Details();
            vmConfigQuery.details.encryption = true;
            browserQuery.add(vmConfigQuery);
            DatastoreBrowser.TemplateVmConfigQuery templateVmConfigQuery = new DatastoreBrowser.TemplateVmConfigQuery();
            templateVmConfigQuery.details = new DatastoreBrowser.VmConfigQuery.Details();
            templateVmConfigQuery.details.encryption = true;
            browserQuery.add(new DatastoreBrowser.TemplateVmConfigQuery());
            browserQuery.add(new DatastoreBrowser.VmLogQuery());
            browserQuery.add(new DatastoreBrowser.VmNvramQuery());
            browserQuery.add(new DatastoreBrowser.VmSnapshotQuery());
            DatastoreBrowser.VmDiskQuery vmDiskQuery = new DatastoreBrowser.VmDiskQuery();
            vmDiskQuery.details = new DatastoreBrowser.VmDiskQuery.Details();
            vmDiskQuery.details.capacityKb = true;
            vmDiskQuery.details.diskExtents = true;
            vmDiskQuery.details.thin = true;
            vmDiskQuery.details.encryption = true;
            browserQuery.add(vmDiskQuery);
            browserQuery.add(new DatastoreBrowser.Query());
        }
        DatastoreBrowser.SearchSpec searchSpec = new DatastoreBrowser.SearchSpec();
        searchSpec.query = browserQuery.toArray(new DatastoreBrowser.Query[0]);
        if (setSearchDetails) {
            searchSpec.searchCaseInsensitive = true;
            searchSpec.sortFoldersFirst = true;
            searchSpec.details = new DatastoreBrowser.FileInfo.Details();
            searchSpec.details.fileOwner = true;
            searchSpec.details.fileSize = true;
            searchSpec.details.fileType = true;
            searchSpec.details.modification = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)pattern)) {
            searchSpec.matchPattern = new String[]{pattern};
        }
        return searchSpec;
    }
}

