/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.mvc.events.EventFormatter;
import com.vmware.vise.mvc.events.model.EventListItemData;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class EventsViewController {
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private final ObjectReferenceService _objectReferenceService;
    private final ObjectTypesManager _objectTypesManager;
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryExecutor _queryExecutor;
    private final EventFormatter _eventFormatter;
    private static final String EVENT_TYPE = Event.class.getSimpleName();

    @Autowired
    public EventsViewController(ObjectReferenceService objectReferenceService, DataService dataService, ObjectTypesManager objectTypesManager, QuerySpecBuilder querySpecBuilder, QueryExecutor queryExecutor) {
        this._objectReferenceService = objectReferenceService;
        this._objectTypesManager = objectTypesManager;
        this._querySpecBuilder = querySpecBuilder;
        this._queryExecutor = queryExecutor;
        this._eventFormatter = new EventFormatter(this._objectReferenceService, this._objectTypesManager);
    }

    @RequestMapping(value={"/events"})
    @ResponseBody
    public List<EventListItemData> getEvents(@RequestParam(value="objectId", required=false) String objectId, @RequestParam(value="requestedPage", defaultValue="0") int requestedPage, @RequestParam(value="requestingPrevPage", defaultValue="false") boolean requestingPrevPage, @RequestParam(value="serverGuid", required=false) String serverGuid, @RequestParam(value="chainId", required=false) Integer chainId, @RequestParam(value="targetEventType", required=false) String targetEventType) throws Exception {
        CompositeConstraint constraint = new CompositeConstraint();
        constraint.conjoiner = Conjoiner.AND;
        ArrayList<PropertyConstraint> nestedConstraints = new ArrayList<PropertyConstraint>();
        if (targetEventType == null) {
            targetEventType = EVENT_TYPE;
        }
        PropertyConstraint pageConstraint = this.createPropertyConstraint("info.currentPage", requestedPage, targetEventType);
        nestedConstraints.add(pageConstraint);
        PropertyConstraint requestingPrevPageConstraint = this.createPropertyConstraint("requestingPrevPage", requestingPrevPage, targetEventType);
        nestedConstraints.add(requestingPrevPageConstraint);
        ManagedObjectReference contextObject = null;
        if (objectId != null) {
            Object objRef = this._objectReferenceService.getReference(objectId, true);
            PropertyConstraint propertyConstraint = this.createPropertyConstraint("info.entity", objRef, targetEventType);
            nestedConstraints.add(propertyConstraint);
            PropertyConstraint recursionConstraint = this.createPropertyConstraint("info.recursion", "recursion.all", targetEventType);
            nestedConstraints.add(recursionConstraint);
            if (objRef instanceof ManagedObjectReference) {
                contextObject = (ManagedObjectReference)objRef;
                PropertyConstraint serverConstraint = this.createPropertyConstraint("info.serverGuid", contextObject.getServerGuid(), targetEventType);
                nestedConstraints.add(serverConstraint);
            }
        }
        if (serverGuid != null) {
            PropertyConstraint serverConstraint = this.createPropertyConstraint("info.serverGuid", serverGuid, targetEventType);
            nestedConstraints.add(serverConstraint);
        }
        if (chainId != null) {
            PropertyConstraint chainConstraint = this.createPropertyConstraint("info.eventChainId", chainId, targetEventType);
            nestedConstraints.add(chainConstraint);
        }
        constraint.nestedConstraints = nestedConstraints.toArray(new Constraint[nestedConstraints.size()]);
        String[] requestedProperties = new String[]{"info", "taskInfoName", "contextSensitiveMessage"};
        QuerySpec query = this._querySpecBuilder.buildQuerySpec((Constraint)constraint, requestedProperties, Collections.singleton(EVENT_TYPE));
        query.name = this._opId;
        ParameterSpec contextSpec = new ParameterSpec();
        contextSpec.propertyName = "contextObject";
        contextSpec.parameter = contextObject;
        query.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{contextSpec};
        ResultSet resultSet = this._queryExecutor.getData(query);
        if (resultSet == null) {
            return null;
        }
        List<EventListItemData> result = this.formatResults(resultSet, contextObject, serverGuid);
        return result;
    }

    private PropertyConstraint createPropertyConstraint(String propertyName, Object comparableValue, String objectType) {
        return QueryUtil.createPropertyConstraint((String)objectType, (String)propertyName, (Comparator)Comparator.EQUALS, (Object)comparableValue);
    }

    private List<EventListItemData> formatResults(ResultSet rs, ManagedObjectReference contextObject, String serverGuid) {
        ArrayList<EventListItemData> itemDataResult = new ArrayList<EventListItemData>();
        for (ResultItem ri : rs.items) {
            EventListItemData eventData = new EventListItemData();
            for (PropertyValue pv : ri.properties) {
                if (pv.propertyName.equals("taskInfoName")) {
                    eventData.taskInfoName = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals("contextSensitiveMessage")) {
                    eventData.contextSensitiveMessage = (String)pv.value;
                    continue;
                }
                if (!pv.propertyName.equals("info")) continue;
                this._eventFormatter.setEventListItemData(eventData, (ClientEventInfo)pv.value);
            }
            itemDataResult.add(eventData);
        }
        return itemDataResult;
    }
}

