/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.store.UserData;
import com.vmware.vise.store.UserDataMetadata;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.i18n.CatalogManager;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class I18nController {
    private static final String LOCALE_USER_DATA_UID = "com.vmware.usersettings.preferredLocale";
    private final PersistenceService _persistenceService;
    private static final Log _logger = LogFactory.getLog(I18nController.class);

    public I18nController(PersistenceService persistenceService) {
        this._persistenceService = persistenceService;
    }

    @RequestMapping(value={"/changeLocale"}, method={RequestMethod.POST})
    public final void changeLocale(@RequestBody Map<String, String> arguments) throws Exception {
        String localeKey = arguments.get("locale");
        if (localeKey == null) {
            throw new Exception("Passed locale is null");
        }
        ResourceUtil.updateLocale((HttpServletRequest)SessionUtil.getHttpRequest(), (String)localeKey);
        String updateUserPreferencePolicy = arguments.get("updateUserPreferencePolicy");
        if (UserPreferencePolicy.SAVE.name().equals(updateUserPreferencePolicy)) {
            UserDataMetadata metadata = new UserDataMetadata();
            metadata.uid = LOCALE_USER_DATA_UID;
            metadata.additionalData = Collections.singletonMap("uid", LOCALE_USER_DATA_UID);
            UserData userData = new UserData();
            userData.metadata = metadata;
            userData.value = localeKey;
            this._persistenceService.setUserData(userData, false, null);
        } else if (UserPreferencePolicy.REMOVE.name().equals(updateUserPreferencePolicy)) {
            this._persistenceService.removeUserData(new String[]{LOCALE_USER_DATA_UID}, null, null);
        } else {
            _logger.error((Object)("Invalid user preference: " + updateUserPreferencePolicy));
        }
        SessionUtil.removeData((String)"resourceManager");
        CatalogManager catalogManager = LocalizationUtil.getCatalogManager();
        if (catalogManager == null) {
            _logger.error((Object)"CatalogManager is not initialized.");
            throw new Exception("Couldn't change locale. Please check the logs details.");
        }
        catalogManager.synchronizeCatalogs();
        LinkedVcGroupRegistry vcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (vcGroupRegistry == null) {
            _logger.error((Object)"Cannot change VC session locale because the LinkedVcGroupRegistry is null.");
            throw new Exception("Couldn't change locale. Please check the logs details.");
        }
        LinkedVcGroup[] groups = vcGroupRegistry.getLinkedVcGroups();
        if (groups == null) {
            _logger.error((Object)"Cannot change VC session locale because the LinkedVcGroups are null.");
            throw new Exception("Couldn't change locale. Please check the logs details.");
        }
        ArrayList<Pair> futures = new ArrayList<Pair>();
        for (LinkedVcGroup group : groups) {
            Collection vcServices = group.getVcServices();
            if (vcServices == null) continue;
            for (VcService service : vcServices) {
                ManagedObjectReference sessionManagerRef = service.getServiceInstanceContent().getSessionManager();
                SessionManager sessionManager = (SessionManager)service.getManagedObject(sessionManagerRef);
                SetLocaleFuture future = new SetLocaleFuture(localeKey, service.getServiceUrl());
                sessionManager.setLocale(localeKey, (Future)future);
                futures.add(new Pair((Object)future, (Object)service.getServiceUrl()));
            }
        }
        for (Pair pair : futures) {
            try {
                ((Future)pair.first).get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                _logger.error((Object)("Error getting SetLocaleFuture for " + (String)pair.second), (Throwable)e);
            }
        }
    }

    private static class SetLocaleFuture
    extends BlockingFuture<Void> {
        private final String _locale;
        private final String _serverUrl;

        private SetLocaleFuture(String locale, String serverUrl) {
            this._locale = locale;
            this._serverUrl = serverUrl;
        }

        public void setException(Exception e) {
            _logger.error((Object)("Error setting locale to : " + this._locale + " for VC: " + this._serverUrl), (Throwable)e);
        }
    }

    private static enum UserPreferencePolicy {
        SAVE,
        REMOVE;

    }
}

