/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorNavigationManager;
import com.vmware.vise.mvc.objectnavigator.model.CategoryNode;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/navigator"})
public class ObjectNavigatorController {
    private final ObjectNavigatorManager _objectNavigatorManager;
    private final ObjectNavigatorNavigationManager _objectNavigatorNavigationManager;

    @Autowired
    public ObjectNavigatorController(ObjectNavigatorManager objectNavigatorManager, ObjectNavigatorNavigationManager objectNavigatorNavigationManager) {
        this._objectNavigatorManager = objectNavigatorManager;
        this._objectNavigatorNavigationManager = objectNavigatorNavigationManager;
    }

    @RequestMapping(value={"/root"}, method={RequestMethod.GET})
    @ResponseBody
    public CategoryNode getRootElement() throws Exception {
        CategoryNode result = this._objectNavigatorManager.getRoot(this._objectNavigatorManager.getNodeSpecs());
        return result;
    }

    @RequestMapping(value={"/node"}, method={RequestMethod.GET})
    @ResponseBody
    public CategoryNode getCategoryNode(@RequestParam(value="nodeId", required=false) String nodeId) throws Exception {
        CategoryNode rootCategoryNode;
        List<ObjectNavigatorNodeSpec> nodeSpecs = this._objectNavigatorManager.getNodeSpecs();
        if (nodeId == null || StringUtils.isEmpty((CharSequence)nodeId)) {
            CategoryNode root = this._objectNavigatorManager.getRoot(nodeSpecs);
            if (root == null) {
                return null;
            }
            nodeId = root.uid;
        }
        if ((rootCategoryNode = this._objectNavigatorManager.getCategoryNode(nodeId, nodeSpecs)) == null) {
            return null;
        }
        Set<String> validUids = this._objectNavigatorManager.getValidExtensionUids(rootCategoryNode);
        if (!validUids.contains(rootCategoryNode.uid)) {
            return null;
        }
        ObjectNavigatorController.pruneInvalidCategoryNodes(rootCategoryNode.children, validUids);
        return rootCategoryNode;
    }

    private static void pruneInvalidCategoryNodes(List<CategoryNode> categoryNodes, Set<String> validUids) {
        if (categoryNodes == null || categoryNodes.isEmpty()) {
            return;
        }
        Iterator<CategoryNode> iterator = categoryNodes.iterator();
        while (iterator.hasNext()) {
            CategoryNode categoryNode = iterator.next();
            if (!validUids.contains(categoryNode.uid)) {
                iterator.remove();
                continue;
            }
            ObjectNavigatorController.pruneInvalidCategoryNodes(categoryNode.children, validUids);
        }
    }

    @RequestMapping(value={"/navigate/{targetViewId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public NavigationResponse handleNavigation(@PathVariable(value="targetViewId") String targetViewId, @RequestParam(value="context", required=false) String context, @RequestParam(value="navigator", required=false) String navigator, @RequestParam(value="prevNavigator", required=false) String prevNavigator) throws Exception {
        NavigationResponse result = this._objectNavigatorNavigationManager.handleNavigationRequest(targetViewId, context, navigator, prevNavigator);
        return result;
    }
}

